/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExtractedMethod;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;

public class Deref
extends Node {
    public Deref() {
    }

    public Deref(Token t) {
        this(new Identifier(t));
    }

    public Deref(AST ast) {
        this.setOperand((Node)ast);
    }

    public Deref(Node n) {
        this(n, n.getScope());
    }

    Deref(Node n, Scope scp) {
        this.setParent(n.getParent());
        this.setOperand(n);
        this.initialize(n);
        this.setScope(scp);
    }

    @Override
    public Node getTargetValue() {
        return this.getFirst();
    }

    @Override
    public String getText() {
        return "deref";
    }

    @Override
    public String getTypeText() {
        return this.getOp1().getText();
    }

    @Override
    public Symbol getSymbol() {
        return this.getOp1().getSymbol();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1());
    }

    static Deref variable(String var, Node init) {
        Deref deref = new Deref(new Identifier(var, init));
        deref.initialize(init);
        return deref;
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    @Override
    boolean isFirstSymbolUse() {
        return super.isFirstSymbolUse() || this.getOp1().isFirstSymbolUse();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node op = this.getOp1();
        op.checkFlow(context);
        context.breaksFlow(false);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(-1);
    }

    @Override
    Node checkType(int reqKind) throws TypeException {
        Argument argument;
        if (this.getKind() != -1) {
            return this;
        }
        Node node = this.getOp1();
        this.initialize(node);
        Node var = node.checkType(reqKind);
        if (var == null) {
            try {
                TypeDescription objectType = TypeSpec.findType(node instanceof TypeSpec ? node : this);
                TypeSpec typeSpec = new TypeSpec(objectType, this.getOp1());
                typeSpec.setParent(this);
                var = MemberAccess.defaultInstanceFor(objectType, typeSpec, true);
            }
            catch (AmbiguousComponentNameException e) {
            }
            catch (NoSuchComponentException e) {
                // empty catch block
            }
            if (var == null) {
                throw new UndefinedVariableException(node);
            }
        }
        if (Deref.isMemberReferenceNode(var) || var.isConstant() || var instanceof Deref) {
            return var;
        }
        this.setOperand(var);
        TypeDescription type = var.getTypeDescription();
        this.setTypeDescription(type);
        Symbol symbol = this.getSymbol();
        Node result = this;
        if (symbol != null && (argument = symbol.getArgument()) != null && argument.isExternal()) {
            result = Conversion.Import.create(result, argument.getJavaType(), argument.getType()).checkType();
        }
        return result;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.isParametric()) {
            this.setParameter(true);
            params.add(this);
        }
        return params;
    }

    @Override
    void extractArguments(ExtractedMethod method) {
        method.addArgument(this);
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.isParameter() ? " ? " : this.getColumnReference().getSignature());
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object value = this.getOp1().run(rm);
        Symbol symbol = this.getOp1().getSymbol();
        if (symbol != null && symbol.isHolder()) {
            if (value instanceof Symbol) {
                Symbol s = (Symbol)value;
                value = s.getValue();
            }
            value = this.getHolderValue(value);
        }
        return value;
    }

    private static boolean isMemberReferenceNode(Node var) {
        Node current = var;
        boolean isMemberReference = false;
        while (current != null && !isMemberReference) {
            if (current instanceof MemberReference) {
                isMemberReference = true;
                continue;
            }
            if (!current.isConversion()) {
                current = null;
                continue;
            }
            current = current.getOp1();
        }
        return isMemberReference;
    }
}

