/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class DeprecatedException
extends TypeException {
    static final long serialVersionUID = -7888327891629845531L;
    static final long serialCheck = 1027774978044797757L;

    public DeprecatedException(Node node, MethodTypeDescription member) {
        super(node);
        String replacement = member.getReplacement();
        String name = member.getName();
        TypeDescription parent = member.getParent();
        String detail = member.getProperty("deprecatedMessage");
        if (replacement != null) {
            this.setKey(CompilerMsg.REPLACED_MEMBER(name, DeprecatedException.text(parent, node), replacement));
        } else if (detail != null && detail.length() > 0) {
            this.setKey(CompilerMsg.DEPRECATED_MEMBER_DETAIL(detail));
        } else {
            this.setKey(CompilerMsg.DEPRECATED_MEMBER(name, DeprecatedException.text(parent, node)));
        }
    }
}

