/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.LegacyGroupArray;
import oracle.bpm.xobject.GroupArray;

public class DefaultConst
extends Const {
    private static final String LEGACY_GROUP_ARRAY = "oracle.bpm.util.LegacyGroupArray";
    private static final String GROUP_ARRAY = "oracle.bpm.xobject.GroupArray";

    DefaultConst(Node n, TypeDescription type) {
        super(null, type);
        MethodTypeDescription constr;
        assert (type.isObject() || type.isArray() || type.isSet()) : type;
        this.setParent(n);
        this.initialize(n);
        if (type.isObject() && type.hasDefaultInit() && (constr = type.findMethod(type.getName(), TypeFinder.Scope.CURRENT)) != null) {
            Args args = new Args(1L);
            args.initialize(this);
            Invoke constrCall = new Invoke(null, constr, args, false);
            constrCall.setExpression(true);
            constrCall.setParent(this);
            try {
                this.setFirst(constrCall.checkType());
            }
            catch (TypeException e) {
                this.reportError(e);
            }
        }
    }

    @Override
    public String getText() {
        TypeDescription typeDescription = this.getTypeDescription();
        if (typeDescription.isArray() || typeDescription.isSet()) {
            return super.getText() + " default array";
        }
        if (typeDescription.isObject()) {
            return super.getText() + " default object";
        }
        assert (false) : "DefaultConst can only be used for arrays or objects.: " + typeDescription;
        return "abnormal";
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static boolean isGroupArray(TypeDescription type) {
        String javaType = type.getJavaType();
        return type.isArray() && (LEGACY_GROUP_ARRAY.equals(javaType) || GROUP_ARRAY.equals(javaType));
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    @Override
    boolean isInitialized() {
        return this.getTypeDescription().hasDefaultInit();
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        query.append(" ? ");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        try {
            Object result;
            TypeDescription type = this.getTypeDescription();
            FuegoCompiler compiler = this.getCompiler();
            if (!type.isObject()) {
                String javaType = type.getJavaType();
                if (DefaultConst.isGroupArray(type)) {
                    Object[] args;
                    Object[] objectArray;
                    TypeDescription elementType = type.getElementType();
                    if (!elementType.isBpmObject()) {
                        throw new IllegalStateException("Invalid element type for group array. It should be a FuegoObject but it is: " + elementType.getText());
                    }
                    ObjectClass cl = ObjectClass.getOrCreate(compiler, elementType);
                    MethodTypeDescription constructor = elementType.findMember(elementType.getName());
                    String signature = MemberAccess.getSignature(elementType, constructor);
                    ObjectClass currentClass = this.getCurrentClass();
                    Symbol currentSymbol = currentClass.getSymbol();
                    if (currentSymbol != null) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = currentSymbol.getValue();
                    } else {
                        objectArray = args = null;
                    }
                    result = DefaultConst.isLegacyGroupArray(type) ? new LegacyGroupArray(cl.getInvocator(), signature, args) : new GroupArray(cl.getInvocator(), signature, args);
                } else {
                    Class<?> javaClass = JavaClass.loadByJavaType(javaType);
                    result = DefaultValue.forClass(javaClass, true);
                }
            } else {
                result = this.hasChildren() ? this.getFirst().run(rm) : type.newInstance();
            }
            return result;
        }
        catch (ComponentExecutionException e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
    }

    private static boolean isLegacyGroupArray(TypeDescription type) {
        String javaType = type.getJavaType();
        return type.isArray() && LEGACY_GROUP_ARRAY.equals(javaType);
    }
}

