/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DuplicatedDeclarationException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.Variable;

public class Declaration
extends Ternary {
    private boolean defaultInit = true;
    private Symbol symbol;
    private FlowContext.Variable var;

    public Declaration() {
    }

    public Declaration(Token t) {
        super(t);
    }

    public Declaration(String id, TypeRef type, Node initialValue) {
        this((AST)new Identifier(id), (AST)new TypeSpec(type.get(), (Token)null), (AST)initialValue);
    }

    public Declaration(AST id, AST type, AST initialValue) {
        super(id, type, initialValue);
    }

    Declaration(Variable var) {
        this((AST)new Identifier(var.getName()), (AST)new TypeSpec(var.getType(), (Node)null), null);
    }

    Declaration(Symbol symbol, Node position) throws TypeException {
        this.setParent(position);
        this.initialize(position);
        this.symbol = symbol;
        TypeDescription type = symbol.getType();
        this.setTypeDescription(type);
        Const initValue = Const.defaultValue(type, position);
        this.defaultInit = initValue.isInitialized();
        Node init = initValue;
        if (symbol.isExternalArgument()) {
            LocalVar local = new LocalVar(symbol, position);
            init = new Assignment(local, init);
            init = init.checkType();
        }
        init.setSynthetic(true);
        this.setOperands(new Identifier(symbol.getName()), new TypeSpec(symbol.getType(), position), init);
    }

    public static Declaration make(Node ids, Node typeSpec) {
        Declaration result = null;
        Node last = null;
        while (ids != null && ids instanceof Identifier) {
            Node next = ids.getNext();
            Declaration decl = new Declaration((AST)ids, (AST)Declaration.deepCopy(typeSpec), null);
            if (last != null) {
                last.setNext(decl);
            } else {
                result = decl;
            }
            last = decl;
            ids = next;
        }
        return result;
    }

    public Node getDeclType() {
        return this.getOp2();
    }

    public Node getInit() {
        return this.getOp3();
    }

    public String getName() {
        return this.getOp1().getText();
    }

    @Override
    public String getText() {
        if (this.symbol != null) {
            return "declare " + this.symbol.getName() + "::" + this.getTypeDescription();
        }
        return "declare";
    }

    public boolean isUsed() {
        return this.var != null && this.var.needsCode();
    }

    public void changeType(TypeDescription newType) {
        SymbolTable symbols;
        Symbol symbol;
        String name = this.getName();
        MethodTypeDescription method = this.getCurrentMember().getMethodType();
        Variable var = method.findVariable(name);
        if (var != null) {
            var.setType(newType);
        }
        if (this.getKind() != -1 && (symbol = (symbols = this.getSymbolTable()).getLocal(name)) != null) {
            symbol.setType(newType);
        }
        Node declType = this.getDeclType();
        declType.replace(new TypeSpec(newType, declType));
    }

    public void rename(String newName) {
        String name = this.getName();
        if (!name.equals(newName)) {
            MethodTypeDescription method = this.getCurrentMember().getMethodType();
            Variable var = method.findVariable(name);
            if (var != null) {
                var.setName(newName);
            }
            this.getOp1().replace(new Identifier(newName));
        }
        if (this.getKind() != -1) {
            // empty if block
        }
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public Node checkType() throws TypeException {
        Node init;
        if (this.symbol != null) {
            return this;
        }
        Node id = this.getOp1();
        Node type = this.getOp2().checkType();
        TypeDescription td = type.getTypeDescription();
        this.setTypeDescription(td);
        TypeSpec.checkValid(td, this);
        if (Declaration.isDuplicated(this.getOp1())) {
            this.reportError(new DuplicatedDeclarationException(this.getOp1()));
        }
        SymbolTable symbols = this.getSymbolTable();
        this.symbol = new Symbol(id.getText(), td);
        symbols.put(this.symbol);
        if (type instanceof TypeSpec.Enum) {
            Symbol typeSymbol = new Symbol(td.getName(), td);
            typeSymbol.setTypeSpec(true);
            symbols.put(typeSymbol);
        }
        if ((init = this.getOp3()) == null || init instanceof Identifier) {
            Const c = Const.defaultValue(td, this);
            c.initialize(this);
            this.defaultInit = c.isInitialized();
            init = c;
        } else {
            boolean isSynthetic = init.isSynthetic();
            TypeDescription itd = (init = init.checkType()).getTypeDescription();
            if (!td.isAssignableFrom(itd)) {
                this.reportError(new InvalidAssignmentException(init, itd, td));
            }
            this.defaultInit = true;
            init = Conversion.promote(init, td);
            init.setSynthetic(isSynthetic);
        }
        this.setOperands(this.getOp1(), type, init);
        Block block = this.getCurrentBlock();
        if (block != null) {
            block.declareInScope(this);
        }
        return this;
    }

    @Override
    public void generate(SourceGenerator cg) {
        Symbol symbol = this.getSymbol();
        if (symbol == null || !symbol.isSilentAutoDeclared() && !symbol.isAutoDeclared()) {
            cg.generate(this);
        }
    }

    @Override
    protected String getStatementSeparator() {
        return this.var == null || this.var.needsCode() ? super.getStatementSeparator() : null;
    }

    @Override
    protected void afterStep(RunningMonitor rm) throws ExecutionException {
        if (this.hasUserInitialization()) {
            super.afterStep(rm);
        }
    }

    @Override
    protected void step(RunningMonitor rm) throws ExecutionException {
        if (this.hasUserInitialization()) {
            super.step(rm);
        }
    }

    protected boolean hasUserInitialization() {
        Node init;
        Symbol symbol = this.getSymbol();
        return (symbol == null || !symbol.isSilentAutoDeclared() && !symbol.isAutoDeclared()) && (init = this.getInit()) != null && !init.isSynthetic();
    }

    static boolean isDuplicated(Node id) {
        SymbolTable symbols = id.getSymbolTable();
        Symbol symbol = symbols.get(id.getText());
        return symbol != null && !symbol.isInstanceVariable() && !symbol.isArgument();
    }

    static TypeDescription parseTypeDescription(Node type, Scope scp) throws IllegalTypeException {
        return Declaration.parseTypeDescription(type, scp, false, null);
    }

    FlowContext.Variable getVariable() {
        return this.var;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node op3;
        context.breaksFlow(false);
        if (this.symbol != null) {
            this.var = context.defineVariable(this.symbol, this.defaultInit);
        }
        if ((op3 = this.getOp3()) != null && !op3.isSynthetic()) {
            op3.checkFlow(context);
            this.var.use(op3);
        }
        return context;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        if (!this.isUsed()) {
            this.remove();
        }
        return this;
    }

    void remove() {
        SymbolTable symbols;
        Symbol symbol;
        String name = this.getName();
        if (this.getKind() != -1 && (symbol = (symbols = this.getSymbolTable()).getLocal(name)) != null) {
            symbols.remove(name);
        }
        MethodTypeDescription method = this.getCurrentMember().getMethodType();
        method.removeVariable(name);
        this.removeFromParent();
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        if (this.var != null && !this.var.needsCode()) {
            return this.symbol;
        }
        if (this.symbol.isExternalArgument()) {
            if (this.var != null && this.var.needsInitialization()) {
                this.getInit().run(rm);
            }
            return this.symbol;
        }
        if (this.symbol.isHolder()) {
            try {
                String holderType = this.symbol.getArgument().getHolderJavaType();
                Class<?> holderclass = Class.forName(holderType);
                Object holder = holderclass.newInstance();
                if (this.var != null && this.var.needsInitialization()) {
                    Object initValue = this.getInit().value(rm);
                    this.setHolderValue(holder, initValue);
                }
                this.symbol.setValue(holder);
            }
            catch (Exception e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        } else if (this.var == null || this.var.needsInitialization()) {
            this.symbol.setValue(this.getInit().value(rm));
        }
        if (!this.symbol.isSilentAutoDeclared()) {
            rm.pushVariable(this.symbol.getName(), this.symbol.getType(), new ValueReference.VariableReference(this.symbol));
        }
        return this.symbol;
    }

    void runOutOfScope(RunningMonitor rm) {
        rm.popVariable(this.symbol.getName());
    }

    private static IntConst intConstant(Node value) {
        while (true) {
            if (value instanceof Arg.Type) {
                value = value.getNext();
                continue;
            }
            if (!(value instanceof Deref)) break;
            value = value.getFirst();
        }
        return value instanceof IntConst ? (IntConst)value : null;
    }

    private static TypeDescription parseTypeDescription(Node type, Scope scp, boolean buildUnknowns, List<TypeException> exceptions) throws IllegalTypeException {
        Node first;
        String typeName = null;
        String module = null;
        if (type instanceof Identifier) {
            typeName = type.getText();
        } else if (type instanceof Deref) {
            first = type.getFirst();
            if (first instanceof Identifier) {
                typeName = first.getText();
            }
        } else if (type instanceof QualifiedName || type instanceof MemberReference) {
            first = type.getFirst();
            if (first.getNext() != null) {
                module = first.getTypeText();
                typeName = first.getNext().getText();
            } else {
                typeName = first.getTypeText();
            }
        } else if (type instanceof Function) {
            Node op = type.getFirst();
            typeName = op.getText();
            if ((op = Declaration.getNextParameter(op)) != null) {
                TypeDescription[] typeParameters = null;
                int[] intParameters = null;
                IntConst c = Declaration.intConstant(op);
                if (c != null) {
                    List intParams = CollectionPool.getArrayList();
                    intParams.add(c.value);
                    op = Declaration.getNextParameter(op);
                    while (op != null) {
                        c = Declaration.intConstant(op);
                        if (c == null) {
                            throw new IllegalTypeException(type, typeName);
                        }
                        intParams.add(c.value);
                        op = Declaration.getNextParameter(op);
                    }
                    intParameters = new int[intParams.size()];
                    for (int i = 0; i < intParams.size(); ++i) {
                        Long param = (Long)intParams.get(i);
                        intParameters[i] = param.intValue();
                    }
                    CollectionPool.releaseArrayList(intParams);
                } else {
                    List<TypeDescription> td = CollectionPool.getArrayList();
                    while (op != null) {
                        td.add(Declaration.parseTypeDescription(op, scp, buildUnknowns, exceptions));
                        op = Declaration.getNextParameter(op);
                    }
                    typeParameters = td.toArray(new TypeDescription[td.size()]);
                    CollectionPool.releaseArrayList(td);
                }
                try {
                    return TypeSpec.findType(type.getFirst(), typeParameters, intParameters, false, type.getCurrentClass().getTypeDescription(), type.getCatalog());
                }
                catch (TypeException e) {
                    throw new IllegalTypeException(type, typeName);
                }
            }
            throw new IllegalTypeException(type, typeName);
        }
        if (typeName != null) {
            int kind;
            TypeDescription result;
            Symbol symbol = scp.getSymbolTable().get(typeName);
            if (symbol != null && symbol.isTypeSpec()) {
                return symbol.getType();
            }
            if (module == null && (result = Kind.isPredefined(kind = Kind.getKind(typeName)) || kind == 16 || kind == 15 ? TypeFactory.forKind(kind, -1, -1) : TypeFactory.wellKnown(typeName)) != null) {
                return result;
            }
            ComponentCatalog catalog = type.getCatalog();
            try {
                return Declaration.f(module, type, typeName, buildUnknowns, exceptions, catalog);
            }
            catch (TypeException exc) {
                throw new IllegalTypeException(type, typeName);
            }
        }
        if (!(type instanceof ArrayReference)) {
            throw new IllegalTypeException(type, "");
        }
        TypeDescription elementType = Declaration.parseTypeDescription(type.getFirst(), scp, buildUnknowns, exceptions);
        elementType = elementType.primitiveEquivalent(false);
        Node op2 = type.getFirst().getNext();
        if (op2 == null) {
            return TypeFactory.getArray(elementType);
        }
        boolean ordered = false;
        if ("ordered".equals(op2.getText())) {
            ordered = true;
            op2 = op2.getNext();
        }
        TypeDescription indexType = Declaration.parseTypeDescription(op2, scp, buildUnknowns, exceptions);
        indexType = indexType.primitiveEquivalent(false);
        return ordered ? TypeFactory.getSortedMap(elementType, indexType) : TypeFactory.getMap(elementType, indexType);
    }

    private static Node getNextParameter(Node op) {
        if ((op = op.getNext()) instanceof Arg.Type) {
            op = op.getNext();
        }
        return op;
    }

    private static TypeDescription f(String module, Node type, String typeName, boolean buildUnknowns, List<TypeException> exceptions, ComponentCatalog catalog) throws TypeException {
        if (module == null) {
            TypeDescription ref = type.findType(typeName);
            if (ref == null) {
                NoSuchComponentException e = new NoSuchComponentException(type);
                if (buildUnknowns) {
                    exceptions.add(e);
                    return UnknownType.create(typeName, catalog);
                }
                throw e;
            }
            return ref.get();
        }
        TypeDescription ref = type.findType(module + '.' + typeName);
        if (ref == null) {
            NoSuchComponentException e = new NoSuchComponentException(type);
            if (buildUnknowns) {
                exceptions.add(e);
                return UnknownType.create(module + '.' + typeName, catalog);
            }
            throw e;
        }
        return ref.get();
    }
}

