/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.TypeDescription;

public class CompilerExceptionShell
extends ExecutionException {
    private Throwable throwable;
    static final long serialVersionUID = -7121113449788542262L;
    static final long serialCheck = 4135894932190374403L;

    public CompilerExceptionShell(Node node, Throwable throwable) {
        super(node);
        assert (throwable != null);
        assert (this.isNotExecutionException(throwable)) : throwable.getMessage();
        this.initCause(throwable);
        this.throwable = throwable;
    }

    @Override
    public String getMessage() {
        String message = "";
        TypeDescription member = this.getMember();
        if (member != null) {
            message = member.getName() + ":" + this.getLine() + ":" + this.getColumn() + ":";
        }
        if (this.throwable != null) {
            if (this.throwable instanceof ComponentExecutionException) {
                ComponentExecutionException e = (ComponentExecutionException)this.throwable;
                message = message + e.getUserMessage(Locale.getDefault());
            } else {
                message = message + this.throwable.getClass().getName();
                message = message + " : ";
                message = message + this.throwable.getMessage();
            }
        }
        return message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void printStackTrace() {
        this.throwable.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        this.throwable.printStackTrace(ps);
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        this.throwable.printStackTrace(pw);
    }

    private boolean isNotExecutionException(Object throwable) {
        return !(throwable instanceof ExecutionException);
    }
}

