/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;
import org.jetbrains.annotations.NonNls;

class Comment
extends Node {
    private String comment;
    private boolean multiLine;

    Comment(Token token, @NonNls String comment) {
        this(token, comment, false);
    }

    Comment(Token token, String comment, boolean multiLine) {
        this.comment = comment;
        this.multiLine = multiLine;
        if (token != null) {
            this.initialize(token);
        }
        this.hiddenAfter = null;
        this.hiddenBefore = null;
    }

    @Override
    public String getText() {
        return this.comment;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    boolean isFormat() {
        return true;
    }

    boolean isMultiLine() {
        return this.multiLine;
    }

    boolean isSingleLine() {
        return !this.isMultiLine();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }
}

