/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.papi.Invocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.compiler.AbstractRunningMonitor;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ConditionalBreakPoint;
import oracle.bpm.compiler.DebuggerContext;
import oracle.bpm.compiler.DebuggerPrincipal;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExecutionInterruptedException;
import oracle.bpm.compiler.ExecutionStack;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.IDebuggerRunnable;
import oracle.bpm.compiler.IgnoreStepException;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.StackFrame;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.Watch;
import oracle.bpm.compiler.debug.components.ActivityDebug;
import oracle.bpm.compiler.debug.components.ParticipantDebug;
import oracle.bpm.compiler.debug.components.ProcessInstanceDebug;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.component.Component;
import oracle.bpm.component.CustomExecution;
import oracle.bpm.component.ExecutionRelayedThrowable;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.ExecutorClient;
import oracle.bpm.component.LocalProxy;
import oracle.bpm.component.RelayArguments;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.OutgoingServerDebug;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.ProcessBeanDebug;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.util.Locales;

public class CodeRunner {
    private String activity;
    private boolean atBreakpoint;
    private List<Watch> breakPoints;
    private ComponentCatalog catalog;
    private boolean commit;
    private List<WatchValue> currentChanges;
    private DefaultEnvironment environment;
    private ExecutionStack executionStack;
    private FuegoInvokeable invokeable;
    private CILRunningMonitor invokeableMonitor;
    private Map<String, List<LineBreakPoint>> lineBreakPoints;
    private String mainMethod;
    private RunningMonitor monitor;
    private int outEventLevel = 0;
    private String participant;
    private String process;
    private final StepLock stepLock = new StepLock();
    private boolean terminated;
    private int waitFor;
    private int waitForLine;
    private int waitOutLevel = -1;
    private List<Watch> watches;
    private static final int NONE_EVENT = 0;
    private static final int STEP_EVENT = 1;
    private static final int LINE_EVENT = 2;
    private static final int OUT_EVENT = 3;
    private static final int IN_EVENT = 4;
    private static final int EXPLICIT_OUT_EVENT = 5;
    public static final String setInstanceSignature = "MsetProcessInstanceInterface(Lfuego.components.ProcessInstanceInterface;)V";
    private static final String setContextSignature = "MsetContext(Lfuego.components.ProcessBeanInterface;Lfuego.components.ActivityInterface;)V";

    public CodeRunner(FuegoInvokeable invokeable, String mainMethod, String participant, String activity, String process, ComponentCatalog catalog) {
        this.catalog = catalog;
        char start = mainMethod.charAt(0);
        assert (start == 'M' || start == 'K') : "Invalid methoid signature: " + mainMethod;
        invokeable.removeAllWatches();
        this.breakPoints = CollectionPool.getArrayList();
        this.watches = CollectionPool.getArrayList();
        this.lineBreakPoints = new HashMap<String, List<LineBreakPoint>>();
        this.executionStack = new ExecutionStack();
        this.invokeable = invokeable;
        this.mainMethod = mainMethod;
        this.invokeableMonitor = new CILRunningMonitor();
        this.invokeable.setRunningMonitor(this.invokeableMonitor);
        this.participant = participant;
        this.activity = activity;
        this.process = process;
    }

    public static void initInstance(ExecutionContext ctx, FuegoInvokeable invokeable, DefaultEnvironment environment, String participantId, String process, String activityName) {
        ProcessInstanceDebug instance = new ProcessInstanceDebug();
        ProcessInstance pinst = new ProcessInstance();
        pinst.setProcessInstanceInterface((ProcessInstanceInterface)instance);
        ctx.putProperty("oracle.bpm.components.ProcessInstance.currentInstance", pinst);
        ctx.putProperty("oracle.bpm.components.Mail.mail", new OutgoingServerDebug());
        ActivityDebug activity = new ActivityDebug(process, activityName);
        DefaultEnvironment env = environment == null ? new DefaultEnvironment() : environment;
        Locale.setDefault(Locales.getDefaultLocale());
        ProcessBeanDebug bean = new ProcessBeanDebug(env);
        ParticipantDebug participant = new ParticipantDebug(participantId);
        bean.setParticipantInterface((ParticipantInterface)participant);
        ExecutionContextAccessor.getContext().putProperty("oracle.bpm.components.ProcessInstance.currentProcessBean", bean);
        try {
            if (invokeable != null) {
                TypeDescription type = invokeable.getObjectType();
                boolean callMethods = false;
                for (SuperType superType : type.getSuperTypes()) {
                    if (!"Fuego.Lib.ProcessInstance".equals(superType.getText())) continue;
                    callMethods = true;
                    break;
                }
                if (callMethods) {
                    invokeable.invoke(setContextSignature, bean, activity);
                    invokeable.invoke(setInstanceSignature, instance);
                } else {
                    ProcessInstance instance2 = new ProcessInstance();
                    instance2.initContext(bean, (ActivityInterface)activity, ctx);
                }
            }
        }
        catch (ComponentExecutionException e) {
            e.printStackTrace();
        }
    }

    public boolean enableEvents(boolean value) {
        return this.invokeableMonitor.enableEvents(value);
    }

    public ExecutionStack getExecutionStack() {
        return this.executionStack;
    }

    public List<Watch> getBreakPoints() {
        return Collections.unmodifiableList(this.breakPoints);
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public void setEnvironment(DefaultEnvironment environment) {
        this.environment = environment;
    }

    public void setRunningMonitor(RunningMonitor rm) {
        this.monitor = rm;
    }

    public void setWaitForLine(int waitForLine) {
        this.waitForLine = waitForLine;
    }

    public List<Watch> getWatches() {
        return Collections.unmodifiableList(this.watches);
    }

    public void addBreakPoint(BreakPoint bp) {
        if (bp instanceof ConditionalBreakPoint) {
            Watch watch = new Watch((ConditionalBreakPoint)bp);
            this.breakPoints.add(watch);
            this.invokeable.addWatch(watch);
        } else if (bp instanceof LineBreakPoint) {
            LineBreakPoint linebp = (LineBreakPoint)bp;
            List<LineBreakPoint> all = this.lineBreakPoints.get(linebp.getFullName());
            if (all == null) {
                all = new ArrayList<LineBreakPoint>();
                this.lineBreakPoints.put(linebp.getFullName(), all);
            }
            all.add(linebp);
        }
    }

    public void addWatch(Watch watch) {
        this.watches.add(watch);
        this.invokeable.addWatch(watch);
    }

    public DebuggerRunnable createDebuggerRunnable() {
        return new DebuggerRunnable(this.invokeable, this.mainMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.stepLock.notifyStep(new ExitException(null, null));
        }
    }

    public synchronized void kill() {
    }

    public void removeBreakPoint(BreakPoint bp) {
        if (bp instanceof ConditionalBreakPoint) {
            Iterator<Watch> it = this.breakPoints.iterator();
            while (it.hasNext()) {
                Watch watch = it.next();
                if (watch.getBreakPoint() != bp) continue;
                it.remove();
                this.invokeable.removeWatch(watch);
                return;
            }
        } else if (bp instanceof LineBreakPoint) {
            LineBreakPoint linebp = (LineBreakPoint)bp;
            this.lineBreakPoints.remove(linebp.getFullName());
        }
    }

    public void removeWatch(Watch watch) {
        this.watches.remove(watch);
        this.invokeable.removeWatch(watch);
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.stepLock.reset();
            this.waitFor = 0;
            this.stepLock.notifyStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTo(int line) {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.stepLock.reset();
            this.waitFor = 2;
            this.stepLock.notifyStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipStep() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            if (this.waitFor != 1) {
                return;
            }
            this.stepLock.notifyStep(IgnoreStepException.instance);
        }
    }

    public void skipTo(int line) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.waitFor = 4;
            this.stepLock.notifyStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOut() {
        int frameCount = this.executionStack.getFrames().length;
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            if (frameCount == 1) {
                this.waitFor = 0;
            } else {
                this.waitFor = 5;
                this.outEventLevel = frameCount - 1;
                this.waitOutLevel = this.executionStack.getLevel() - 1;
            }
            this.stepLock.notifyStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.waitFor = 1;
            this.stepLock.notifyStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        StepLock stepLock = this.stepLock;
        synchronized (stepLock) {
            this.stepLock.notifyStep(new ExecutionInterruptedException(-1, -1));
            this.notifyTermination();
        }
        assert (this.isTerminated());
    }

    public void suspend() {
        this.waitFor = 1;
    }

    public boolean isSuspended() {
        return !this.isTerminated() && (this.stepLock.isWaiting() || this.atBreakpoint);
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void start() {
        this.createDebuggerRunnable().beginExecution();
    }

    protected void onSuspend() throws ExecutionException, InterruptedException {
        this.waitFor = 1;
        this.stepLock.waitForResume();
    }

    private synchronized void notifyTermination() {
        if (!this.terminated) {
            this.monitor.finishEvent();
            this.terminated = true;
        }
    }

    private void updateStep(Watch watch) {
        if (this.currentChanges == null) {
            this.currentChanges = CollectionPool.getArrayList();
        }
        this.currentChanges.add(new WatchValue(watch, watch.getValue()));
    }

    private class StepLock {
        private ExecutionException currentException;
        private boolean waiting;

        private StepLock() {
        }

        synchronized boolean isWaiting() {
            return this.waiting;
        }

        synchronized void checkException() throws ExecutionException {
            if (this.currentException != null) {
                ExecutionException current = this.currentException;
                this.currentException = null;
                throw current;
            }
        }

        synchronized void notifyStep() {
            this.notify();
        }

        synchronized void notifyStep(ExecutionException e) {
            this.currentException = e;
            this.notify();
        }

        synchronized void reset() {
            this.currentException = null;
        }

        synchronized void waitForResume() throws ExecutionException, InterruptedException {
            this.checkException();
            this.waiting = true;
            CodeRunner.this.monitor.suspendEvent();
            this.wait();
            this.waiting = false;
            CodeRunner.this.monitor.resumeEvent();
            this.checkException();
        }
    }

    private class CILRunningMonitor
    extends AbstractRunningMonitor {
        private boolean eventsEnabled = false;

        private CILRunningMonitor() {
        }

        @Override
        public void beginEvent(MethodTypeDescription method) throws ExecutionException {
            TypeDescription parent = method.getParent();
            assert (parent != null) : "Missing parent for method: " + method;
            CodeRunner.this.executionStack.push(parent, method);
            int frameCount = CodeRunner.this.executionStack.getFrames().length;
            if (CodeRunner.this.waitFor == 4) {
                CodeRunner.this.waitFor = 1;
                CodeRunner.this.outEventLevel = frameCount;
            } else if (CodeRunner.this.waitFor == 1) {
                CodeRunner.this.waitFor = 3;
                CodeRunner.this.outEventLevel = frameCount - 1;
            }
            CodeRunner.this.monitor.beginEvent(method);
        }

        @Override
        public void breakPointEvent(BreakPoint event) throws ExecutionException {
            assert (false) : "No way, cil doesn't know anything about a break point";
        }

        @Override
        public boolean enableEvents(boolean enable) {
            boolean prev = this.eventsEnabled;
            this.eventsEnabled = enable;
            return prev;
        }

        @Override
        public void endEvent(MethodTypeDescription method) throws ExecutionException {
            CodeRunner.this.executionStack.pop();
            if (!CodeRunner.this.executionStack.isEmpty() || method.getName().equals(JavaClass.getMethodNameFromSignature(CodeRunner.this.mainMethod))) {
                // empty if block
            }
            CodeRunner.this.monitor.endEvent(method);
            int frameCount = CodeRunner.this.executionStack.getFrames().length;
            try {
                boolean explicitOutSuspend;
                boolean mustSuspend = !CodeRunner.this.executionStack.isEmpty() && CodeRunner.this.waitFor != 3 && CodeRunner.this.waitFor != 0 && CodeRunner.this.waitFor != 5 && this.eventsEnabled;
                boolean bl = explicitOutSuspend = CodeRunner.this.waitFor == 5 && frameCount == CodeRunner.this.outEventLevel;
                if (CodeRunner.this.outEventLevel == frameCount) {
                    if (CodeRunner.this.waitFor == 3) {
                        CodeRunner.this.outEventLevel--;
                    }
                    CodeRunner.this.waitFor = 1;
                }
                if (mustSuspend || explicitOutSuspend) {
                    CodeRunner.this.onSuspend();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void exceptionEvent(ExecutionException e) throws ExecutionException {
            CodeRunner.this.monitor.exceptionEvent(e);
        }

        @Override
        public void finishEvent() {
            CodeRunner.this.notifyTermination();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stepEvent(int line, int column) throws ExecutionException {
            StackFrame frame = CodeRunner.this.executionStack.peek();
            frame.updateLine(line);
            CodeRunner.this.monitor.stepEvent(line, column);
            LineBreakPoint bp = this.findBreakpoint(this.getCurrentMember(), line);
            if (bp != null) {
                try {
                    CodeRunner.this.waitFor = 1;
                    CodeRunner.this.atBreakpoint = true;
                    CodeRunner.this.monitor.breakPointEvent(bp);
                }
                finally {
                    CodeRunner.this.atBreakpoint = false;
                }
            }
            try {
                switch (CodeRunner.this.waitFor) {
                    case 1: 
                    case 4: {
                        CodeRunner.this.waitFor = 1;
                        CodeRunner.this.onSuspend();
                        break;
                    }
                    case 2: {
                        if (line == CodeRunner.this.waitForLine) {
                            CodeRunner.this.suspend();
                            break;
                        }
                        CodeRunner.this.stepLock.checkException();
                        break;
                    }
                    case 3: 
                    case 5: {
                        if (CodeRunner.this.executionStack.getLevel() == CodeRunner.this.waitOutLevel) {
                            CodeRunner.this.onSuspend();
                            break;
                        }
                        CodeRunner.this.stepLock.checkException();
                        break;
                    }
                    default: {
                        CodeRunner.this.stepLock.checkException();
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        @Override
        public void watchEvent(Watch watch) throws ExecutionException {
            if (watch.getBreakPoint() != null) {
                Object value = watch.getValue();
                if (value instanceof ValueReference) {
                    ValueReference ref = (ValueReference)value;
                    value = ref.get();
                }
                if (Boolean.TRUE.equals(value)) {
                    CodeRunner.this.monitor.breakPointEvent(watch.getBreakPoint());
                    try {
                        CodeRunner.this.waitFor = 1;
                        CodeRunner.this.stepLock.waitForResume();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            CodeRunner.this.updateStep(watch);
            CodeRunner.this.monitor.watchEvent(watch);
        }

        @Override
        public void suspendEvent() throws ExecutionException {
        }

        @Override
        public void resumeEvent() throws ExecutionException {
        }

        @Override
        public void popVariable(String name) {
            CodeRunner.this.executionStack.peek().popVariable(name);
        }

        @Override
        public void pushVariable(String name, TypeDescription type, Object value) {
            CodeRunner.this.executionStack.peek().pushVariable(name, type, value);
        }

        public String getCurrentMember() {
            StackFrame frame = CodeRunner.this.executionStack.peek();
            return frame.getComponent().getText() + '.' + frame.getMethod().getName();
        }

        private LineBreakPoint findBreakpoint(String currentMember, int line) {
            LineBreakPoint result = null;
            List breakpoints = (List)CodeRunner.this.lineBreakPoints.get(currentMember);
            if (breakpoints != null) {
                for (LineBreakPoint bp : breakpoints) {
                    if (bp.getLineNumber() != line) continue;
                    result = bp;
                    break;
                }
            }
            return result;
        }
    }

    private static class WatchValue {
        String value;
        Watch watch;

        WatchValue(Watch watch, Object value) {
            this.watch = watch;
            this.value = FuegoCILSourceGenerator.generateCILForValue(value);
        }
    }

    public class DebuggerRunnable
    extends DebuggerPrincipal
    implements Runnable,
    IDebuggerRunnable {
        private ExecutorClient client;
        private final String method;
        private Invokeable self;
        private final FuegoInvokeable target;

        public DebuggerRunnable(FuegoInvokeable target, String method) {
            super(null, CodeRunner.this.commit);
            this.target = target;
            this.method = method;
        }

        @Override
        public ExecutionThreadContext createContext() {
            return new DebuggerContext(this, CodeRunner.this.commit, CodeRunner.this.catalog);
        }

        public void stepOut() {
            CodeRunner.this.stepOut();
        }

        public ExecutorClient getClient() {
            return this.client;
        }

        @Override
        public Invokeable getTarget() {
            if (this.self == null) {
                this.self = new JavaObject<DebuggerRunnable>(this);
            }
            return this.self;
        }

        @Override
        public CustomExecution beginExecution() {
            this.client = new ExecutorClient(new LocalProxy(this));
            Object[] arguments = new Object[]{RelayArguments.createRelayArguments(null, null, null)};
            String signature = "MrunMethod(Lfuego.component.RelayArguments;)Ljava.lang.Object;";
            return this.client.customInvoke(signature, arguments);
        }

        @Override
        public void finishExecution() {
            CodeRunner.this.notifyTermination();
        }

        public void reportException(Object exception) {
            block5: {
                try {
                    ComponentExecutionException e;
                    if (exception instanceof ExecutionException) {
                        CodeRunner.this.monitor.exceptionEvent((ExecutionException)exception);
                        return;
                    }
                    if (exception instanceof ComponentExecutionException && (e = (ComponentExecutionException)exception).getCause() != null) {
                        this.reportException(e.getCause());
                        return;
                    }
                    if (exception instanceof Throwable) {
                        CodeRunner.this.monitor.exceptionEvent(new CompilerExceptionShell(null, (Throwable)exception));
                    }
                }
                catch (ExecutionException ignore) {
                    if (!Log.isDebugging()) break block5;
                    Log.logDebug(ignore);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Component.setRunningOnDebugger();
                CustomExecution ce = this.beginExecution();
                Invocation inv = ce.next();
                while (inv != null) {
                    block13: {
                        Object[] result = null;
                        ConnectorTransaction transaction = null;
                        try {
                            transaction = ConnectorTransaction.start();
                            result = inv.invoke();
                            if (CodeRunner.this.commit) {
                                transaction.commit();
                            } else {
                                transaction.rollback();
                            }
                            ce.setInvocationResult(result);
                        }
                        catch (Exception e2) {
                            ExecutionInterruptedException e2;
                            if (e2.getCause() != null && e2.getCause() instanceof AbortedException) {
                                e2 = new ExecutionInterruptedException(-1, -1);
                            }
                            ce.setException(e2);
                            if (result != null || transaction == null) break block13;
                            try {
                                transaction.rollback();
                            }
                            catch (Exception rex) {
                                if (!Log.isDebugging()) break block13;
                                Log.logDebug(rex);
                            }
                        }
                    }
                    inv = ce.next();
                }
            }
            catch (Exception e) {
                this.reportException(e);
            }
            finally {
                this.finishExecution();
            }
        }

        public Object runMethod(RelayArguments relayArgs) throws Exception {
            Object retval;
            block5: {
                retval = null;
                Object caller = relayArgs.getCaller();
                String targetName = relayArgs.getMethod();
                ArgumentMap args = relayArgs.getArguments();
                try {
                    if (targetName == null) {
                        CodeRunner.initInstance(ExecutionContextAccessor.getContext(), this.target, CodeRunner.this.environment, CodeRunner.this.participant, CodeRunner.this.process, CodeRunner.this.activity);
                        retval = this.method.charAt(0) == 'K' ? this.target.invoke(this.method, CodeRunner.this.invokeable.getConstructorArguments()) : this.target.invoke(this.method, args != null ? args : DynamicObject.create());
                    } else {
                        FuegoInvokeable invokeable = (FuegoInvokeable)caller;
                        MethodTypeDescription mtd = invokeable.getObjectType().findMember(targetName);
                        String methodSignature = 'M' + mtd.getPrefix() + targetName + "(Loracle.bpm.lang.ArgumentMap;)V";
                        Object[] arguments = new Object[]{args != null ? args : ArgMap.create()};
                        retval = invokeable.invoke(methodSignature, arguments);
                    }
                }
                catch (ComponentExecutionException cee) {
                    Throwable t = cee;
                    while (t != null) {
                        if (!((t = t.getCause()) instanceof ExecutionRelayedThrowable)) continue;
                        ExecutionRelayedThrowable ert = (ExecutionRelayedThrowable)t;
                        ert.execute();
                        break;
                    }
                    if (t != null) break block5;
                    throw cee;
                }
            }
            CodeRunner.this.notifyTermination();
            return retval;
        }

        public boolean shouldCommit() {
            return CodeRunner.this.commit;
        }

        public void stepOver() {
            CodeRunner.this.stepOver();
        }
    }
}

