/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.MethodD;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.Method;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class ClientStubGenerator {
    static void generateClientStub(JVMByteCodeGenerator cg, Method method) {
        Type[] methodParameterTypes;
        int argc = method.getMethodType().getArgumentCount();
        JVMCodeBuilder cb = cg.getCodeBuilder();
        cb.beginIf();
        cb.invoke(MDKit.IS_NOT_RUNNING_ON_SERVER);
        cb.addThen();
        cb.loadThis();
        cb.loadConstant(method.getJavaSignature());
        cb.loadConstant(method.isStatic());
        if (argc == 0) {
            cb.loadNull();
        } else {
            ClientStubGenerator.generateInputArgsAsArray(cb, method, true);
        }
        Object[] outputArguments = method.outputArgumentsRequest();
        if (outputArguments == null) {
            methodParameterTypes = new Type[]{TD.STRING, TD.BOOLEAN, TD.OBJECT_ARRAY};
        } else {
            methodParameterTypes = new Type[]{TD.STRING, TD.BOOLEAN, TD.OBJECT_ARRAY, TD.OBJECT_ARRAY};
            cb.createArray(TD.OBJECT_ARRAY, outputArguments);
        }
        cb.invoke(MethodD.create((Type)TD.OBJECT_ARRAY, (ObjectType)cg.getClassCode().getType(), (String)"xoInvoke", (Type[])methodParameterTypes));
        LocalVariable result = cb.createLocalVariable("result", (Type)TD.OBJECT_ARRAY);
        cb.storeLocal(result);
        ClientStubGenerator.generateReturnFromArray(result, (String[])outputArguments, cb, method);
        cb.endIf();
    }

    private static void generateArgumentExtraction(TypeDescription argType, JVMCodeBuilder cb, int argn) {
        cb.loadConstant(argn);
        cb.arrayLoad();
        ClientStubGenerator.generateCast(TypeFactory.getAny(), argType, cb);
    }

    private static void generateCast(TypeDescription sourceType, TypeDescription targetType, JVMCodeBuilder cb) {
        if (sourceType.isPrimitive() == targetType.isPrimitive()) {
            cb.convert(TD.valueOf((TypeDescription)targetType));
        } else {
            cb.invoke(MDKit.conversionMethod((TypeDescription)sourceType, (TypeDescription)targetType));
        }
    }

    private static void generateArgumentReference(JVMCodeBuilder cb, Method method, Argument arg) {
        TypeDescription argType = arg.getType();
        cb.loadArgument(arg.getNumber());
        if (arg.isOut()) {
            Type argumentType = TD.valueOf((String)Method.argumentType(arg));
            cb.loadField(TDKit.valueField((Type)argumentType));
        }
        if (argType.isPrimitive()) {
            TypeDescription targetType = argType.primitiveEquivalent(false);
            TypeDescription argRealType = arg.isIn() && !arg.isOut() ? argType : argType.getHolderType();
            cb.invoke(MDKit.conversionMethod((TypeDescription)argRealType, (TypeDescription)targetType));
        }
    }

    private static void generateInputArgsAsArray(JVMCodeBuilder cb, Method method, boolean addSignatures) {
        MethodTypeDescription methodType = method.getMethodType();
        int arrayIndex = 0;
        int argumentCount = methodType.getArgumentCount();
        cb.createArray(TD.OBJECT_ARRAY, addSignatures ? argumentCount * 2 : argumentCount);
        for (int i = 0; i < argumentCount; ++i) {
            if (addSignatures) {
                cb.dup();
                cb.loadConstant(arrayIndex);
                cb.loadConstant("#" + i);
                cb.arrayStore();
                ++arrayIndex;
            }
            cb.dup();
            cb.loadConstant(arrayIndex);
            ClientStubGenerator.generateArgumentReference(cb, method, methodType.getArgument(i));
            cb.arrayStore();
            ++arrayIndex;
        }
    }

    private static void generateReturnFromArray(LocalVariable result, String[] outputArguments, JVMCodeBuilder cb, Method method) {
        TypeDescription resultType;
        if (outputArguments != null) {
            MethodTypeDescription member = method.getMethodType();
            int argc = member.getArgumentCount();
            int argn = 0;
            for (int i = 0; i < argc; ++i) {
                Argument arg = member.getArgument(i);
                if (!arg.isOut()) continue;
                String argType = Method.argumentType(arg);
                cb.loadArgument(i);
                cb.loadLocal(result);
                ClientStubGenerator.generateArgumentExtraction(arg.getType().getHolderType(), cb, ++argn);
                cb.storeField(TDKit.valueField((Type)TD.valueOf((String)argType)));
            }
        }
        if (!(resultType = method.getResultType()).isVoid()) {
            cb.loadLocal(result);
            ClientStubGenerator.generateArgumentExtraction(resultType, cb, 0);
        }
        cb.retrn();
    }
}

