/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class ClassConst
extends Const {
    private String javaType;
    private static TypeDescription javaLangClass;

    ClassConst(TypeDescription type, Node init) {
        this(type.isInvokeable() ? Invokeable.class.getName() : type.getJavaType(), init);
    }

    ClassConst(String javaType, Node init) {
        this.setParent(init);
        try {
            this.setTypeDescription(ClassConst.getJavaLangClass(init));
        }
        catch (TypeException e) {
            init.reportError(e);
        }
        this.javaType = javaType;
        this.initialize(init);
    }

    @Override
    public String getText() {
        return this.javaType;
    }

    public String getTypeToCast() {
        return this.javaType;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public void generate(SourceGenerator cg) {
    }

    final boolean equals(Node b) {
        ClassConst cc = b instanceof ClassConst ? (ClassConst)b : null;
        return cc != null && this.javaType.equals(cc.javaType);
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.run(rm, true);
    }

    Object run(RunningMonitor rm, boolean failIfClassNotFound) throws ExecutionException {
        Class<?> cl;
        block2: {
            cl = null;
            try {
                cl = JavaClass.loadByJavaType(this.javaType);
            }
            catch (ClassNotFoundException e) {
                if (!failIfClassNotFound) break block2;
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
        return cl;
    }

    private static TypeDescription getJavaLangClass(Node init) throws TypeException {
        TypeDescription result = javaLangClass;
        if (result == null) {
            result = init.findType("Java.Lang.Class", false);
            if (result == null) {
                result = new ObjectTypeDescription("Java.Lang.Class");
            }
            javaLangClass = result;
        }
        return result;
    }
}

