/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IgnoreStepException;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.RetryStepException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UnreachableStatementException;
import oracle.bpm.type.TypeFactory;

public class Block
extends NList {
    protected List<Declaration> innerDeclarations;
    protected String name = "";
    private Node pulledStatements;
    protected static final String UNNAMED = "";

    public Block() {
        this.setStatement(true);
    }

    public Block(AST n) {
        super(n);
        this.setStatement(true);
    }

    public Block(Token t) {
        super(t);
        this.setStatement(true);
    }

    public static Block makeEmpty(Node init) {
        Block block = new Block();
        block.initialize(init);
        return block;
    }

    public String getName() {
        if ((this.name == null || this.name.isEmpty()) && this.getFirst() instanceof Identifier) {
            this.name = this.getFirst().getText();
        }
        return this.name;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    protected void declareInScope(Declaration declaration) {
        if (this.innerDeclarations == null) {
            this.innerDeclarations = CollectionPool.getArrayList();
        }
        this.innerDeclarations.add(declaration);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static Block ensureIsBlock(Node node) {
        return node instanceof Block ? (Block)node : new Block((AST)node);
    }

    @Override
    Block getCurrentBlock() {
        return this;
    }

    void setName(String n) {
        this.name = n;
        if ((n == null || n.length() == 0) && this.getFirst() instanceof Identifier) {
            this.setFirst(this.getFirst().getNext());
        }
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node current = this.getFirst();
        current = Block.skipComments(current);
        boolean prevBreaksFlow = false;
        while (current != null) {
            if (prevBreaksFlow) {
                this.reportError(new UnreachableStatementException(current));
            }
            try {
                current.checkFlow(context);
            }
            catch (FlowException ex) {
                this.reportError(ex);
            }
            catch (Exception unexpected) {
                this.reportError(new InternalException(current, (Throwable)unexpected));
            }
            current = current.getNext();
            current = Block.skipComments(current);
            prevBreaksFlow = context.breaksFlow();
        }
        context.breaksFlow(prevBreaksFlow);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(true);
    }

    Node checkType(boolean removeEmpty) throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node prev = null;
        Node current = this.getFirst();
        while (current != null) {
            Node newNode;
            Node next = current.getNext();
            try {
                current.setStatement(true);
                newNode = current.checkType();
                if (newNode == null) assert (false) : "Statement '" + current.getClassName() + "' returned null after checkType.";
            }
            catch (InvalidNodeException e) {
                newNode = NullStatement.NODE;
            }
            catch (TypeException e) {
                this.reportError(e);
                newNode = NullStatement.NODE;
            }
            catch (Exception unexpected) {
                this.reportError(new InternalException(current, (Throwable)unexpected));
                newNode = NullStatement.NODE;
            }
            if (newNode == NullStatement.NODE) {
                if (prev == null) {
                    this.setFirst(next);
                } else {
                    prev.setNext(next);
                }
                current = prev;
            } else if (newNode.getClass() == Block.class) {
                Node blockFirst = newNode.getFirst();
                if (blockFirst != null) {
                    if (prev == null) {
                        this.setFirst(blockFirst);
                    } else {
                        prev.setNext(blockFirst);
                    }
                    current = blockFirst.getLast();
                    current.setNext(next);
                } else {
                    if (prev == null) {
                        this.setFirst(next);
                    } else {
                        prev.setNext(next);
                    }
                    current = prev;
                }
            } else {
                newNode.setNext(next);
                if (prev == null) {
                    this.setFirst(newNode);
                } else {
                    prev.setNext(newNode);
                }
                current = newNode;
            }
            if (this.pulledStatements != null) {
                if (prev != null) {
                    this.setFirst(this.pulledStatements);
                } else {
                    prev.setNext(this.pulledStatements);
                }
                this.pulledStatements.getLast().setNext(current);
                this.pulledStatements = null;
            }
            prev = current;
            current = next;
        }
        if (removeEmpty && !this.hasChildren() && !this.isGeneratingSource()) {
            return NullStatement.NODE;
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void pullStatmentUp(Node statement) {
        if (this.pulledStatements == null) {
            this.pulledStatements = statement;
        } else {
            this.pulledStatements.getLast().setNext(statement);
        }
    }

    @Override
    Node refactor(CodeStyle ss) {
        NodeIterator it = this.getChildren();
        while (it.hasNext()) {
            Node n = it.next();
            try {
                n.refactor(ss);
            }
            catch (Exception unexpected) {
                this.reportError(new InternalException(n, (Throwable)unexpected));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        NodeIterator nodes = this.getChildren();
        this.afterStep(rm);
        try {
            while (nodes.hasNext()) {
                Node current = nodes.next();
                boolean retry = true;
                while (retry) {
                    retry = false;
                    try {
                        current.step(rm);
                        current.run(rm);
                        current.afterStep(rm);
                    }
                    catch (IgnoreStepException e) {
                    }
                    catch (RetryStepException e) {
                        retry = true;
                    }
                    catch (ExecutionException e) {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        try {
                            rm.exceptionEvent(new CompilerExceptionShell(current, throwable));
                        }
                        catch (RetryStepException e) {
                            retry = true;
                        }
                        catch (IgnoreStepException e) {}
                    }
                }
            }
        }
        finally {
            if (this.innerDeclarations != null) {
                for (Declaration innerDeclaration : this.innerDeclarations) {
                    Symbol symbol = innerDeclaration.getSymbol();
                    if (symbol.isSilentAutoDeclared()) continue;
                    rm.popVariable(symbol.getName());
                }
            }
        }
        return null;
    }

    private static Node skipComments(Node current) {
        while (current instanceof Comment) {
            current = current.getNext();
        }
        return current;
    }
}

