/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConversionGenerator;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectInput;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;

public abstract class BaseCodeGenerator
implements CodeGenerator {
    protected ConstGenerator constGenerator;
    protected ConversionGenerator conversionGenerator;
    protected boolean testMode;

    public BaseCodeGenerator(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public abstract void emitLineNumber(int var1);

    @Override
    public ConversionGenerator getConversionGenerator() {
        return this.conversionGenerator;
    }

    @Override
    public final void generate(Const c) {
        this.constGenerator.generate(c);
    }

    @Override
    public void generate(Invoke invoke) {
        Args outputArgs = this.generatePreInvokeCall(invoke);
        invoke.getMethodCall().gen(this);
        if (invoke.isStatement()) {
            this.generateStatementSeparator(invoke, true);
        }
        if (invoke.isConstructor() && !invoke.isDynamic()) {
            this.generateInputAttrCode(invoke, invoke.getInputArgs());
        }
        if (!invoke.hasRelay() && outputArgs != null && outputArgs.getArgCount() > 0) {
            this.generateOutputAttrCode(outputArgs);
        }
    }

    @Override
    public void generate(Block block) {
        for (Node n = block.getFirst(); n != null; n = n.getNext()) {
            if (!n.hasType()) {
                Node.show((AST)block);
            }
            assert (n.hasType()) : "Node(" + n.getClassName() + ") not compiled. Context: " + n.dumpContext();
            n.gen(this);
            this.generateStatementSeparator(n);
        }
    }

    @Override
    public final void generate(SetMember node) {
        this.generateSetter(node.getOp1(), node.getObjType(), node.getMemberType(), node.getOp3(), node.getOp2().getText(), node.isPrimitiveAccess(), node.isExpression());
    }

    @Override
    public void generate(ObjectInput node) {
        Node init = node.getOp1();
        Node input = node.getOp2();
        if (!(init instanceof If)) {
            input = init;
            init = null;
        }
        if (init != null) {
            init.gen(this);
        }
        Invoke invoke = (Invoke)input;
        Args args = this.generatePreInvokeCall(invoke);
        invoke.getMethodCall().gen(this);
        if (invoke.isStatement()) {
            this.generateStatementSeparator(invoke, true);
        }
        if (invoke.isConstructor() && !invoke.isDynamic()) {
            this.generateInputAttrCode(invoke, invoke.getInputArgs());
        }
        if (!invoke.hasRelay() && args != null && args.getArgCount() > 0) {
            this.generateOutputAttrCode(args);
        }
    }

    protected abstract void generateDynamicReturnArray(LocalVar var1, Args var2, Invoke var3);

    protected abstract void generateSetter(Node var1, TypeDescription var2, MethodTypeDescription var3, Node var4, String var5, boolean var6, boolean var7);

    protected void generateInputAttrCode(Invoke invoke, Args args) {
        Node object = invoke.getObject();
        TypeDescription objType = invoke.getMemberType().getParent();
        for (Arg argNode = (Arg)args.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            Argument arg = argNode.getArgument();
            if (!arg.isAttribute()) continue;
            this.generateSetter(object, objType, arg.getType().asAttribute(), argNode.getValue(), arg.getName(), false, false);
            this.generateStatementSeparator(args);
        }
    }

    protected void generateOutputAttrCode(Args args) {
        for (Arg argNode = (Arg)args.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            Argument arg = argNode.getArgument();
            if (!arg.isOut() || argNode.getPostInvocationInstruction() == null) continue;
            argNode.getPostInvocationInstruction().gen(this);
            this.generateStatementSeparator(argNode);
        }
    }

    Args generatePreInvokeCall(Invoke invoke) {
        if (!invoke.isDynamic()) {
            Args inputArgs = invoke.getInputArgs();
            if (!invoke.isConstructor()) {
                this.generateInputAttrCode(invoke, inputArgs);
            }
            for (Arg argNode = (Arg)inputArgs.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
                Argument arg = argNode.getArgument();
                if (!arg.isArgument() || !arg.isOut()) continue;
                if (argNode.init != null) {
                    argNode.init.gen(this);
                }
                this.generateStatementSeparator(argNode);
            }
        }
        Args outputArgs = invoke.getOutputArgs();
        if (invoke.isDynamic() && invoke.returnArray != null) {
            this.generateDynamicReturnArray(invoke.returnArray, outputArgs, invoke);
        }
        return outputArgs;
    }

    void generateStatementSeparator(Node n) {
    }

    void generateStatementSeparator(Node n, boolean force) {
    }
}

