/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.io.StringWriter;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidColumnException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Assignment
extends Diadic {
    public Assignment() {
    }

    public Assignment(Token t) {
        super(t);
        this.setParametric(false);
    }

    Assignment(Node var, Node expr) {
        this(var, expr, false);
    }

    Assignment(Node var, Node expr, boolean rightExpression) {
        assert (var != null);
        assert (expr != null);
        this.copyParentFrom(var);
        if (expr instanceof LocalVar) {
            expr = new Deref(expr);
        }
        this.setOperands(var, expr);
        this.setExpression(rightExpression);
        if (this.isExpression()) {
            this.setTypeDescription(var.getTypeDescription());
        } else {
            this.setTypeDescription(TypeFactory.getVoid());
        }
        this.initialize(var);
    }

    @Override
    public String getText() {
        return ":=";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    @Override
    boolean isIncrement() {
        Arithmetic a;
        Node var = this.getOp1();
        Node value = this.getOp2();
        Arithmetic arithmetic = a = value instanceof Arithmetic ? (Arithmetic)this.getOp2() : null;
        if (a != null && a.getOperator() == 0) {
            Node aop1 = a.getOp1();
            Node aop2 = a.getOp2();
            if (Any.equals(aop1.getSymbol(), var.getSymbol())) {
                Const inc = aop2 instanceof Const ? (Const)aop2 : null;
                return inc != null && inc.getKind() == 2 && inc.getText().equals("1");
            }
        }
        return false;
    }

    LocalVar getLocalVar() {
        Node op1 = this.getOp1();
        if (op1 instanceof LocalVar) {
            return (LocalVar)op1;
        }
        throw new IllegalStateException("This node(" + op1.getClassName() + ") must be a 'LocalVar'");
    }

    Symbol getVarSymbol() {
        return this.getOp1().getSymbol();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        this.getOp2().checkFlow(context);
        Node left = this.getOp1();
        Symbol symbol = left.getSymbol();
        if (symbol != null) {
            context.initializeVariable(symbol, left);
        }
        left.checkFlow(context);
        context.breaksFlow(false);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        Node op;
        Node var = this.getOp1();
        Node value = this.getOp2();
        if (this.getScope().isSQLScope()) {
            var = new Deref(var);
        }
        boolean isFunction = var instanceof Function;
        if ((var = var.checkType()) != null) {
            var.setParent(this);
            var.setNext(value);
        }
        this.checkValidLValue(var);
        value = value.checkType(var != null ? var.getTypeDescription() : TypeFactory.getAny());
        TypeDescription valueType = value.getTypeDescription();
        if (valueType.isUnknown()) {
            throw new NoSuchComponentException((Node)this, valueType.getName());
        }
        if (var == null) {
            if (this.getScope().isSQLScope()) {
                throw new InvalidColumnException(this.getOp1());
            }
            var = this.getOp1().getAutoDeclared(valueType);
            if (var == null) {
                throw new InvalidAssignmentException(value);
            }
            var.setScope(this.getScope());
        }
        Conversion c = var instanceof Conversion ? (Conversion)var : null;
        Node node = op = c != null ? c.getOperand() : null;
        if (op instanceof MemberReference || op instanceof ArrayReference || op instanceof Deref) {
            var = c.getOperand();
        }
        if (var instanceof MemberReference) {
            MemberReference member = (MemberReference)var;
            SetMember set = new SetMember(member, value);
            set.initialize(this);
            set.setExpression(this.isExpression());
            return set.checkType();
        }
        if (var instanceof ArrayReference) {
            ArrayReference array = (ArrayReference)var;
            SetElement set = new SetElement(array, value);
            this.copyParentFrom(this);
            set.initialize(this);
            return set.checkType();
        }
        if (var instanceof Deref && !this.getScope().isSQLScope()) {
            var = var.getFirst();
        }
        TypeDescription varType = var.getTypeDescription();
        if (isFunction) {
            this.reportError(new InvalidAssignmentException((Node)this, var));
            return this;
        }
        if (!varType.isAssignableFrom(valueType)) {
            if (this.isAssignableFrom45(varType, valueType)) {
                value = Conversion.promoteFrom45(value, varType);
            } else {
                this.setOperands(var, value);
                this.reportError(new InvalidAssignmentException((Node)this, value, var));
                this.printDump("assign");
                return this;
            }
        }
        this.checkSillyOperation(var, value);
        value = this.isSQLScope() && var.getColumnReference() != null ? Conversion.promote(value, var.getColumnReference()) : Conversion.promote(value, varType);
        if (var.isHolder() && varType.getHolderType() != varType && (varType.isInt() || varType.isReal())) {
            value = Conversion.promote(value, varType.getHolderType());
        }
        this.setOperands(var, value);
        this.setTypeDescription(this.isExpression() ? var.getTypeDescription() : TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        this.getOp1().generateSQLCode(query);
        query.append(" = ");
        this.getOp2().generateSQLCode(query);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        assert (this.getKind() != -1) : "'Assignment' not compiled";
        Object value = this.getOp2().value(rm);
        this.getOp1().setVariable(rm, value);
        return value;
    }

    InvalidAssignmentException invalidAssignment(Node target) {
        LanguageSpec currentLanguage = this.getCurrentLanguage();
        SourceGenerator generator = currentLanguage.createSourceGenerator();
        StringWriter sw = new StringWriter();
        generator.setWriter(sw);
        target.generate(generator);
        generator.close();
        return new InvalidAssignmentException((Node)this, sw.toString());
    }

    private static boolean isThis(Node var) {
        return var != null && var.getSymbol() != null && var.getSymbol().isThis();
    }

    private void checkValidLValue(Node var) throws InvalidAssignmentException {
        if (var instanceof Const || Assignment.isThis(var)) {
            throw this.invalidAssignment(var);
        }
    }
}

