/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import oracle.bpm.collections.Tuple;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.Pair;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class ArrayConst
extends Const {
    private TypeDescription arrayType;
    private boolean constant;
    private boolean map;

    public ArrayConst(Token t) {
        this(t, false);
    }

    ArrayConst() {
        this(null, false);
    }

    ArrayConst(Node elements) {
        this(elements.getScope(), elements);
    }

    ArrayConst(Scope scope, Node elements) {
        this(scope, elements, false);
    }

    ArrayConst(Node elements, boolean primitive, TypeDescription arrayType) {
        this(elements.getScope(), elements, primitive);
        this.arrayType = arrayType;
    }

    ArrayConst(Scope scope, Node elements, boolean primitive) {
        if (elements != null) {
            this.setParent(elements.getParent());
        }
        this.setPrimitive(primitive);
        this.setFirst(elements);
        this.setMustClone(true);
        this.setScope(scope);
        this.setParametric(false);
    }

    private ArrayConst(Token t, boolean map) {
        super(t, TypeFactory.getNone());
        this.setPrimitive(false);
        this.map = map;
        this.setMustClone(true);
    }

    public TypeDescription getElementType() {
        return this.getTypeDescription().getElementType();
    }

    public void setElementsPrimitive(boolean b) {
        ArrayTypeDescription atd = (ArrayTypeDescription)this.getTypeDescription();
        TypeDescription td = atd.getElementType().primitiveEquivalent(b);
        atd.setElementType(td);
        for (Node val = this.getFirst(); val != null; val = val.getNext()) {
            val.setTypeDescription(td);
        }
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (Node val = this.getFirst(); val != null; val = val.getNext()) {
            buffer.append(val.getText());
            if (this.map && val.getNext() != null) {
                val = val.getNext();
                buffer.append(':');
                buffer.append(val.getText());
            }
            if (val.getNext() == null) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.isMap());
    }

    static Node create(List list, Node parent, boolean primitive, TypeDescription arrayType) throws TypeException {
        Const result;
        Node first;
        if (list.isEmpty()) {
            return new NullConst(parent);
        }
        Iterator it = list.iterator();
        Node current = (Node)it.next();
        boolean isnull = current instanceof NullConst;
        Node last = first = Node.copy(current);
        first.setFirst(current.getFirst());
        while (it.hasNext()) {
            current = (Node)it.next();
            Node node = Node.copy(current);
            if (!(current instanceof NullConst)) {
                isnull = false;
            }
            node.setFirst(current.getFirst());
            last.setNext(node);
            last = node;
        }
        last.setNext(null);
        assert (first.getScope() != null) : first.getClass().getName() + " doesn't have a scope";
        Const const_ = result = isnull ? new NullConst(parent) : new ArrayConst(first, primitive, arrayType);
        if (result.getParent() == null) {
            result.copyParentFrom(parent);
        }
        return result;
    }

    @Override
    boolean isCollectable() {
        return this.constant;
    }

    @Override
    boolean isConstant() {
        return this.constant;
    }

    boolean isMap() {
        return this.map;
    }

    boolean isOrdered() {
        return this.getTypeDescription().isOrdered();
    }

    @Override
    boolean isPrimitive() {
        return this.getTypeDescription().isPrimitive();
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(null);
    }

    @Override
    Node checkType(TypeDescription targetType) throws TypeException {
        TypeDescription indexType;
        TypeDescription elementType;
        if (this.getKind() != -1) {
            return this;
        }
        this.checkElements(targetType);
        if (this.arrayType == null) {
            Tuple<TypeDescription, TypeDescription> types = this.deduceArrayType();
            elementType = types.getFirst();
            indexType = types.getSecond();
        } else {
            elementType = this.arrayType.getElementType();
            indexType = this.arrayType.getIndexType();
        }
        ArrayConst result = this.promote(elementType, indexType);
        if (this.isSQLScope()) {
            this.setParameter(false);
        }
        return result;
    }

    final boolean contains(Const constant) {
        Node val = this.getFirst();
        while (val != null) {
            if (constant.equals((AST)val)) {
                return true;
            }
            val = this.map ? val.getNext().getNext() : val.getNext();
        }
        return false;
    }

    @Override
    final Const convertTo(TypeDescription td) {
        Const result;
        if (td.isString()) {
            result = new StringConst(this.getText());
        } else if (td.getKind() != this.getTypeDescription().getKind()) {
            result = td == TypeFactory.getAny() ? this : null;
        } else if (!td.getElementType().equals(this.getTypeDescription().getElementType())) {
            result = null;
        } else {
            this.setTypeDescription(td);
            result = this;
        }
        return result;
    }

    final boolean equals(Node bObject) {
        Node v2;
        if (!(bObject instanceof ArrayConst)) {
            return false;
        }
        ArrayConst b = (ArrayConst)bObject;
        Node v1 = this.getFirst();
        for (v2 = b.getFirst(); v1 != null && v2 != null; v1 = v1.getNext(), v2 = v2.getNext()) {
            if (v1.equals((AST)v2)) continue;
            return false;
        }
        return v1 == null && v2 == null;
    }

    final ArrayConst promote(TypeDescription elementType, TypeDescription indexType) throws TypeException {
        return this.promote(elementType, indexType, false);
    }

    final ArrayConst promote(TypeDescription elementType, TypeDescription indexType, boolean sorted) throws TypeException {
        Node prev = null;
        int i = 0;
        Node val = this.getFirst();
        while (val != null) {
            TypeDescription type;
            Node next = val.getNext();
            TypeDescription typeDescription = type = this.map && i++ % 2 == 0 ? indexType : elementType;
            if (val instanceof ArrayConst && type.isArray()) {
                ArrayConst a = (ArrayConst)val;
                a.promote(type.getElementType(), type.getIndexType(), type.isOrdered());
            } else if (!type.equals(val.getTypeDescription())) {
                val = Conversion.promote(val, type);
                val.setNext(next);
                if (prev == null) {
                    this.setFirst(val);
                } else {
                    prev.setNext(val);
                }
            }
            if (!this.isConstant() || !val.isConstant()) {
                // empty if block
            }
            prev = val;
            val = next;
        }
        TypeDescription td = this.map ? (sorted ? TypeFactory.getSortedMap(elementType, indexType) : TypeFactory.getMap(elementType, indexType)) : (this.isPrimitive() ? TypeFactory.getPrimitiveArray(elementType) : TypeFactory.getArray(elementType));
        this.setTypeDescription(td);
        return this;
    }

    void setMap(boolean map) {
        this.map = map;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.isSQLScope()) {
            this.setParametric(false);
        }
        return super.collectParameters(params);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append("(");
        ArrayConst.generateCommaDelimitedSQL(this.getFirst(), sql);
        sql.append(")");
    }

    int length() {
        int length = 0;
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            ++length;
        }
        return this.map ? length / 2 : length;
    }

    void put(Node key, Node value) {
        assert (this.isMap()) : "Should be a map!";
        Pair pair = new Pair((AST)key, (AST)value);
        this.addChild((AST)pair);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        AbstractMap map;
        NodeIterator elements = this.getChildren();
        TypeDescription arrayType = this.getTypeDescription();
        if (this.getKind() == 12) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (elements.hasNext()) {
                list.add(elements.next().value(rm));
            }
            if (arrayType.isPrimitive()) {
                TypeDescription elemType = arrayType.getElementType();
                if (elemType == null) {
                    elemType = TypeFactory.getPrimitiveInt(32);
                }
                Object array = Array.newInstance(elemType.getJavaClass(), list.size());
                int length = list.size();
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, list.get(i));
                }
                return array;
            }
            return list;
        }
        assert (this.getKind() == 13) : arrayType.getText();
        AbstractMap abstractMap = map = arrayType.isOrdered() ? new TreeMap() : new LinkedHashMap();
        while (elements.hasNext()) {
            map.put(elements.next().value(rm), elements.next().value(rm));
        }
        return map;
    }

    private Tuple<TypeDescription, TypeDescription> deduceArrayType() throws TypeException {
        TypeDescription indexType = null;
        TypeDescription elemType = null;
        this.constant = true;
        int i = 0;
        for (Node val = this.getFirst(); val != null; val = val.getNext()) {
            if (!val.isConstant()) {
                this.constant = false;
            }
            TypeDescription curr = val.getTypeDescription();
            if (this.map && i++ % 2 == 0) {
                indexType = indexType == null ? curr : indexType.promote(curr);
                continue;
            }
            elemType = elemType == null ? curr : elemType.promote(curr);
        }
        if (elemType == null) {
            elemType = TypeFactory.getNull();
        }
        if (indexType == null) {
            indexType = TypeFactory.getNull();
        }
        if (this.map) {
            this.setPrimitive(false);
            indexType = indexType.primitiveEquivalent(false);
        }
        if (!this.isPrimitive()) {
            elemType = elemType.primitiveEquivalent(false);
        }
        return Tuple.create(elemType, indexType);
    }

    private void checkElements(TypeDescription targetType) throws TypeException {
        TypeDescription indexType = null;
        TypeDescription elemType = null;
        if (targetType != null) {
            if (targetType.isArray() || targetType.isMap()) {
                indexType = targetType.getIndexType();
                elemType = targetType.getElementType();
            } else {
                indexType = targetType;
                elemType = targetType;
            }
        }
        Node node = this.getFirst();
        this.setFirst(null);
        if (node != null) {
            this.map = node instanceof Pair;
        }
        while (node != null) {
            Node current = node;
            node = node.getNext();
            boolean pair = current instanceof Pair;
            if (!this.map) {
                if (pair) {
                    throw new TypeException(current, CompilerMsg.EXPARRAYVALUE);
                }
                current = current.checkType(elemType != null ? elemType : TypeFactory.getAny());
                this.addOneChild(current);
                continue;
            }
            if (!pair) {
                throw new TypeException(current, CompilerMsg.EXPMAPVALUE);
            }
            Node index = current.getOp1();
            Node elem = current.getOp2();
            index = index.checkType(indexType != null ? indexType : TypeFactory.getAny());
            elem = elem.checkType(elemType != null ? elemType : TypeFactory.getAny());
            this.addOneChild(index);
            this.addOneChild(elem);
        }
    }
}

