/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.TypeRef;

public class AmbiguousComponentNameException
extends TypeException {
    private AmbiguousTypeNameException original;
    static final long serialVersionUID = 4946965757957917393L;
    static final long serialCheck = 404328549394550826L;

    public AmbiguousComponentNameException(Node node, AmbiguousTypeNameException e) {
        this(node, e.getPossibleModuleNames());
        this.original = e;
    }

    private AmbiguousComponentNameException(Node typeName, String[] names) {
        super(typeName);
        assert (names.length >= 2) : names.length;
        String components = "";
        for (int i = 0; i < names.length; ++i) {
            components = components + names[i];
            if (i + 1 >= names.length) continue;
            components = components + ", ";
        }
        this.setKey(CompilerMsg.AMBIGUOUSNAME(typeName.getTypeText(), components));
    }

    public TypeRef[] getPossibleTypes() {
        return this.original.getPossibleTypes();
    }
}

