/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonNumericException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Aggregate
extends Diadic {
    private boolean distinct;
    private final int operator;
    static final int AVG = 0;
    static final int MAX = 1;
    static final int MIN = 2;
    static final int SUM = 3;
    static final int COUNT = 4;
    private static final String[] OPNAME = new String[]{"avg", "max", "min", "sum", "count"};

    Aggregate(Token t, int op) {
        super(t);
        assert (op == 0 || op == 1 || op == 2 || op == 3 || op == 4);
        this.setParametric(false);
        this.operator = op;
    }

    @Override
    public String getText() {
        return OPNAME[this.operator] + (this.distinct ? " distinct" : "");
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.operator, this.distinct);
    }

    @Override
    Node checkType() throws TypeException {
        Aggregate result = this;
        if (this.getOp2() != null) {
            this.distinct = true;
            this.setOperand(this.getOp2());
        }
        Node op = this.getOp1().checkType();
        TypeDescription opType = op.getTypeDescription();
        switch (this.operator) {
            case 0: 
            case 3: {
                if (!opType.isNumber()) {
                    this.reportError(new NonNumericException(op));
                    this.setTypeDescription(TypeFactory.getInt());
                    break;
                }
                this.setTypeDescription(opType);
                break;
            }
            case 1: 
            case 2: {
                this.setTypeDescription(opType);
                break;
            }
            case 4: {
                this.setTypeDescription(TypeFactory.getInt());
                break;
            }
            default: {
                assert (false) : "invalid operand: " + this.operator;
                break;
            }
        }
        this.setOperand(op);
        return result;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(OPNAME[this.operator]).append('(').append(this.distinct ? "DISTINCT " : "");
        this.getFirst().generateSQLCode(sql);
        sql.append(')');
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return null;
    }

    public static class Sum
    extends Aggregate {
        public Sum(Token t) {
            super(t, 3);
        }
    }

    public static class Min
    extends Aggregate {
        public Min(Token t) {
            super(t, 2);
        }
    }

    public static class Max
    extends Aggregate {
        public Max(Token t) {
            super(t, 1);
        }
    }

    public static class Count
    extends Aggregate {
        public Count(Token t) {
            super(t, 4);
        }
    }

    public static class Avg
    extends Aggregate {
        public Avg(Token t) {
            super(t, 0);
        }
    }
}

