/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.CommonHiddenStreamToken;
import fuego.parser.FuegoToken;
import fuego.parser.LLkParser;
import fuego.parser.MismatchedTokenException;
import fuego.parser.NoViableAltException;
import fuego.parser.ParserSharedInputState;
import fuego.parser.RecognitionException;
import fuego.parser.Token;
import fuego.parser.TokenBuffer;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenStreamHiddenTokenFilter;
import fuego.parser.collections.AST;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.CompletionException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.DummyNode;
import oracle.bpm.compiler.FuegoLexer;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.NewLine;
import oracle.bpm.compiler.Node;

public class AbstractCILParser
extends LLkParser {
    protected boolean expression;
    private int errorCount;
    private TokenStreamHiddenTokenFilter filter;
    private FuegoLexer lexer;
    private MessageListener listener;
    private int[] sqlExitTokens;

    public AbstractCILParser(int k) {
        super(k);
    }

    public AbstractCILParser(ParserSharedInputState state, int k) {
        super(state, k);
    }

    public AbstractCILParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
    }

    public AbstractCILParser(TokenStream lexer, int k) {
        super(lexer, k);
        if (lexer instanceof TokenStreamHiddenTokenFilter) {
            this.filter = (TokenStreamHiddenTokenFilter)lexer;
        }
    }

    public void setInsideSQL(boolean b) {
        this.lexer.setState(b ? 1 : 0);
        if (b) {
            this.lexer.setExitTokens(this.sqlExitTokens);
            this.lexer.setExitState(0);
        }
    }

    public boolean isInsideSQL() {
        return this.lexer.getState() == 1;
    }

    public FuegoLexer getLexer() {
        return this.lexer;
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public void setSqlExitTokens(int[] tokens) {
        this.sqlExitTokens = tokens;
    }

    public int LA(int i) throws TokenStreamException {
        return this.lexer.getTokenType(this.LT(i));
    }

    public void expressionOnly() throws RecognitionException, TokenStreamException {
    }

    public void init(FuegoLexer lexer) {
        this.lexer = lexer;
        this.setASTNodeClass(DummyNode.class.getName());
    }

    public void match(int token) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) == token) {
            this.consume();
        } else {
            MismatchedTokenException e = new MismatchedTokenException(this.tokenNames, this.LT(1), token, false, this.getFilename());
            if (this.inputState.guessing != 0) {
                throw e;
            }
            if (this.LA(1) == 17 && token >= 19) {
                Token completionToken = this.LT(1);
                String lang = this.lexer.getLanguage();
                String name = CompilerParserException.tokenText(token, this.tokenNames, lang, this.lexer.getState());
                String completionText = completionToken.getText();
                if (completionText.length() > 0 && name.startsWith(completionText)) {
                    Completion completion = new Completion(completionToken);
                    CompletionSuggestion suggestion = CompletionSuggestion.token(completion, name + " ");
                    if (this.listener != null) {
                        CompletionResult result = new CompletionResult(completionText);
                        result.addSuggestion(suggestion);
                        this.listener.reportError(new CompletionException(null, result));
                    }
                }
            }
            if (this.isDelimiter(this.LA(1))) {
                if (this.errorCount == 0) {
                    this.reportError((RecognitionException)e);
                }
                return;
            }
            int mark = this.mark();
            int line = this.LT(1).getLine();
            while (this.LA(1) != token && this.LA(1) != 1 && this.LT(1).getLine() == line) {
                this.consume();
            }
            if (this.LA(1) == token) {
                this.consume();
                this.reportError((RecognitionException)e);
            } else {
                this.rewind(mark);
                throw e;
            }
        }
    }

    public AST noViableAlt(Token token, String filename) throws RecognitionException {
        return this.noViableAlt(token, filename, "");
    }

    public AST noViableAlt(Token token, String filename, String rule) throws RecognitionException {
        Object result;
        int type = token.getType();
        if (this.isDelimiter(type) && this.inputState.guessing == 0) {
            if (this.errorCount == 0) {
                NoViableAltException error = new NoViableAltException(token, this.getFilename());
                error.line = token.getLine();
                error.column = token.getColumn();
                CompilerParserException exc = new CompilerParserException((RecognitionException)error, this.lexer.getCode(), this.expression);
                exc.setRule(rule);
                this.reportError(exc);
            }
            result = token.getType() == 17 ? new Completion(token) : new InvalidExpr(token, rule);
            this.consume();
        } else {
            result = super.noViableAlt(token, filename, rule);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseExpression() throws RecognitionException, TokenStreamException {
        try {
            this.expression = true;
            this.expressionOnly();
        }
        finally {
            this.expression = false;
        }
    }

    public void reportError(RecognitionException error) {
        this.reportError(new CompilerParserException(error, this.lexer.getCode(), this.expression));
    }

    public void reportError(CompilerParserException error) {
        ++this.errorCount;
        if (this.listener != null) {
            this.listener.reportError(error);
        }
    }

    public void reportWarning(RecognitionException warning) {
        this.reportWarning(new CompilerParserException(warning, this.lexer.getCode(), this.expression));
    }

    public void reportWarning(CompilerParserException warning) {
        if (this.listener != null) {
            this.listener.reportWarning(warning);
        }
    }

    public void reset() {
        this.inputState.reset();
        if (this.filter != null) {
            this.filter.reset();
        }
        this.errorCount = 0;
        this.setInsideSQL(false);
    }

    public void skipToNewLine() throws TokenStreamException {
        int line = this.LT(1).getLine();
        while (this.LT(1).getLine() == line && this.LA(1) != 1) {
            this.consume();
        }
    }

    public boolean isSQLExists(Token t1) {
        return this.equalsText(t1, "exists");
    }

    public boolean isSQLSelect() throws TokenStreamException {
        String keyWord = this.LT(1).getText();
        return keyWord.equalsIgnoreCase("SELECT");
    }

    public boolean isSQLStatement() throws TokenStreamException {
        String keyWord = this.LT(1).getText();
        if (keyWord.equalsIgnoreCase("INSERT")) {
            return this.LT(2).getText().equalsIgnoreCase("INTO");
        }
        if (keyWord.equalsIgnoreCase("DELETE")) {
            return this.LT(2).getText().equalsIgnoreCase("FROM");
        }
        if (keyWord.equalsIgnoreCase("UPDATE")) {
            int i = 1;
            do {
                if (this.LA(++i) == 7) continue;
                return false;
            } while (".".equals(this.LT(++i).getText()));
            while (this.LA(i) == 5) {
                ++i;
            }
            return this.LT(i).getText().equalsIgnoreCase("SET");
        }
        return false;
    }

    public boolean isTo(Token t1) {
        return t1 != null && "to".equals(t1.getText());
    }

    public boolean equals(Token t, String str) {
        return t != null && str.equals(t.getText());
    }

    public boolean equalsText(Token t1, String text) {
        return t1 != null && text.equalsIgnoreCase(t1.getText());
    }

    public Node handleException(RecognitionException error, String rule) throws RecognitionException, TokenStreamException {
        if (this.inputState.guessing != 0) {
            throw error;
        }
        if (this.listener != null) {
            CompilerParserException exc = new CompilerParserException(error, this.lexer.getCode(), this.expression);
            exc.setRule(rule);
            ++this.errorCount;
            if (this.errorCount > 100) {
                throw new IllegalStateException("too many errors");
            }
            this.listener.reportError(exc);
        }
        return new InvalidExpr(this.LT(1), rule);
    }

    protected boolean isDelimiter(int token) {
        return token == 1;
    }

    protected Node betweenStatement(Node statement, Node parent) throws TokenStreamException {
        Node result = statement;
        FuegoToken nextToken = (FuegoToken)this.LT(1);
        CommonHiddenStreamToken hiddenBefore = nextToken.getHiddenBefore();
        if (hiddenBefore != null && hiddenBefore.getType() != 0) {
            Node indentNodes = this.createIndentNodes(hiddenBefore);
            nextToken.setHiddenBefore(null);
            if (parent != null) {
                parent.addChild((AST)indentNodes);
            } else if (statement != null) {
                statement.setNext(indentNodes);
            } else {
                result = indentNodes;
            }
        }
        return result;
    }

    protected Node createIndentNodes(CommonHiddenStreamToken hiddenBefore) {
        Node result = null;
        CommonHiddenStreamToken prev = hiddenBefore.getHiddenBefore();
        if (prev != null) {
            result = this.createIndentNodes(prev);
        }
        Node indentNode = this.createIndentNode(hiddenBefore);
        if (result != null) {
            result.getLast().setNext(indentNode);
        } else {
            result = indentNode;
        }
        hiddenBefore.setType(0);
        return result;
    }

    private Node createIndentNode(CommonHiddenStreamToken token) {
        Node result = null;
        switch (token.getType()) {
            case 8: {
                result = new Comment((Token)token, token.getText());
                break;
            }
            case 9: {
                result = new Comment((Token)token, token.getText(), true);
                break;
            }
            case 6: {
                result = new NewLine(token.getText());
                break;
            }
            default: {
                System.out.println("unknown type: " + token.getType());
            }
        }
        return result;
    }
}

