/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import fuego.debugger.Breakpoint;
import fuego.debugger.BreakpointManager;
import fuego.debugger.DebugEventDispatcher;
import fuego.debugger.DebugEventListener;
import fuego.debugger.DebugStepDepth;
import fuego.debugger.DebugThread;
import fuego.debugger.ICatalogObjectFinder;
import fuego.debugger.LocalDebugSession;
import fuego.debugger.RemoteDebugSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugSession {
    private final Set<BreakpointManager> breakpointManagers = new HashSet<BreakpointManager>();
    @Nullable
    private ICatalogObjectFinder catalogFinder;
    private final List<String> classExclusionFilters = new ArrayList<String>();
    @Nullable
    private String classFilter;
    private DebugEventDispatcher eventDispatcher;
    private final Set<DebugEventListener> eventListeners = new IdentityHashSet<DebugEventListener>();
    private volatile EventSet eventSet;
    @Nullable
    private EventRequestManager requestManager;
    private State state = State.DISCONNECTED;
    @Nullable
    private StepRequest stepRequest;
    private Map<String, ObjectTypeDescription> typeCache = new HashMap<String, ObjectTypeDescription>();
    private VirtualMachine vm;

    public static RemoteDebugSession createRemote(String host, int port) {
        return new RemoteDebugSession(host, port);
    }

    public static LocalDebugSession createLocal(String className, String ... args) {
        return new LocalDebugSession(className, args);
    }

    public ObjectTypeDescription getLocationObjectTypeDescription(Location location) {
        MethodTypeDescription mtd;
        String sourceName;
        if (location.lineNumber() <= 0) {
            return null;
        }
        if (location.method().name().indexOf(36) != -1) {
            return null;
        }
        try {
            sourceName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            return null;
        }
        if (sourceName == null || !sourceName.endsWith(".xcdl")) {
            return null;
        }
        ObjectTypeDescription otd = this.findCatalogObject(location);
        if (otd == null) {
            return null;
        }
        String name = location.method().name();
        if (name.startsWith("CIL_")) {
            name = name.substring(4);
        }
        if ((mtd = otd.getMember(name, 14)) == null) {
            return null;
        }
        if (mtd.isHidden()) {
            return null;
        }
        return otd;
    }

    @Nullable
    public EventSet getEventSet() {
        return this.eventSet;
    }

    public void setEventSet(@Nullable EventSet eventSet) {
        this.eventSet = eventSet;
    }

    public void setCatalogFinder(@Nullable ICatalogObjectFinder catalogFinder) {
        this.catalogFinder = catalogFinder;
    }

    public void setClassFilter(@Nullable String classFilter) {
        this.classFilter = classFilter;
    }

    public void addClassExclusionFilter(String ... classPattern) {
        this.classExclusionFilters.addAll(Arrays.asList(classPattern));
    }

    public boolean isStepping() {
        return this.stepRequest != null;
    }

    public void step(@NotNull DebugThread debugThread, @NotNull DebugStepDepth stepDepth) {
        if (debugThread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugSession.step must not be null");
        }
        if (stepDepth == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/debugger/DebugSession.step must not be null");
        }
        this.step(debugThread, stepDepth.depth);
    }

    public final void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            throw new IllegalStateException("already connected");
        }
        try {
            this.vm = this.doConnect();
        }
        catch (IllegalConnectorArgumentsException e) {
            throw new RuntimeExceptionShell(e);
        }
        this.state = State.CONNECTED;
        this.vm.setDebugTraceMode(0);
        this.requestManager = this.vm.eventRequestManager();
        ClassPrepareRequest classPrepare = this.getRequestManager().createClassPrepareRequest();
        String clsFilter = this.classFilter;
        if (clsFilter == null) {
            for (String filter : this.classExclusionFilters) {
                classPrepare.addClassExclusionFilter(filter);
            }
        } else {
            classPrepare.addClassFilter(clsFilter);
        }
        classPrepare.setSuspendPolicy(1);
        classPrepare.enable();
        this.eventDispatcher = new DebugEventDispatcher(this);
        this.eventDispatcher.start();
        for (BreakpointManager breakpointManager : this.breakpointManagers) {
            breakpointManager.connected();
        }
    }

    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    public void disconnect() throws IllegalStateException {
        this.checkConnected();
        this.state = State.DISCONNECTED;
        this.vm.dispose();
        this.eventDispatcher.shutdown();
        this.resumeEvents();
        this.vm = null;
        this.eventDispatcher = null;
        this.requestManager = null;
    }

    public void addListener(DebugEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeListener(DebugEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public boolean isSuspended() {
        return this.getEventSet() != null;
    }

    public void resumeEvents() {
        EventSet events = this.getEventSet();
        if (events == null) {
            return;
        }
        this.setEventSet(null);
        events.resume();
    }

    abstract VirtualMachine doConnect() throws IOException, IllegalConnectorArgumentsException;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static <C extends Connector> C findConnector(String connectorName, List<C> list) throws IOException {
        Connector connector;
        Iterator<C> i$ = list.iterator();
        do {
            if (i$.hasNext()) continue;
            throw new IOException("No connector found : " + connectorName);
        } while (!connectorName.equals((connector = (Connector)i$.next()).name()));
        Connector connector2 = connector;
        if (connector2 == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugSession.findConnector must not return null");
        }
        return (C)connector2;
    }

    @Nullable
    ObjectTypeDescription findCatalogObject(@Nullable String sourceName) {
        if (sourceName == null) {
            return null;
        }
        ICatalogObjectFinder finder = this.catalogFinder;
        if (finder == null) {
            return null;
        }
        return finder.findOTD(sourceName);
    }

    @Nullable
    ObjectTypeDescription findCatalogObject(@NotNull Location location) {
        String sourcePath;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugSession.findCatalogObject must not be null");
        }
        try {
            sourcePath = location.sourcePath();
        }
        catch (AbsentInformationException e) {
            return null;
        }
        ObjectTypeDescription otd = this.typeCache.get(sourcePath);
        if (otd == null) {
            otd = this.findCatalogObject(sourcePath);
            this.typeCache.put(sourcePath, otd);
        }
        return otd;
    }

    @Nullable
    ObjectTypeDescription findCatalogObject(ObjectReference object) {
        List<String> sourcePaths;
        ReferenceType referenceType = object.referenceType();
        String stratum = this.vm.getDefaultStratum();
        try {
            sourcePaths = referenceType.sourcePaths(stratum);
        }
        catch (AbsentInformationException e) {
            return null;
        }
        String sourcePath = sourcePaths.get(0);
        return this.findCatalogObject(sourcePath);
    }

    @Nullable
    ObjectTypeDescription findCatalogObject(@Nullable Value value) {
        return value instanceof ObjectReference ? this.findCatalogObject((ObjectReference)value) : null;
    }

    VirtualMachine getVirtualMachine() {
        return this.vm;
    }

    void fireMethodEntered(MethodEntryEvent event) {
        String signature = event.method().signature();
        for (DebugEventListener eventListener : this.eventListeners) {
            eventListener.methodEntered(signature);
        }
    }

    void fireBreakpointActivated(BreakpointEvent event) {
        DebugThread thread = new DebugThread(this, event.thread());
        for (BreakpointManager breakpointManager : this.breakpointManagers) {
            for (Breakpoint breakpoint : breakpointManager.findBreakpoint(event)) {
                for (DebugEventListener eventListener : this.eventListeners) {
                    eventListener.breakpointActivated(breakpoint, thread);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    EventRequestManager getRequestManager() {
        this.checkConnected();
        EventRequestManager result = this.requestManager;
        assert (result != null);
        EventRequestManager eventRequestManager = result;
        if (eventRequestManager == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugSession.getRequestManager must not return null");
        }
        return eventRequestManager;
    }

    void fireStepFinished(StepEvent event) {
        DebugThread thread = new DebugThread(this, event.thread());
        this.stepRequest = null;
        this.getRequestManager().deleteEventRequest(event.request());
        for (DebugEventListener eventListener : this.eventListeners) {
            eventListener.stepFinished(thread);
        }
    }

    void fireClassPrepared(ClassPrepareEvent event) {
        ReferenceType referenceType = event.referenceType();
        String className = referenceType.name();
        for (DebugEventListener eventListener : this.eventListeners) {
            eventListener.classPrepared(className);
        }
        for (BreakpointManager breakpointManager : this.breakpointManagers) {
            breakpointManager.bindType(referenceType);
        }
    }

    void fireDisconnected() {
        this.state = State.DISCONNECTED;
        for (DebugEventListener eventListener : this.eventListeners) {
            eventListener.disconnected();
        }
    }

    void addBreakpointManager(BreakpointManager breakpointManager) {
        this.breakpointManagers.add(breakpointManager);
    }

    void removeBreakpointManager(BreakpointManager breakpointManager) {
        this.breakpointManagers.remove(breakpointManager);
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
    }

    private void step(@NotNull DebugThread debugThread, int depth) {
        StepRequest newRequest;
        if (debugThread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugSession.step must not be null");
        }
        EventRequestManager manager = this.getRequestManager();
        StepRequest oldRequest = this.stepRequest;
        if (oldRequest != null) {
            manager.deleteEventRequest(oldRequest);
        }
        this.stepRequest = newRequest = manager.createStepRequest(debugThread.getThread(), -2, depth);
        newRequest.setSuspendPolicy(2);
        String clsFilter = this.classFilter;
        if (clsFilter != null) {
            newRequest.addClassFilter(clsFilter);
        } else {
            for (String filter : this.classExclusionFilters) {
                newRequest.addClassExclusionFilter(filter);
            }
        }
        newRequest.addCountFilter(1);
        newRequest.enable();
        this.resumeEvents();
    }

    static enum State {
        CONNECTED,
        DISCONNECTED;

    }
}

