/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.rules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.bpel.services.rules.common.IDecisionServiceConstants;
import oracle.bpel.services.rules.rpi.IDataModel;
import oracle.bpel.services.rules.rpi.IRuleEngine;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.RuleEngineUtil;
import oracle.bpel.services.rules.rpi.RuleProviderException;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.bpel.services.rules.rpi.oracle2.OracleRuleEngine;
import oracle.bpel.services.rules.util.XSDGenerator;
import oracle.bpm.soa.rules.common.Constants;
import oracle.bpm.soa.rules.io.RulesIO;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.BaseSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.IncludeSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.SchemaExtension;
import oracle.j2ee.ws.wsdl.extensions.oracle.schema.SchemaSchemaElement;
import oracle.j2ee.ws.wsdl.extensions.wsif.format.FormatExtensionRegistry;
import oracle.j2ee.ws.wsdl.extensions.wsif.java.JavaExtensionRegistry;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public final class WsdlBuilder<E>
implements Constants,
IDecisionServiceConstants {
    DecisionServices m_decisionServices;
    String m_projectName;
    E m_projectRoot;
    RulesIO<E> m_rulesIO;
    WSDLFactory m_wsdlFactory;
    private Map<String, TDecisionService> m_decisionServiceMap = new HashMap<String, TDecisionService>();
    private RuleEngineFactory m_rpi_factory = RuleEngineFactory.getInstance();
    private Map<String, TRuleEngineProvider> m_ruleProviderMap = new HashMap<String, TRuleEngineProvider>();
    private static final int UNDEFINED = -1;
    private static final int CALL_FUNCTION_STATELESS = 6;
    private static final int CALL_FUNCTION_STATEFUL = 7;
    private static final String JAVA_NS = "http://schemas.xmlsoap.org/wsdl/java/";
    private static final String FORMAT_NS = "http://schemas.xmlsoap.org/wsdl/formatbinding/";
    private static final String WSI_CLAIM = "<documentation><wsi:Claim conformsTo=\"http://ws-i.org/profiles/basic1.0/\"/></documentation>";

    public WsdlBuilder(RulesIO<E> io, E projectRoot, String projectName, DecisionServices decisionServices) throws Exception {
        this.m_rulesIO = io;
        this.m_projectRoot = projectRoot;
        this.m_projectName = projectName;
        this.m_decisionServices = decisionServices;
        this.m_wsdlFactory = WSDLFactory.newInstance((String)"oracle.webservices.wsdl.WSDLFactoryImpl", (ClassLoader)Thread.currentThread().getContextClassLoader());
        this.init();
    }

    public Definition createWSDL(@NotNull String decisionServiceName, @NotNull URL dictionaryURL) throws Exception {
        Definition result = null;
        TDecisionService decisionService = this.m_decisionServiceMap.get(decisionServiceName);
        if (decisionService == null) {
            return null;
        }
        String targetNamespace = decisionService.getTargetNamespace();
        HashSet<TDecisionServicePatternName> patternPortSet = new HashSet<TDecisionServicePatternName>();
        result = this.m_wsdlFactory.newDefinition();
        result.setQName(new QName(targetNamespace, decisionServiceName));
        result.setTargetNamespace(targetNamespace);
        result.addNamespace("tns", targetNamespace);
        result.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        result.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        result.addNamespace("soap12", "http://schemas.xmlsoap.org/wsdl/soap12/");
        result.addNamespace("plt", "http://schemas.xmlsoap.org/ws/2003/05/partner-link/");
        result.addNamespace("java", JAVA_NS);
        result.addNamespace("format", FORMAT_NS);
        result.addNamespace("rules", "http://xmlns.oracle.com/bpel/rules");
        SchemaExtension.registerSerializersAndTypes((ExtensionRegistry)result.getExtensionRegistry());
        JavaExtensionRegistry.registerSerializersAndTypes((ExtensionRegistry)result.getExtensionRegistry());
        FormatExtensionRegistry.registerSerializersAndTypes((ExtensionRegistry)result.getExtensionRegistry());
        this.createTypes(result, decisionService, dictionaryURL);
        PortType portType = result.createPortType();
        portType.setQName(new QName(targetNamespace, "IDecisionService"));
        List patternList = decisionService.getPatterns();
        for (TPattern pattern : patternList) {
            TDecisionServicePatternName patternName = pattern.getName();
            if (patternPortSet.contains(patternName)) continue;
            switch (this.getPatternIdentifier(patternName)) {
                case 6: {
                    this.createCallFunctionStatelessPatternPortType(result, portType, targetNamespace);
                    break;
                }
                case 7: {
                    this.createCallFunctionStatefulPatternPortType(result, portType, targetNamespace);
                    break;
                }
            }
            patternPortSet.add(patternName);
        }
        result.addPortType(portType);
        return result;
    }

    protected int getPatternIdentifier(TDecisionServicePatternName pattern) {
        if (pattern == TDecisionServicePatternName.CALL_FUNCTION_STATELESS) {
            return 6;
        }
        if (pattern == TDecisionServicePatternName.CALL_FUNCTION_STATEFUL) {
            return 7;
        }
        return -1;
    }

    private void init() {
        int i;
        List configList = this.m_decisionServices.getRuleEngineProviders();
        int configListSize = configList.size();
        for (i = 0; i < configListSize; ++i) {
            TRuleEngineProvider rep = (TRuleEngineProvider)configList.get(i);
            this.m_ruleProviderMap.put(rep.getName(), rep);
        }
        configList = this.m_decisionServices.getDecisionServices();
        configListSize = configList.size();
        for (i = 0; i < configListSize; ++i) {
            TDecisionService ds = (TDecisionService)configList.get(i);
            this.m_decisionServiceMap.put(ds.getName(), ds);
        }
    }

    private void createTypes(Definition def, TDecisionService decisionService, URL dictionaryURL) throws DatatypeConfigurationException, ParserConfigurationException, RuleProviderException, IOException, URISyntaxException, WSDLException, TransformerException {
        TRuleEngineProvider reProvider = this.m_ruleProviderMap.get(decisionService.getRuleEngineProviderReference());
        if (reProvider == null) {
            throw new RuleProviderException(36162, new Object[]{decisionService.getName(), decisionService.getRuleEngineProviderReference()});
        }
        Types types = def.createTypes();
        SchemaSchemaElement dsSchema = new SchemaSchemaElement("http://www.w3.org/2001/XMLSchema");
        dsSchema.setAttributeValue("targetNamespace", decisionService.getTargetNamespace());
        def.setTypes(types);
        IRuleEngine ruleEngine = this.m_rpi_factory.createRuleEngine(reProvider);
        ((OracleRuleEngine)ruleEngine).setDictionaryURL(dictionaryURL);
        IDataModel dataModel = RuleEngineUtil.getDataModel((IRuleEngine)ruleEngine);
        List<E> xsdFileList = this.getFactTypeSchemaFiles();
        Object[] copyXsdResult = this.copyXsdToTemp(xsdFileList);
        List tempXsdFileList = (List)copyXsdResult[0];
        File tempDirectory = (File)copyXsdResult[1];
        RuleEngineUtil.resolveSchemaLocations((List)tempXsdFileList, (IDataModel)dataModel);
        IncludeSchemaElement inclDsSchema = new IncludeSchemaElement(dsSchema, (BaseSchemaElement)dsSchema);
        String schemaLocation = this.getSchemaLocation(null, decisionService, "MessageTypes.xsd");
        inclDsSchema.setSchemaLocation(schemaLocation);
        types.addExtensibilityElement((ExtensibilityElement)dsSchema);
        XSDGenerator xsdgen = new XSDGenerator();
        Document primitiveTypesDoc = xsdgen.createPrimitiveTypesDocument("http://xmlns.oracle.com/bpel/rules");
        this.m_rulesIO.writeDocumentToFile(this.m_projectRoot, "xsd", "DecisionServicePrimitiveTypes.xsd", primitiveTypesDoc, false);
        Document messageTypesDoc = xsdgen.createDecisionServiceTypesDocument(decisionService, ruleEngine, this.m_decisionServices.getName(), decisionService.getName() + "Types.xsd", tempDirectory.getAbsolutePath() + "/xsd");
        this.m_rulesIO.writeDocumentToFile(this.m_projectRoot, "xsd", decisionService.getName() + "MessageTypes.xsd", messageTypesDoc, true);
        this.m_rulesIO.generateTypesXSD(this.m_projectRoot, "xsd", decisionService);
        this.deleteTempDirectory(tempDirectory);
    }

    private Object[] copyXsdToTemp(List<E> xsdFileList) throws IOException {
        ArrayList<URI> resultList = new ArrayList<URI>(xsdFileList.size());
        String tempDirectoryName = UUID.randomUUID().toString();
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"), tempDirectoryName);
        tempDirectory.mkdirs();
        for (E xsdFile : xsdFileList) {
            String xsdFileName = this.m_rulesIO.getName(xsdFile);
            String xsdDirectoryPath = this.m_rulesIO.getFileName(xsdFile);
            xsdDirectoryPath = xsdDirectoryPath.substring(0, xsdDirectoryPath.length() - xsdFileName.length() - 1);
            File targetDirectory = new File(tempDirectory.getAbsolutePath() + xsdDirectoryPath);
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            File targetXsdFile = new File(targetDirectory, xsdFileName);
            this.m_rulesIO.copyFile(xsdFile, targetXsdFile);
            resultList.add(targetXsdFile.toURI());
        }
        return new Object[]{resultList, tempDirectory};
    }

    private boolean deleteTempDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] child = directory.list();
            for (int i = 0; i < child.length; ++i) {
                if (this.deleteTempDirectory(new File(directory, child[i]))) continue;
                return false;
            }
        }
        return directory.delete();
    }

    private String getSchemaLocation(String componentName, TDecisionService decisionService, String fileNameType) {
        String schemaLocation = "xsd/";
        if (!schemaLocation.endsWith("/")) {
            schemaLocation = schemaLocation + "/";
        }
        schemaLocation = componentName != null ? schemaLocation + componentName + decisionService.getName() + fileNameType : schemaLocation + decisionService.getName() + fileNameType;
        return schemaLocation;
    }

    private void createCallFunctionStatelessPatternPortType(Definition def, PortType portType, String targetNamespace) {
        Message inMsg = def.createMessage();
        Message outMsg = def.createMessage();
        Message faultMsg = def.createMessage();
        Part inPart = def.createPart();
        Part outPart = def.createPart();
        Part faultPart = def.createPart();
        inPart.setName("payload");
        inPart.setElementName(new QName(targetNamespace, "callFunctionStateless"));
        inMsg.setQName(new QName(targetNamespace, "callFunctionStatelessMessage"));
        inMsg.addPart(inPart);
        inMsg.setUndefined(false);
        def.addMessage(inMsg);
        outPart.setName("payload");
        outPart.setElementName(new QName(targetNamespace, "callFunctionStatelessDecision"));
        outMsg.setQName(new QName(targetNamespace, "callFunctionStatelessDecisionMessage"));
        outMsg.addPart(outPart);
        outMsg.setUndefined(false);
        def.addMessage(outMsg);
        faultPart.setName("payload");
        faultPart.setElementName(new QName(targetNamespace, "errorInfo"));
        faultMsg.setQName(new QName(targetNamespace, "decisionServiceError"));
        faultMsg.addPart(faultPart);
        faultMsg.setUndefined(false);
        def.addMessage(faultMsg);
        Input in = def.createInput();
        Output out = def.createOutput();
        Fault fault = def.createFault();
        in.setName("callFunctionStatelessInput");
        in.setMessage(inMsg);
        out.setName("callFunctionStatelessOutput");
        out.setMessage(outMsg);
        fault.setName("operationErroredFault");
        fault.setMessage(faultMsg);
        Operation op = def.createOperation();
        op.setName("callFunctionStateless");
        op.setStyle(OperationType.REQUEST_RESPONSE);
        op.setInput(in);
        op.setOutput(out);
        op.addFault(fault);
        op.setUndefined(false);
        portType.addOperation(op);
        portType.setUndefined(false);
    }

    private void createCallFunctionStatefulPatternPortType(Definition def, PortType portType, String targetNamespace) {
        Message inMsg = def.createMessage();
        Message outMsg = def.createMessage();
        Message faultMsg = def.createMessage();
        Part inPart = def.createPart();
        Part outPart = def.createPart();
        Part faultPart = def.createPart();
        inPart.setName("payload");
        inPart.setElementName(new QName(targetNamespace, "callFunctionStateful"));
        inMsg.setQName(new QName(targetNamespace, "callFunctionStatefulMessage"));
        inMsg.addPart(inPart);
        inMsg.setUndefined(false);
        def.addMessage(inMsg);
        outPart.setName("payload");
        outPart.setElementName(new QName(targetNamespace, "callFunctionStatefulDecision"));
        outMsg.setQName(new QName(targetNamespace, "callFunctionStatefulDecisionMessage"));
        outMsg.addPart(outPart);
        outMsg.setUndefined(false);
        def.addMessage(outMsg);
        faultPart.setName("payload");
        faultPart.setElementName(new QName(targetNamespace, "errorInfo"));
        faultMsg.setQName(new QName(targetNamespace, "decisionServiceError"));
        faultMsg.addPart(faultPart);
        faultMsg.setUndefined(false);
        def.addMessage(faultMsg);
        Input in = def.createInput();
        Output out = def.createOutput();
        Fault fault = def.createFault();
        in.setName("callFunctionStatefulInput");
        in.setMessage(inMsg);
        out.setName("callFunctionStatefulOutput");
        out.setMessage(outMsg);
        fault.setName("operationErroredFault");
        fault.setMessage(faultMsg);
        Operation op = def.createOperation();
        op.setName("callFunctionStateful");
        op.setStyle(OperationType.REQUEST_RESPONSE);
        op.setInput(in);
        op.setOutput(out);
        op.addFault(fault);
        op.setUndefined(false);
        portType.addOperation(op);
        portType.setUndefined(false);
    }

    private List<E> getFactTypeSchemaFiles() throws IOException, URISyntaxException {
        ArrayList resultList = new ArrayList();
        String regexp = "([^\\s]+(\\.(?i)(xsd))$)";
        E xsdFolder = this.m_rulesIO.createChild(this.m_projectRoot, "xsd");
        E businessCatalogFolder = this.m_rulesIO.createChild(this.m_projectRoot, "businessCatalog");
        E formsFolder = this.m_rulesIO.createChild(this.m_projectRoot, "forms");
        this.recursiveListFiles(resultList, xsdFolder, regexp);
        this.recursiveListFiles(resultList, businessCatalogFolder, regexp);
        this.recursiveListFiles(resultList, formsFolder, regexp);
        return resultList;
    }

    private void recursiveListFiles(List<E> schemaList, E schemaDirectory, String regexp) throws IOException, URISyntaxException {
        if (this.m_rulesIO.isDirectory(schemaDirectory) && this.m_rulesIO.getName(schemaDirectory).startsWith(".")) {
            return;
        }
        E[] fileList = this.m_rulesIO.listFiles(schemaDirectory);
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (this.m_rulesIO.isDirectory(fileList[i])) {
                    this.recursiveListFiles(schemaList, fileList[i], regexp);
                    continue;
                }
                if (!this.m_rulesIO.getFileURL(fileList[i]).toString().matches(regexp)) continue;
                schemaList.add(fileList[i]);
            }
        }
    }
}

