/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.rules;

import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TArgumentList;
import oracle.bpel.services.rules.rpi.model.TDecisionService;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpel.services.rules.rpi.model.TPattern;
import oracle.bpel.services.rules.util.DecisionServiceBuilder;
import oracle.bpm.soa.rules.WsdlBuilder;
import oracle.bpm.soa.rules.common.Constants;
import oracle.bpm.soa.rules.io.RulesIO;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DecisionServiceUtil<E>
implements Constants {
    String m_projectName;
    E m_projectRoot;
    RulesIO<E> m_rulesIO;

    DecisionServiceUtil(RulesIO<E> io, E projectRoot, String projectName) {
        this.m_rulesIO = io;
        this.m_projectRoot = projectRoot;
        this.m_projectName = projectName;
    }

    public void createDecisionComponent(DecisionFunction decisionFunction, String decisionServiceName) throws Exception {
        RuleDictionary dictionary = decisionFunction.getDictionary();
        String dictionaryName = dictionary.getName();
        DecisionServiceBuilder dsBuilder = new DecisionServiceBuilder(dictionaryName);
        dsBuilder.addOracleRuleEngineProvider("OracleRulesSDK", this.m_rulesIO.getRelativeProjectPathToDictionary(this.m_projectName, dictionary), dictionary, this.m_rulesIO.getDictionaryURL(this.m_projectRoot, dictionary));
        this.addDecsService(decisionFunction, decisionServiceName, dsBuilder);
    }

    public void addDecisionService(DecisionFunction decisionFunction, String decisionServiceName) throws Exception {
        String dictionaryName = decisionFunction.getDictionary().getName();
        DecisionServices decisionServices = this.loadDecisionServices(dictionaryName);
        DecisionServiceBuilder dsBuilder = new DecisionServiceBuilder(decisionServices);
        this.addDecsService(decisionFunction, decisionServiceName, dsBuilder);
    }

    public void removeDecisionService(String dictionaryName, String decisionServiceName) throws Exception {
        DecisionServices decisionServices = this.loadDecisionServices(dictionaryName);
        DecisionServiceBuilder dsBuilder = new DecisionServiceBuilder(decisionServices);
        dsBuilder.removeDecisionService(decisionServiceName);
        decisionServices = dsBuilder.getDecisionServices();
        this.saveDecisionServices(dictionaryName, decisionServices);
        this.deleteWSDLAndSchema(decisionServiceName);
    }

    public void updateDecisionService(DecisionFunction decisionFunction, String decisionServiceName) throws Exception {
        String dictionaryName = decisionFunction.getDictionary().getName();
        DecisionServices decisionServices = this.loadDecisionServices(dictionaryName);
        TDecisionService decisionService = new DecisionServiceBuilder(decisionServices).getDecisionService(decisionServiceName);
        List patterns = decisionService.getPatterns();
        for (TPattern pattern : patterns) {
            TArgumentList args;
            String callValue;
            if (!pattern.getName().equals((Object)TDecisionServicePatternName.CALL_FUNCTION_STATEFUL) && !pattern.getName().equals((Object)TDecisionServicePatternName.CALL_FUNCTION_STATELESS) || (callValue = (args = pattern.getArguments()).getCall()).equals(decisionFunction.getFullyQualifiedName())) continue;
            args.setCall(decisionFunction.getFullyQualifiedName());
        }
        this.saveDecisionServices(dictionaryName, decisionServices);
    }

    public String getDecisionServiceName(@NotNull DecisionFunction decisionFunction) throws Exception {
        String dictionaryName = decisionFunction.getDictionary().getName();
        DecisionServices decisionServices = this.loadDecisionServices(dictionaryName);
        for (TDecisionService decisionService : decisionServices.getDecisionServices()) {
            for (TPattern pattern : decisionService.getPatterns()) {
                TArgumentList args;
                String callValue;
                if (!pattern.getName().equals((Object)TDecisionServicePatternName.CALL_FUNCTION_STATEFUL) && !pattern.getName().equals((Object)TDecisionServicePatternName.CALL_FUNCTION_STATELESS) || !(callValue = (args = pattern.getArguments()).getCall()).equals(decisionFunction.getFullyQualifiedName())) continue;
                return decisionService.getName();
            }
        }
        return "";
    }

    public List<String> deleteDecisionComponent(String dictionaryName) throws Exception {
        ArrayList<String> decisionServiceNames = new ArrayList<String>();
        DecisionServices decisionServices = this.loadDecisionServices(dictionaryName);
        for (TDecisionService decisionService : decisionServices.getDecisionServices()) {
            String decisionServiceName = decisionService.getName();
            this.deleteWSDLAndSchema(decisionServiceName);
            decisionServiceNames.add(decisionServiceName);
        }
        this.m_rulesIO.deleteDecisionComponent(this.m_projectRoot, dictionaryName);
        return decisionServiceNames;
    }

    public DecisionServices loadDecisionServices(String dictionaryName) throws Exception {
        Reader decsReader = this.m_rulesIO.getDecisionComponentReader(this.m_projectRoot, dictionaryName);
        Unmarshaller unmarshaller = RuleEngineFactory.getInstance().createUnmarshaller();
        return (DecisionServices)unmarshaller.unmarshal(decsReader);
    }

    private void addDecsService(DecisionFunction decisionFunction, String decisionServiceName, DecisionServiceBuilder dsBuilder) throws Exception {
        String dictionaryName = decisionFunction.getDictionary().getName();
        String decisionServiceNamespace = "http://xmlns.oracle.com/" + dictionaryName + "/" + decisionServiceName;
        dsBuilder.addDecisionService(decisionServiceName, decisionServiceNamespace, "OracleRulesSDK", dictionaryName, null, decisionFunction.getFullyQualifiedName());
        DecisionServices decisionServices = dsBuilder.getDecisionServices();
        RuleDictionary dictionary = decisionFunction.getDictionary();
        URL dictionaryURL = this.m_rulesIO.getDictionaryURL(this.m_projectRoot, dictionary);
        this.saveDecisionServices(dictionaryName, decisionServices);
        this.saveDecisionServicesWSDL(decisionServiceName, decisionServices, dictionaryURL);
    }

    private void saveDecisionServicesWSDL(String decisionServiceName, DecisionServices decisionServices, URL dictionaryURL) throws Exception {
        boolean hasExistingWSDL = this.m_rulesIO.existsWSDL(this.m_projectRoot, decisionServiceName);
        Definition wsdlDefinition = this.createWSDLForService(decisionServiceName, decisionServices, dictionaryURL);
        if (hasExistingWSDL) {
            if (wsdlDefinition.getNamespace("plnk") == null) {
                wsdlDefinition.addNamespace("plnk", "http://schemas.xmlsoap.org/ws/2003/05/partner-link/");
            }
            Definition existingWsdlDefinition = this.m_rulesIO.getDecisionServiceWSDL(this.m_projectRoot, decisionServiceName);
            this.copyPartnerLink(existingWsdlDefinition, wsdlDefinition);
        }
        this.m_rulesIO.createDecisionServiceWSDL(this.m_projectRoot, decisionServiceName, wsdlDefinition);
    }

    private Definition createWSDLForService(String decisionServiceName, DecisionServices decisionServices, URL dictionaryURL) throws Exception {
        WsdlBuilder<E> wsdlUtil = new WsdlBuilder<E>(this.m_rulesIO, this.m_projectRoot, this.m_projectName, decisionServices);
        return wsdlUtil.createWSDL(decisionServiceName, dictionaryURL);
    }

    private void saveDecisionServices(String dictionaryName, DecisionServices decisionServices) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Marshaller marshaller = RuleEngineFactory.getInstance().createMarshaller();
        marshaller.marshal((Object)decisionServices, (Node)document);
        DOMSource source = new DOMSource(document);
        Writer decsWriter = this.m_rulesIO.getDecisionComponentWriter(this.m_projectRoot, dictionaryName);
        StreamResult result = new StreamResult(decsWriter);
        this.transform(source, result);
    }

    private void deleteWSDLAndSchema(String decisionServiceName) {
        this.m_rulesIO.deleteDecisionServiceWSDL(this.m_projectRoot, decisionServiceName);
        this.m_rulesIO.deleteDecisionServiceSchema(this.m_projectRoot, decisionServiceName, "MessageTypes");
        this.m_rulesIO.deleteDecisionServiceSchema(this.m_projectRoot, decisionServiceName, "Types");
    }

    private void transform(@NotNull Source source, @NotNull Result result) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    private void copyPartnerLink(Definition srcWsdl, Definition tgtWsdl) throws Exception {
        List srcExtensibilityElementsList = srcWsdl.getExtensibilityElements();
        for (ExtensibilityElement srcExtensibilityElement : srcExtensibilityElementsList) {
            QName srcElementType = srcExtensibilityElement.getElementType();
            if (!srcElementType.getLocalPart().equals("partnerLinkType")) continue;
            tgtWsdl.addExtensibilityElement(srcExtensibilityElement);
        }
    }
}

