/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.soa.io.AbstractIO;

class VFileIO
extends AbstractIO<VFile> {
    private VFileIO() {
    }

    public static VFileIO create() {
        return new VFileIO();
    }

    @Override
    public InputStream createInputStream(VFile file) throws IOException {
        return new VFileInputStream(file);
    }

    @Override
    public OutputStream createOutputStream(VFile file) throws IOException {
        return new VFileOutputStream(file);
    }

    @Override
    public VFile createChild(VFile parent, String name) {
        return parent.getFileSystem().createFile(parent, name);
    }

    @Override
    public String getName(VFile file) {
        return file.getName();
    }

    @Override
    public VFile getParentFile(VFile file) {
        return file.getParentFile();
    }

    @Override
    public String getFileName(VFile file) {
        return file.getCanonicalPath();
    }

    @Override
    public boolean existFile(VFile file) {
        return file.exists();
    }

    @Override
    public boolean deleteFile(VFile file) {
        return file.delete();
    }

    @Override
    public void createFolder(VFile file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    @Override
    public VFile getFolder(VFile root, String xmlSchemaDefinition) {
        int index = xmlSchemaDefinition.lastIndexOf("/");
        String location = index != -1 ? xmlSchemaDefinition.substring(0, index) : xmlSchemaDefinition;
        return root.getFileSystem().createFile(location);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public URL getFileURL(VFile file) throws IOException {
        return file.toURL();
    }

    public VFile[] listFiles(VFile directory, final String regexp) {
        return directory.listFiles(new VFileFilter(){

            public boolean accept(VFile pathName) {
                return pathName.toString().matches(regexp);
            }
        });
    }

    public VFile[] listFiles(VFile directory) {
        return directory.listFiles(new VFileFilter(){

            public boolean accept(VFile pathName) {
                return true;
            }
        });
    }

    @Override
    public boolean isDirectory(VFile file) {
        return file.isDirectory();
    }
}

