/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.bpm.soa.io.AbstractIO;

public class FileIO
extends AbstractIO<File> {
    private FileIO() {
    }

    public static FileIO create() {
        return new FileIO();
    }

    @Override
    public InputStream createInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    @Override
    public OutputStream createOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    @Override
    public File createChild(File parent, String name) {
        return new File(parent, name);
    }

    @Override
    public File getParentFile(File file) {
        return file.getParentFile();
    }

    @Override
    public String getName(File file) {
        return file.getName();
    }

    @Override
    public String getFileName(File file) {
        return file.getAbsolutePath();
    }

    @Override
    public boolean existFile(File file) {
        return file.exists();
    }

    @Override
    public boolean deleteFile(File file) {
        return file.delete();
    }

    @Override
    public void createFolder(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    @Override
    public File getFolder(File root, String xmlSchemaDefinition) {
        int index = xmlSchemaDefinition.lastIndexOf(File.separator);
        String location = index != -1 ? xmlSchemaDefinition.substring(0, index) : xmlSchemaDefinition;
        return new File(root, location);
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public URL getFileURL(File file) throws IOException {
        return file.toURI().toURL();
    }

    public boolean deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return dir.delete();
    }

    public File[] listFiles(File directory, String regexp) {
        return directory.listFiles(new FilenameMatchingFilter(regexp));
    }

    public File[] listFiles(File directory) {
        return directory.listFiles();
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public static class FilenameMatchingFilter
    implements FilenameFilter {
        private String m_regexp;

        public FilenameMatchingFilter(String regexp) {
            this.m_regexp = regexp;
        }

        public String getRegularExpression() {
            return this.m_regexp;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.m_regexp);
        }
    }
}

