/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpel.services.workflow.metadata.routingslip.model.ExcludedParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlipType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.GlobalConfigurationImpl;
import oracle.bpm.soa.humantask.impl.NotificationImpl;
import oracle.bpm.soa.humantask.impl.ParticipantsImpl;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import org.jetbrains.annotations.NotNull;

class RoutingSlipImpl
extends AbstractEntity<RoutingSlipType>
implements RoutingSlip,
TaskConstants {
    private GlobalConfigurationImpl globalConfiguration;
    private NotificationImpl notification;
    private Participant parent;
    private Participants participants;

    private RoutingSlipImpl(@NotNull RoutingSlipType routingSlip) {
        super(routingSlip);
    }

    public static RoutingSlipImpl create(TaskDefinition taskDef) {
        RoutingSlipType routingSlip = taskDef.getRoutingSlip();
        if (routingSlip == null) {
            routingSlip = RS_FACTORY.createRoutingSlip();
            taskDef.setRoutingSlip(routingSlip);
        }
        return RoutingSlipImpl.create(routingSlip);
    }

    public static RoutingSlipImpl create(@NotNull RoutingSlipType routingSlip) {
        return new RoutingSlipImpl(routingSlip);
    }

    public boolean equals(Object obj) {
        return obj instanceof RoutingSlipImpl && ((RoutingSlipType)this.getModel()).equals(((RoutingSlipImpl)obj).getModel());
    }

    @Override
    public Participants getParticipants() {
        if (this.participants == null) {
            this.participants = ParticipantsImpl.create((RoutingSlipType)this.getModel());
            this.participants.setParentRoutingSlip(this);
        }
        return this.participants;
    }

    @Override
    public void setParticipants(Participants participants) {
        ((RoutingSlipType)this.getModel()).setParticipants((ParticipantsType)((ParticipantsImpl)participants).getModel());
        this.participants = participants;
        this.participants.setParentRoutingSlip(this);
    }

    @Override
    public Participant getParent() {
        return this.parent;
    }

    public void setParent(Participant parent) {
        this.parent = parent;
    }

    @Override
    public GlobalConfigurationImpl getGlobalConfiguration() {
        if (this.globalConfiguration == null) {
            this.globalConfiguration = GlobalConfigurationImpl.create((RoutingSlipType)this.getModel());
        }
        return this.globalConfiguration;
    }

    @Override
    public void addExcludedParticipant(RoutingSlip.ExcludedParticipantsType value) {
        ExcludedParticipantsType excludedParticipants = this.getOrCreateExcludedParticipantType();
        List list = excludedParticipants.getExcludedParticipant();
        ExcludedParticipantsType.ExcludedParticipant excludedParticipant = RS_FACTORY.createExcludedParticipantsTypeExcludedParticipant();
        excludedParticipant.setValue(value.asString());
        if (!list.contains(excludedParticipant)) {
            list.add(excludedParticipant);
        }
    }

    @Override
    public List<RoutingSlip.ExcludedParticipantsType> getExcludedParticipants() {
        ArrayList<RoutingSlip.ExcludedParticipantsType> result = new ArrayList<RoutingSlip.ExcludedParticipantsType>();
        ExcludedParticipantsType excludedParticipants = ((RoutingSlipType)this.getModel()).getExcludedParticipants();
        if (excludedParticipants != null) {
            List list = excludedParticipants.getExcludedParticipant();
            for (Object object : list) {
                ExcludedParticipantsType.ExcludedParticipant excludedParticipant = (ExcludedParticipantsType.ExcludedParticipant)object;
                RoutingSlip.ExcludedParticipantsType type = RoutingSlip.ExcludedParticipantsType.create(excludedParticipant.getValue());
                if (result.contains((Object)type)) continue;
                result.add(type);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setExcludedParticipants(List<RoutingSlip.ExcludedParticipantsType> values) {
        if (values.isEmpty()) {
            ((RoutingSlipType)this.getModel()).setExcludedParticipants(null);
        } else {
            ExcludedParticipantsType excludedParticipants = this.getOrCreateExcludedParticipantType();
            List list = excludedParticipants.getExcludedParticipant();
            list.clear();
            for (RoutingSlip.ExcludedParticipantsType value : values) {
                String sValue = value.asString();
                if (list.contains(sValue)) continue;
                list.add(sValue);
            }
        }
    }

    @Override
    public NotificationImpl getNotification() {
        if (this.notification == null) {
            this.notification = NotificationImpl.create((RoutingSlipType)this.getModel());
        }
        return this.notification;
    }

    private ExcludedParticipantsType getOrCreateExcludedParticipantType() {
        ExcludedParticipantsType result = ((RoutingSlipType)this.getModel()).getExcludedParticipants();
        if (result == null) {
            result = RS_FACTORY.createExcludedParticipantsType();
            ((RoutingSlipType)this.getModel()).setExcludedParticipants(result);
        }
        return result;
    }
}

