/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import oracle.bpel.services.workflow.metadata.routingslip.model.FirstResponderType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParallelCompletionCriteriaType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpm.soa.humantask.FirstResponder;
import oracle.bpm.soa.humantask.ParallelResponder;
import oracle.bpm.soa.humantask.Responder;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.FirstResponderImpl;
import oracle.bpm.soa.humantask.impl.ParallelResponderImpl;
import org.jetbrains.annotations.NotNull;

class ResponderImpl
extends AbstractEntity<ParticipantsType.Parallel>
implements Responder.FirstResponder,
Responder.AllResponders,
Responder.Vote {
    private FirstResponder firstResponder;
    private ParallelResponder parallelResponder;
    private Responder.Type type;

    private ResponderImpl(@NotNull ParticipantsType.Parallel model, @NotNull Responder.Type type) {
        super(model);
        if (type.isFirstResponder()) {
            this.toFirstResponder();
        } else if (type.isAllResponders()) {
            this.toAllResponders();
        } else {
            this.toVote();
        }
    }

    public static Responder create(@NotNull ParticipantsType.Parallel parallel) {
        ParallelCompletionCriteriaType allResponders;
        FirstResponderType responderType = parallel.getFirstResponder();
        Responder result = responderType != null ? ResponderImpl.createFirstResponder(parallel) : ((allResponders = parallel.getAllResponders()) != null ? ResponderImpl.createAllResponders(parallel) : ResponderImpl.createVote(parallel));
        return result;
    }

    @Override
    public Responder.Type getType() {
        return this.type;
    }

    @Override
    public Responder.FirstResponder toFirstResponder() {
        if (!Responder.Type.FIRST_RESPONDER.equals((Object)this.getType())) {
            this.type = Responder.Type.FIRST_RESPONDER;
            this.firstResponder = FirstResponderImpl.create((ParticipantsType.Parallel)this.getModel());
        }
        return this;
    }

    @Override
    public Responder.Vote toVote() {
        if (!Responder.Type.VOTE.equals((Object)this.getType())) {
            this.type = Responder.Type.VOTE;
            this.parallelResponder = ParallelResponderImpl.createVote((ParticipantsType.Parallel)this.getModel());
        }
        return this;
    }

    @Override
    public Responder.AllResponders toAllResponders() {
        if (!Responder.Type.ALL_RESPONDERS.equals((Object)this.getType())) {
            this.type = Responder.Type.ALL_RESPONDERS;
            this.parallelResponder = ParallelResponderImpl.createAllResponders((ParticipantsType.Parallel)this.getModel());
        }
        return this;
    }

    @Override
    public FirstResponder getFirstResponder() {
        return this.firstResponder;
    }

    @Override
    public ParallelResponder getParallelResponder() {
        return this.parallelResponder;
    }

    private static Responder.FirstResponder createFirstResponder(@NotNull ParticipantsType.Parallel parallel) {
        return new ResponderImpl(parallel, Responder.Type.FIRST_RESPONDER);
    }

    private static Responder.AllResponders createAllResponders(@NotNull ParticipantsType.Parallel parallel) {
        return new ResponderImpl(parallel, Responder.Type.ALL_RESPONDERS);
    }

    private static Responder.Vote createVote(@NotNull ParticipantsType.Parallel parallel) {
        return new ResponderImpl(parallel, Responder.Type.VOTE);
    }
}

