/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.config.model.MessageAttributeType;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.soa.humantask.Factory;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.AbstractNamespaceContext;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PayloadImpl
extends AbstractEntity<PayloadType>
implements Payload,
TaskConstants {
    private transient List<Payload.Attribute> attributeList;
    private PayloadNamespaceContext namespaceContext;
    private Map<String, String> schemaLocationMap;
    public static final String HTTP_WWW_W3_ORG_2001_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String HTTP_WWW_FREVVO_COM_APPINFO = "http://www.frevvo.com/appinfo";
    private static final String IMPORT_NAME = "import";
    private static final String ELEMENT_NAME = "element";
    private static final String REF_ATTR = "ref";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String XMLNS_ATTR = "xmlns";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    private static final String PAYLOAD_TEMPLATE = "xsd/payload.xsd";

    private PayloadImpl(@NotNull PayloadType payloadType, WorkflowConfigurationType wfc, @Nullable XMLDocument payloadDocument) {
        super(payloadType);
        this.namespaceContext = PayloadNamespaceContext.create((JaxbNode)wfc);
        this.schemaLocationMap = PayloadImpl.createSchemaLocationMap(payloadDocument);
    }

    public static PayloadImpl create(WorkflowConfigurationType wfc, @Nullable XMLDocument payloadDocument) {
        PayloadType payloadType = wfc.getPayload();
        if (payloadType == null) {
            payloadType = CONFIG_FACTORY.createPayloadType();
            wfc.setPayload(payloadType);
        }
        return new PayloadImpl(payloadType, wfc, payloadDocument);
    }

    @Override
    public void updateFromPayloadXsd(InputStream xsdInputStream, String schemaLocation) {
        Map<String, String> importedNamespaceMap = null;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(xsdInputStream);
            XMLDocument xmlDocument = parser.getDocument();
            NodeList sequenceList = xmlDocument.getElementsByTagName("sequence");
            if (sequenceList.getLength() > 0) {
                this.cleanAttributes();
                NodeList nodeList = sequenceList.item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    AttributeImpl newAttribute;
                    XMLElement element = (XMLElement)nodeList.item(i);
                    boolean isSimpleAttr = element.hasAttribute(NAME_ATTR);
                    if (isSimpleAttr) {
                        String name = element.getAttribute(NAME_ATTR);
                        String attrTypeStr = element.getAttribute(TYPE_ATTR);
                        QName qname = this.createQName(attrTypeStr, true);
                        newAttribute = AttributeImpl.createSimpleAttribute(name, qname);
                    } else {
                        if (importedNamespaceMap == null) {
                            importedNamespaceMap = PayloadImpl.createSchemaLocationMap(xmlDocument);
                        }
                        String attrRefStr = element.getAttribute(REF_ATTR);
                        QName qname = this.createQName(attrRefStr, true);
                        String attrNamespace = xmlDocument.getDocumentElement().getAttribute("xmlns:" + qname.getPrefix());
                        QName completeQName = new QName(attrNamespace, qname.getLocalPart(), qname.getPrefix());
                        String attrSchemaLocation = importedNamespaceMap.get(attrNamespace);
                        newAttribute = AttributeImpl.createElementAttribute(completeQName, attrSchemaLocation);
                    }
                    this.addAttribute(newAttribute);
                }
            }
        }
        catch (XMLParseException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                xsdInputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void updateFromXsd(InputStream xsdInputStream, String schemaLocation) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(xsdInputStream);
            XMLDocument xmlDocument = parser.getDocument();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(XsdPayloadNamespaceContext.create());
            Node schema = (Node)xpath.evaluate("/xsd:schema", xmlDocument, XPathConstants.NODE);
            String namespace = schema.getAttributes().getNamedItem(XMLNS_ATTR).getNodeValue();
            Node element = (Node)xpath.evaluate("/xsd:schema/xsd:element", xmlDocument, XPathConstants.NODE);
            String name = element.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
            if (!this.existsAttribute(name)) {
                QName qName = new QName(namespace, name);
                Payload.Attribute attribute = Factory.task().payload().createElementAttribute(qName, schemaLocation);
                this.cleanAttributes();
                this.addAttribute(attribute);
            }
        }
        catch (XMLParseException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                xsdInputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<Payload.Attribute> getAttributes() {
        return Collections.unmodifiableList(this.getAttributeList());
    }

    @Override
    public void addAttribute(Payload.Attribute attribute) {
        List<Payload.Attribute> attributeList = this.getAttributeList();
        List attributes = ((PayloadType)this.getModel()).getMessageAttribute();
        AttributeImpl attributeImpl = (AttributeImpl)attribute;
        String namespace = attribute.getQName().getNamespaceURI();
        String prefix = this.namespaceContext.getPrefix(namespace);
        if (prefix == null) {
            prefix = this.namespaceContext.createNewPrefix(namespace);
        }
        this.namespaceContext.register(prefix, namespace);
        attributeImpl.setPrefix(prefix);
        attributes.add(attributeImpl.getModel());
        attributeList.add(attribute);
    }

    @Override
    public void removeAttribute(Payload.Attribute attribute) {
        List<Payload.Attribute> attributeList = this.getAttributeList();
        List attributes = ((PayloadType)this.getModel()).getMessageAttribute();
        MessageAttributeType messageAttributeType = (MessageAttributeType)((AttributeImpl)attribute).getModel();
        attributes.remove(messageAttributeType);
        attributeList.remove(attribute);
        String prefix = PayloadImpl.getPrefix(messageAttributeType.getType());
        boolean isPrefixUsed = false;
        String prefixToken = prefix + ":";
        for (Object object : attributes) {
            MessageAttributeType mat = (MessageAttributeType)object;
            String type = mat.getType();
            if (!type.startsWith(prefixToken)) continue;
            isPrefixUsed = true;
            break;
        }
        if (!isPrefixUsed) {
            this.namespaceContext.unregister(prefix);
        }
    }

    @Override
    public void setXmlSchemaDefinition(String value) {
        ((PayloadType)this.getModel()).setXmlSchemaDefinition(value);
    }

    @Override
    public String getXmlSchemaDefinition() {
        return ((PayloadType)this.getModel()).getXmlSchemaDefinition();
    }

    @Override
    public void setExternalSchema(boolean value) {
        ((PayloadType)this.getModel()).setExternalSchema(value);
    }

    @Override
    public boolean isExternalSchema() {
        return ((PayloadType)this.getModel()).isExternalSchema();
    }

    public XMLDocument getXsdDocument(String taskName) throws HumanTaskException {
        XMLDocument document;
        block11: {
            document = PayloadImpl.getXsdTemplateDocument();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XsdPayloadNamespaceContext nsContext = XsdPayloadNamespaceContext.create();
            List<Payload.Attribute> attributes = this.getAttributes();
            for (Payload.Attribute attribute : attributes) {
                QName qName = attribute.getQName();
                String namespace = qName.getNamespaceURI();
                String prefix = nsContext.getPrefix(namespace);
                if (prefix != null) continue;
                prefix = nsContext.createNewPrefix(namespace);
                nsContext.register(prefix, namespace);
            }
            xpath.setNamespaceContext(nsContext);
            try {
                Node schemaNode = (Node)xpath.evaluate("/xsd:schema", document, XPathConstants.NODE);
                Node complexTypeNode = (Node)xpath.evaluate("/xsd:schema/xsd:complexType", document, XPathConstants.NODE);
                Node sequenceNode = (Node)xpath.evaluate("/xsd:schema/xsd:complexType/xsd:sequence", document, XPathConstants.NODE);
                if (schemaNode instanceof Element && complexTypeNode instanceof Element && sequenceNode instanceof Element) {
                    ((Element)complexTypeNode).setAttribute(NAME_ATTR, taskName + "PayloadType");
                    if (!attributes.isEmpty()) {
                        List<String> namespaces = nsContext.getNamespaces();
                        for (String namespace : namespaces) {
                            String prefix = nsContext.getPrefix(namespace);
                            Attr attr = document.createAttribute("xmlns:" + prefix);
                            attr.setNodeValue(namespace);
                            ((Element)schemaNode).setAttributeNode(attr);
                        }
                        List<Payload.Attribute> attributesToImport = PayloadImpl.getAttributesToImport(attributes);
                        if (!attributesToImport.isEmpty()) {
                            for (Payload.Attribute attribute : attributesToImport) {
                                Element importElement = document.createElementNS(HTTP_WWW_W3_ORG_2001_XMLSCHEMA, IMPORT_NAME);
                                QName qName = attribute.getQName();
                                String namespace = qName.getNamespaceURI();
                                importElement.setAttribute(NAMESPACE_ATTR, namespace);
                                importElement.setAttribute(SCHEMA_LOCATION_ATTR, attribute.getSchemaLocation());
                                schemaNode.insertBefore(importElement, complexTypeNode);
                            }
                        }
                        Element rootElement = document.createElementNS(HTTP_WWW_W3_ORG_2001_XMLSCHEMA, ELEMENT_NAME);
                        rootElement.setAttribute(NAME_ATTR, "HumanTaskPayload");
                        rootElement.setAttribute(TYPE_ATTR, "tns:" + taskName + "PayloadType");
                        Element annotation = document.createElementNS(HTTP_WWW_W3_ORG_2001_XMLSCHEMA, "annotation");
                        Element appinfo = document.createElementNS(HTTP_WWW_W3_ORG_2001_XMLSCHEMA, "appinfo");
                        annotation.appendChild(appinfo);
                        Element globalElement = document.createElementNS(HTTP_WWW_FREVVO_COM_APPINFO, "globalElement");
                        globalElement.setTextContent("true");
                        appinfo.appendChild(globalElement);
                        rootElement.appendChild(annotation);
                        schemaNode.insertBefore(rootElement, complexTypeNode);
                        for (Payload.Attribute attribute : attributes) {
                            Element sequenceElement = document.createElementNS(HTTP_WWW_W3_ORG_2001_XMLSCHEMA, ELEMENT_NAME);
                            QName qName = attribute.getQName();
                            String namespace = qName.getNamespaceURI();
                            String prefix = nsContext.getPrefix(namespace);
                            if (attribute.getAttributeType().isElement()) {
                                sequenceElement.setAttribute(REF_ATTR, prefix + ":" + attribute.getName());
                            } else {
                                sequenceElement.setAttribute(NAME_ATTR, attribute.getName());
                                sequenceElement.setAttribute(TYPE_ATTR, prefix + ":" + qName.getLocalPart());
                            }
                            sequenceNode.appendChild(sequenceElement);
                        }
                    }
                    break block11;
                }
                throw HumanTaskException.create(HumantaskMsg.ERROR_UPDATING_PAYLOAD_TEMPLATE(PAYLOAD_TEMPLATE, taskName));
            }
            catch (Throwable e) {
                throw HumanTaskException.create(HumantaskMsg.ERROR_UPDATING_PAYLOAD_TEMPLATE(PAYLOAD_TEMPLATE, taskName));
            }
        }
        return document;
    }

    protected static Map<String, String> createSchemaLocationMap(@Nullable XMLDocument document) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (document != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XsdPayloadNamespaceContext nsContext = XsdPayloadNamespaceContext.create();
            xpath.setNamespaceContext(nsContext);
            try {
                Node schemaNode = (Node)xpath.evaluate("/xsd:schema", document, XPathConstants.NODE);
                if (schemaNode != null) {
                    NodeList childNodes = schemaNode.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node node = childNodes.item(i);
                        String name = node.getNodeName();
                        if (!IMPORT_NAME.equals(name)) continue;
                        Element importElement = (Element)node;
                        String nameSpace = importElement.getAttribute(NAMESPACE_ATTR);
                        String schemaLocation = importElement.getAttribute(SCHEMA_LOCATION_ATTR);
                        result.put(nameSpace, schemaLocation);
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result;
    }

    static Payload.Attribute createSimpleAttribute(@NotNull String name, @NotNull QName qname) {
        return AttributeImpl.createSimpleAttribute(name, qname);
    }

    static Payload.Attribute createComplexAttribute(@NotNull String name, @NotNull QName qname, String schemaLocation) {
        return AttributeImpl.createComplexAttribute(name, qname, schemaLocation);
    }

    static Payload.Attribute createElementAttribute(@NotNull QName qname, String schemaLocation) {
        return AttributeImpl.createElementAttribute(qname, schemaLocation);
    }

    private static List<Payload.Attribute> getAttributesToImport(List<Payload.Attribute> attributes) {
        ArrayList<Payload.Attribute> result = new ArrayList<Payload.Attribute>();
        for (Payload.Attribute item : attributes) {
            QName qName = item.getQName();
            if (HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(qName.getNamespaceURI())) continue;
            result.add(item);
        }
        return result;
    }

    private static String getPrefix(String attributeType) {
        int i = attributeType.indexOf(":");
        return i == -1 ? "" : attributeType.substring(0, i);
    }

    private static String getLocalPart(String attributeType) {
        int i = attributeType.indexOf(":");
        return i == -1 ? attributeType : attributeType.substring(i + 1);
    }

    private static XMLDocument getXsdTemplateDocument() throws HumanTaskException {
        InputStream in = null;
        XMLDocument result = null;
        try {
            in = HumanTask.class.getResourceAsStream(PAYLOAD_TEMPLATE);
            DOMParser parser = new DOMParser();
            parser.parse(in);
            result = parser.getDocument();
        }
        catch (Throwable e) {
            try {
                throw HumanTaskException.create(HumantaskMsg.ERROR_LOADING_PAYLOAD_TEMPLATE(PAYLOAD_TEMPLATE));
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{in});
        return result;
    }

    private void cleanAttributes() {
        Payload.Attribute[] attributes;
        for (Payload.Attribute attr : attributes = this.getAttributeList().toArray(new Payload.Attribute[this.getAttributeList().size()])) {
            this.removeAttribute(attr);
        }
    }

    private boolean existsAttribute(String attributesName) {
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            Payload.Attribute attribute = this.getAttributes().get(i);
            if (!attribute.getName().equals(attributesName)) continue;
            return true;
        }
        return false;
    }

    private List<Payload.Attribute> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<Payload.Attribute>();
            List attributes = ((PayloadType)this.getModel()).getMessageAttribute();
            for (Object object : attributes) {
                MessageAttributeType messageAttributeType = (MessageAttributeType)object;
                String attributeType = messageAttributeType.getType();
                QName qname = this.createQName(attributeType);
                Payload.AttributeType type = Payload.AttributeType.valueOfSafe(messageAttributeType.getAttributeType());
                String schemaLocation = type != null && (type.isElement() || type.isComplex()) ? this.schemaLocationMap.get(qname.getNamespaceURI()) : "";
                AttributeImpl item = AttributeImpl.createAttribute(messageAttributeType, qname, schemaLocation);
                this.attributeList.add(item);
            }
        }
        return this.attributeList;
    }

    private QName createQName(String attributeType, boolean includePrefix) {
        String prefix = PayloadImpl.getPrefix(attributeType);
        String namespace = this.namespaceContext.getNamespaceURI(prefix);
        String localPart = PayloadImpl.getLocalPart(attributeType);
        QName result = includePrefix ? new QName(namespace, localPart, prefix) : new QName(namespace, localPart);
        return result;
    }

    private QName createQName(String attributeType) {
        return this.createQName(attributeType, false);
    }

    private static class XsdPayloadNamespaceContext
    extends AbstractNamespaceContext {
        private XsdPayloadNamespaceContext() {
            this.register("tns", "http://xmlns.oracle.com/bpel/workflow/task");
            this.register("xsd", PayloadImpl.HTTP_WWW_W3_ORG_2001_XMLSCHEMA);
        }

        public static XsdPayloadNamespaceContext create() {
            return new XsdPayloadNamespaceContext();
        }
    }

    private static class PayloadNamespaceContext
    extends AbstractNamespaceContext {
        private JaxbNode jaxbNode;

        private PayloadNamespaceContext(JaxbNode jaxbNode) {
            this.jaxbNode = jaxbNode;
            this.populateNamespaceContext();
        }

        public static PayloadNamespaceContext create(JaxbNode jaxbNode) {
            return new PayloadNamespaceContext(jaxbNode);
        }

        @Override
        public void register(String prefix, String namespace) {
            super.register(prefix, namespace);
            try {
                JaxbUtil.setNamespaceDeclaration((JaxbNode)this.jaxbNode, (String)prefix, (String)namespace);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void unregister(String prefix) {
            super.unregister(prefix);
            try {
                XMLElement element = this.jaxbNode.getDOMNode();
                element.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }

        private void populateNamespaceContext() {
            Map map = new HashMap();
            try {
                map = JaxbUtil.getNamespaceDeclaration((JaxbNode)this.jaxbNode);
            }
            catch (JAXBException e) {
                // empty catch block
            }
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                super.register(prefix, namespace);
            }
        }
    }

    static class AttributeImpl
    extends AbstractEntity<MessageAttributeType>
    implements Payload.Attribute {
        private QName qname;
        private String schemaLocation;
        private static final long serialVersionUID = -5312568173661357415L;

        protected AttributeImpl(@NotNull MessageAttributeType attribute, @NotNull QName qname, String schemaLocation) {
            super(attribute);
            this.qname = qname;
            this.schemaLocation = schemaLocation;
        }

        public static AttributeImpl createAttribute(@NotNull MessageAttributeType attribute, @NotNull QName qname, String schemaLocation) {
            return new AttributeImpl(attribute, qname, schemaLocation);
        }

        public static AttributeImpl createSimpleAttribute(@NotNull String name, @NotNull QName qname) {
            MessageAttributeType attribute = AttributeImpl.createDefaultMessageAttributeType();
            attribute.setName(name);
            attribute.setAttributeType(Payload.AttributeType.SIMPLE_TYPE.toString());
            return new AttributeImpl(attribute, qname, "");
        }

        public static AttributeImpl createComplexAttribute(@NotNull String name, @NotNull QName qname, String schemaLocation) {
            MessageAttributeType attribute = AttributeImpl.createDefaultMessageAttributeType();
            attribute.setName(name);
            attribute.setAttributeType(Payload.AttributeType.COMPLEX_TYPE.toString());
            return new AttributeImpl(attribute, qname, schemaLocation);
        }

        public static AttributeImpl createElementAttribute(@NotNull QName qname, String schemaLocation) {
            MessageAttributeType attribute = AttributeImpl.createDefaultMessageAttributeType();
            attribute.setName(qname.getLocalPart());
            attribute.setAttributeType(Payload.AttributeType.ELEMENT.toString());
            return new AttributeImpl(attribute, qname, schemaLocation);
        }

        @Override
        public QName getQName() {
            return this.qname;
        }

        @Override
        public String getName() {
            return ((MessageAttributeType)this.getModel()).getName();
        }

        @Override
        public void setName(String name) {
            if (!this.getAttributeType().isElement()) {
                ((MessageAttributeType)this.getModel()).setName(name);
            }
        }

        public void setPrefix(String prefix) {
            ((MessageAttributeType)this.getModel()).setType(prefix + ":" + this.qname.getLocalPart());
        }

        @Override
        public String getType() {
            return this.getQName().getLocalPart();
        }

        @Override
        public Payload.AttributeType getAttributeType() {
            return Payload.AttributeType.valueOfSafe(((MessageAttributeType)this.getModel()).getAttributeType());
        }

        @Override
        public boolean isEditable() {
            return ((MessageAttributeType)this.getModel()).isUpdatable();
        }

        @Override
        public void setEditable(boolean value) {
            ((MessageAttributeType)this.getModel()).setUpdatable(value);
        }

        @Override
        public String getSchemaLocation() {
            return this.schemaLocation;
        }

        @Override
        public void setSchemaLocation(String value) {
            this.schemaLocation = value;
        }

        protected static MessageAttributeType createDefaultMessageAttributeType() {
            MessageAttributeType result = CONFIG_FACTORY.createMessageAttributeType();
            result.setExternal(false);
            result.setUpdatable(true);
            return result;
        }
    }
}

