/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlipType;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.impl.ParticipantImpl;
import org.jetbrains.annotations.NotNull;

class ParticipantsImpl
extends ParticipantImpl<ParticipantsType>
implements Participants {
    private List<Participant> children;
    private RoutingSlip parentRS;

    private ParticipantsImpl(ParticipantsType participantsType, Participant.Type type) {
        this((Participants)null, participantsType, type);
    }

    private ParticipantsImpl(Participants parent, ParticipantsType participantsType, Participant.Type type) {
        super(parent, participantsType, type);
    }

    public static Participants create(RoutingSlipType routingSlip) {
        ParticipantsType participantsType = routingSlip.getParticipants();
        if (participantsType == null) {
            participantsType = RS_FACTORY.createParticipantsType();
            routingSlip.setParticipants(participantsType);
        }
        return ParticipantsImpl.create(participantsType);
    }

    public static Participants create(@NotNull ParticipantsType participantsType) {
        return new ParticipantsImpl(participantsType, Participant.Type.PARTICIPANTS);
    }

    public static Participants.Stage createStage(@NotNull ParticipantsType.Stage participantsType) {
        return new StageImpl(null, participantsType);
    }

    public static Participants.ForEach createForEach(@NotNull ParticipantsType.ForEach participantsType) {
        return new ForEachImpl(null, participantsType);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String value) {
    }

    @Override
    public void add(Participant participant) {
        this.getChildren().add(participant);
        participant.setParent(this);
        List list = ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc();
        list.add(((ParticipantImpl)participant).getModel());
    }

    @Override
    public void add(int index, Participant participant) {
        List<Participant> participants = this.getChildren();
        if (index == 0 || index > 0 && index < participants.size()) {
            participants.add(index, participant);
            participant.setParent(this);
            List list = ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc();
            Object model = ((ParticipantImpl)participant).getModel();
            if (index == list.size()) {
                list.add(model);
            } else {
                list.add(index, model);
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void addAfter(Participant participant, Participant reference) {
        List list = ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc();
        int i = list.indexOf(((ParticipantImpl)reference).getModel());
        int index = i == -1 ? list.size() : i + 1;
        this.getChildren().add(index, participant);
        participant.setParent(this);
        Object model = ((ParticipantImpl)participant).getModel();
        if (index == list.size()) {
            list.add(model);
        } else {
            list.add(index, model);
        }
    }

    @Override
    public void remove(Participant participant) {
        this.getChildren().remove(participant);
        participant.setParent(null);
        List list = ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc();
        list.remove(((ParticipantImpl)participant).getModel());
    }

    @Override
    public List<Participant> getParticipants() {
        return Collections.unmodifiableList(this.getChildren());
    }

    @Override
    public void setParticipants(List<Participant> participants) {
        ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc().clear();
        this.getChildren().clear();
        for (Participant participant : participants) {
            this.add(participant);
        }
    }

    @Override
    public boolean isAdhocRoutingSupported() {
        return ((ParticipantsType)this.getModel()).isIsAdhocRoutingSupported();
    }

    @Override
    public void setAdhocRoutingSupported(boolean value) {
        ((ParticipantsType)this.getModel()).setIsAdhocRoutingSupported(value);
    }

    @Override
    public RoutingSlip getParentRoutingSlip() {
        return this.parentRS;
    }

    @Override
    public void setParentRoutingSlip(RoutingSlip rs) {
        this.parentRS = rs;
    }

    private List<Participant> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Participant>();
            List list = ((ParticipantsType)this.getModel()).getParticipantOrSequentialParticipantOrAdhoc();
            for (Object object : list) {
                Participant participant = ParticipantImpl.create(object);
                participant.setParent(this);
                this.children.add(participant);
            }
        }
        return this.children;
    }

    private static class StageImpl
    extends ParticipantsImpl
    implements Participants.Stage {
        private StageImpl(Participants parent, ParticipantsType.Stage participantsType) {
            super(parent, (ParticipantsType)participantsType, Participant.Type.STAGE);
        }

        @Override
        public void setName(String name) {
            this.getModel().setName(name);
        }

        @Override
        public String getName() {
            return this.getModel().getName();
        }

        @Override
        public ParticipantsType.Stage getModel() {
            return (ParticipantsType.Stage)super.getModel();
        }
    }

    public static class ForEachImpl
    extends ParticipantsImpl
    implements Participants.ForEach {
        private ForEachImpl(Participants parent, ParticipantsType.ForEach participantsType) {
            super(parent, (ParticipantsType)participantsType, Participant.Type.FOREACH);
        }

        @Override
        public ParticipantsType.ForEach getModel() {
            return (ParticipantsType.ForEach)super.getModel();
        }
    }
}

