/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.workflow.metadata.routingslip.model.ListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.LogicalPeopleGroupListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceListType;
import oracle.bpm.soa.humantask.LogicalPeopleGroup;
import oracle.bpm.soa.humantask.NamesAndExpressions;
import oracle.bpm.soa.humantask.ParticipantList;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.LogicalPeopleGroupImpl;
import oracle.bpm.soa.humantask.impl.NamesAndExpressionsImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticipantListImpl
extends AbstractEntity<ListType>
implements ParticipantList.NamesAndExpressions,
ParticipantList.ApprovalGroups,
ParticipantList.JobLevel,
ParticipantList.Position,
ParticipantList.Supervisory,
ParticipantList.ManagementChain,
ParticipantList.RuleBased,
ParticipantList.LogicalPeopleGroup {
    private LogicalPeopleGroupImpl logicalPeopleGroup;
    private NamesAndExpressionsImpl namesAndExpressions;
    private ParticipantList.Sources participantListSources;
    private ParticipantList.Type type;
    private static Map<Class<? extends ParticipantList>, ParticipantList.Type> classToTypeMap = new HashMap<Class<? extends ParticipantList>, ParticipantList.Type>();

    private ParticipantListImpl(ListType model, @Nullable ParticipantList.Sources participantListSources) {
        super(model != null ? model : RS_FACTORY.createList());
        this.participantListSources = participantListSources;
        if (model == null) {
            this.type = ParticipantList.Type.NAMES_AND_EXPRESSIONS;
            this.namesAndExpressions = NamesAndExpressionsImpl.createValueBased(participantListSources);
        } else if (model.getResourceList() != null) {
            this.type = ParticipantList.Type.NAMES_AND_EXPRESSIONS;
            this.namesAndExpressions = NamesAndExpressionsImpl.create(model.getResourceList(), participantListSources);
        } else if (model.getLogicalPeopleGroup() != null) {
            this.type = ParticipantList.Type.LOGICAL_PEOPLE_GROUP;
            this.logicalPeopleGroup = LogicalPeopleGroupImpl.create(model.getLogicalPeopleGroup());
        } else if (model.getApprovalGroup() != null) {
            this.type = ParticipantList.Type.APPROVAL_GROUPS;
        } else if (model.getJobLevel() != null) {
            this.type = ParticipantList.Type.JOB_LEVEL;
        } else if (model.getPosition() != null) {
            this.type = ParticipantList.Type.POSITION;
        } else if (model.getSupervisory() != null) {
            this.type = ParticipantList.Type.SUPERVISORY;
        } else if (model.getManagementChain() != null) {
            this.type = ParticipantList.Type.MANAGEMENT_CHAIN;
        } else if (model.getRuleset() != null) {
            this.type = ParticipantList.Type.RULE_BASED;
        }
    }

    public static <T extends ParticipantList> T create(Class<T> clazz) {
        ParticipantListImpl participantList = new ParticipantListImpl(null, null);
        return participantList.as(clazz);
    }

    @Override
    public ParticipantList.Type getType() {
        return this.type;
    }

    @Override
    public <T extends ParticipantList> T as(Class<T> clazz) {
        switch (ParticipantListImpl.getTypeFor(clazz)) {
            case NAMES_AND_EXPRESSIONS: {
                this.toNamesAndExpressions();
                break;
            }
            case LOGICAL_PEOPLE_GROUP: {
                this.toLogicalPeopleGroup();
                break;
            }
        }
        return (T)this;
    }

    @Override
    public NamesAndExpressions getNamesAndExpressions() {
        return this.namesAndExpressions;
    }

    @Override
    public LogicalPeopleGroup getLogicalPeopleGroup() {
        return this.logicalPeopleGroup;
    }

    static ParticipantList create(@Nullable ListType listType, @Nullable ParticipantList.Sources participantListSource) {
        return new ParticipantListImpl(listType, participantListSource);
    }

    void setParticipantListSources(ParticipantList.Sources participantListSources) {
        this.participantListSources = participantListSources;
        if (this.namesAndExpressions != null) {
            this.namesAndExpressions.setParticipantListSources(participantListSources);
            if (this.getType().isNamesAndExpressions()) {
                this.namesAndExpressions.applyToModel();
            }
        }
    }

    private static <T extends ParticipantList> ParticipantList.Type getTypeFor(@NotNull Class<T> clazz) {
        return classToTypeMap.get(clazz);
    }

    private static void clearAllPossibleOptions(ListType model) {
        model.setResourceList(null);
        model.setApprovalGroup(null);
        model.setJobLevel(null);
        model.setPosition(null);
        model.setSupervisory(null);
        model.setManagementChain(null);
        model.setRuleset(null);
        model.setLogicalPeopleGroup(null);
    }

    private ParticipantList.NamesAndExpressions toNamesAndExpressions() {
        if (!this.getType().isNamesAndExpressions()) {
            this.type = ParticipantList.Type.NAMES_AND_EXPRESSIONS;
            ParticipantListImpl.clearAllPossibleOptions((ListType)this.getModel());
            if (this.namesAndExpressions == null) {
                this.namesAndExpressions = NamesAndExpressionsImpl.createValueBased(this.participantListSources);
            }
            if (this.namesAndExpressions.getBasedOnType().isRuleBased()) {
                ((ListType)this.getModel()).setResourceList((ResourceListType)this.namesAndExpressions.getModel());
            } else if (this.isConnectedToParticipant()) {
                this.namesAndExpressions.applyToModel();
            }
        }
        return this;
    }

    private ParticipantList.LogicalPeopleGroup toLogicalPeopleGroup() {
        if (!this.getType().isLogicalPeopleGroup()) {
            this.type = ParticipantList.Type.LOGICAL_PEOPLE_GROUP;
            ParticipantListImpl.clearAllPossibleOptions((ListType)this.getModel());
            if (this.logicalPeopleGroup == null) {
                this.logicalPeopleGroup = LogicalPeopleGroupImpl.create(RS_FACTORY.createLogicalPeopleGroupListType());
            }
            ((ListType)this.getModel()).setLogicalPeopleGroup((LogicalPeopleGroupListType)this.logicalPeopleGroup.getModel());
            if (this.isConnectedToParticipant()) {
                this.getParticipantListSources().getModelResourceList().clear();
                this.getParticipantListSources().setModelListType((ListType)this.getModel());
            }
        }
        return this;
    }

    private ParticipantList.Sources getParticipantListSources() {
        return this.participantListSources;
    }

    private boolean isConnectedToParticipant() {
        return this.getParticipantListSources() != null;
    }

    static {
        for (ParticipantList.Type type : ParticipantList.Type.values()) {
            classToTypeMap.put(type.getRawClass(), type);
        }
    }
}

