/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.Duration;
import oracle.bpel.services.workflow.metadata.routingslip.model.ListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlipType;
import oracle.bpm.soa.humantask.Factory;
import oracle.bpm.soa.humantask.Parameter;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.ParticipantList;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Resource;
import oracle.bpm.soa.humantask.Responder;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.impl.AbstractParticipant;
import oracle.bpm.soa.humantask.impl.ParameterImpl;
import oracle.bpm.soa.humantask.impl.ParticipantListImpl;
import oracle.bpm.soa.humantask.impl.ParticipantsImpl;
import oracle.bpm.soa.humantask.impl.ResourceImpl;
import oracle.bpm.soa.humantask.impl.ResponderImpl;
import oracle.bpm.soa.humantask.impl.RoutingSlipImpl;
import org.jetbrains.annotations.NotNull;

abstract class ParticipantImpl<E>
extends AbstractParticipant<E>
implements ParticipantList.Sources {
    private ParticipantList participantList;

    protected ParticipantImpl(Participants parent, E modelType, Participant.Type type) {
        super(parent, modelType, type);
    }

    public static Participant create(@NotNull Object participant) {
        Participant result = null;
        if (participant instanceof ParticipantsType.SequentialParticipant) {
            result = ParticipantImpl.createSerial((ParticipantsType.SequentialParticipant)participant);
        } else if (participant instanceof ParticipantsType.Adhoc) {
            result = ParticipantImpl.createAdhoc((ParticipantsType.Adhoc)participant);
        } else if (participant instanceof ParticipantsType.ManagementChain) {
            result = ParticipantImpl.createManagementChain((ParticipantsType.ManagementChain)participant);
        } else if (participant instanceof ParticipantsType.Parallel) {
            ParticipantsType.Parallel parallel = (ParticipantsType.Parallel)participant;
            result = ParticipantImpl.isParallelBlock(parallel) ? ParticipantImpl.createParallelBlock(parallel) : ParticipantImpl.createParallelSingle(parallel);
        } else if (participant instanceof ParticipantsType.Fyi) {
            result = ParticipantImpl.createFyi((ParticipantsType.Fyi)participant);
        } else if (participant instanceof ParticipantsType.Notify) {
            result = ParticipantImpl.createNotify((ParticipantsType.Notify)participant);
        } else if (participant instanceof ParticipantsType.Participant) {
            result = ParticipantImpl.createSingle((ParticipantsType.Participant)participant);
        } else if (participant instanceof ParticipantsType.Stage) {
            result = ParticipantsImpl.createStage((ParticipantsType.Stage)participant);
        } else if (participant instanceof ParticipantsType.ForEach) {
            result = ParticipantsImpl.createForEach((ParticipantsType.ForEach)participant);
        } else if (participant instanceof ParticipantsType) {
            result = ParticipantsImpl.create((ParticipantsType)participant);
        }
        return result;
    }

    public static Participant.Single createSingle(@NotNull ParticipantsType.Participant participant) {
        return new SingleImpl(null, participant);
    }

    public static Participant.Serial createSerial(@NotNull ParticipantsType.SequentialParticipant participant) {
        return new SerialImpl(null, participant);
    }

    public static Participant.Adhoc createAdhoc(@NotNull ParticipantsType.Adhoc participant) {
        return new AdhocImpl(null, participant);
    }

    public static Participant.ManagementChain createManagementChain(@NotNull ParticipantsType.ManagementChain participant) {
        return new ManagementChainImpl(null, participant);
    }

    public static Participant.ParallelSingle createParallelSingle(@NotNull ParticipantsType.Parallel participant) {
        return new ParallelSingleImpl(null, participant);
    }

    public static Participant.ParallelBlock createParallelBlock(@NotNull ParticipantsType.Parallel participant) {
        return new ParallelBlockImpl(null, participant);
    }

    public static Participant.Fyi createFyi(@NotNull ParticipantsType.Fyi participant) {
        return new FyiImpl(null, participant);
    }

    public static Participant.Notify createNotify(@NotNull ParticipantsType.Notify participant) {
        return new NotifyImpl(null, participant);
    }

    @Override
    public List<Resource> getResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List list = this.getModelResourceList();
        for (Object object : list) {
            result.add(ResourceImpl.create((ResourceType)object));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setResources(List<Resource> resources) {
        List list = this.getModelResourceList();
        list.clear();
        for (Resource resource : resources) {
            list.add(((ResourceImpl)resource).getModel());
        }
    }

    @Override
    public void addResource(Resource resource) {
        List list = this.getModelResourceList();
        list.add(((ResourceImpl)resource).getModel());
    }

    @Override
    public ParticipantList getParticipantList() {
        if (this.participantList == null) {
            this.participantList = ParticipantListImpl.create(this.getModelListType(), this);
        }
        return this.participantList;
    }

    @Override
    public void setParticipantList(@NotNull ParticipantList participantList) {
        boolean isNameAndExpressionsValueBased = false;
        if (participantList.getType().isNamesAndExpressions()) {
            ParticipantList.NamesAndExpressions nae = participantList.as(ParticipantList.NamesAndExpressions.class);
            isNameAndExpressionsValueBased = nae.getNamesAndExpressions().getBasedOnType().isValueBased();
        }
        if (!isNameAndExpressionsValueBased) {
            this.setModelListType((ListType)((ParticipantListImpl)participantList).getModel());
        }
        ((ParticipantListImpl)participantList).setParticipantListSources(this);
        this.participantList = participantList;
    }

    @Override
    public List getModelResourceList() {
        return new ArrayList();
    }

    @Override
    public ListType getModelListType() {
        return RS_FACTORY.createList();
    }

    @Override
    public void setModelListType(ListType listType) {
    }

    private static boolean isParallelSingle(ParticipantsType.Parallel parallel) {
        return !ParticipantImpl.isParallelBlock(parallel);
    }

    private static boolean isParallelBlock(ParticipantsType.Parallel parallel) {
        List list = parallel.getResourceOrRoutingSlip();
        for (Object o : list) {
            if (!(o instanceof oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlip)) continue;
            return true;
        }
        return false;
    }

    private static class SingleImpl
    extends ParticipantImpl<ParticipantsType.Participant>
    implements Participant.Single {
        private SingleImpl(Participants parent, ParticipantsType.Participant modelType) {
            super(parent, modelType, Participant.Type.SINGLE);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Participant)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Participant)this.getModel()).setName(value);
        }

        @Override
        public void setExpiration(Duration value) {
            ((ParticipantsType.Participant)this.getModel()).setExpirationDuration(value != null ? value.toString() : null);
        }

        @Override
        public Duration getExpiration() {
            String expiration = ((ParticipantsType.Participant)this.getModel()).getExpirationDuration();
            return expiration != null ? Factory.dataType().newDuration(expiration) : null;
        }

        @Override
        public List getModelResourceList() {
            return ((ParticipantsType.Participant)this.getModel()).getResource();
        }

        @Override
        public ListType getModelListType() {
            return ((ParticipantsType.Participant)this.getModel()).getList();
        }

        @Override
        public void setModelListType(ListType listType) {
            ((ParticipantsType.Participant)this.getModel()).setList(listType);
        }
    }

    private static class SerialImpl
    extends ParticipantImpl<ParticipantsType.SequentialParticipant>
    implements Participant.Serial {
        private SerialImpl(Participants parent, ParticipantsType.SequentialParticipant modelType) {
            super(parent, modelType, Participant.Type.SERIAL);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.SequentialParticipant)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.SequentialParticipant)this.getModel()).setName(value);
        }

        @Override
        public void setExpiration(Duration value) {
            ((ParticipantsType.SequentialParticipant)this.getModel()).setExpirationDuration(value != null ? value.toString() : null);
        }

        @Override
        public Duration getExpiration() {
            String expiration = ((ParticipantsType.SequentialParticipant)this.getModel()).getExpirationDuration();
            return expiration != null ? Factory.dataType().newDuration(expiration) : null;
        }

        @Override
        public List getModelResourceList() {
            return ((ParticipantsType.SequentialParticipant)this.getModel()).getResource();
        }

        @Override
        public ListType getModelListType() {
            return ((ParticipantsType.SequentialParticipant)this.getModel()).getList();
        }

        @Override
        public void setModelListType(ListType listType) {
            ((ParticipantsType.SequentialParticipant)this.getModel()).setList(listType);
        }
    }

    private static class ParallelSingleImpl
    extends ParallelImpl
    implements Participant.ParallelSingle {
        private ParallelSingleImpl(Participants parent, ParticipantsType.Parallel modelType) {
            super(parent, modelType, Participant.Type.PARALLEL_SINGLE);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Parallel)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Parallel)this.getModel()).setName(value);
        }

        @Override
        public void setExpiration(Duration value) {
            ((ParticipantsType.Parallel)this.getModel()).setExpirationDuration(value != null ? value.toString() : null);
        }

        @Override
        public Duration getExpiration() {
            String expiration = ((ParticipantsType.Parallel)this.getModel()).getExpirationDuration();
            return expiration != null ? Factory.dataType().newDuration(expiration) : null;
        }

        @Override
        public List getModelResourceList() {
            return ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
        }

        @Override
        public ListType getModelListType() {
            return this.isParticipantListBasedOnListType() ? (ListType)((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip().iterator().next() : null;
        }

        @Override
        public void setModelListType(ListType listType) {
            if (listType != null) {
                List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
                list.clear();
                list.add(listType);
            }
        }

        private boolean isParticipantListBasedOnListType() {
            List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
            for (Object o : list) {
                if (!(o instanceof ListType)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ParallelBlockImpl
    extends ParallelImpl
    implements Participant.ParallelBlock {
        private List<RoutingSlip> routingSlips;

        private ParallelBlockImpl(Participants parent, ParticipantsType.Parallel modelType) {
            super(parent, modelType, Participant.Type.PARALLEL_BLOCK);
        }

        @Override
        public List<RoutingSlip> getRoutingSlips() {
            if (this.routingSlips == null) {
                this.routingSlips = new ArrayList<RoutingSlip>();
                List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
                for (Object rs : list) {
                    RoutingSlipImpl routingSlipImpl = RoutingSlipImpl.create((RoutingSlipType)rs);
                    this.routingSlips.add(routingSlipImpl);
                    routingSlipImpl.setParent(this);
                }
            }
            return this.routingSlips;
        }

        @Override
        public void setRoutingSlips(List<RoutingSlip> routingSlips) {
            List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
            list.clear();
            for (RoutingSlip routingSlip : routingSlips) {
                list.add(((ResourceImpl)((Object)routingSlip)).getModel());
            }
            this.routingSlips = routingSlips;
        }

        @Override
        public void addRoutingSlip(RoutingSlip routingSlip) {
            this.getRoutingSlips().add(routingSlip);
            List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
            RoutingSlipImpl routingSlipImpl = (RoutingSlipImpl)routingSlip;
            list.add(routingSlipImpl.getModel());
            routingSlipImpl.setParent(this);
        }

        @Override
        public void removeRoutingSlip(RoutingSlip routingSlip) {
            this.getRoutingSlips().remove(routingSlip);
            List list = ((ParticipantsType.Parallel)this.getModel()).getResourceOrRoutingSlip();
            RoutingSlipImpl routingSlipImpl = (RoutingSlipImpl)routingSlip;
            list.remove(routingSlipImpl.getModel());
        }
    }

    private static class NotifyImpl
    extends ParticipantImpl<ParticipantsType.Notify>
    implements Participant.Notify {
        private NotifyImpl(Participants parent, ParticipantsType.Notify modelType) {
            super(parent, modelType, Participant.Type.NOTIFY);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Notify)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Notify)this.getModel()).setName(value);
        }
    }

    private static class ManagementChainImpl
    extends ParticipantImpl<ParticipantsType.ManagementChain>
    implements Participant.ManagementChain {
        private ManagementChainImpl(Participants parent, ParticipantsType.ManagementChain modelType) {
            super(parent, modelType, Participant.Type.MANAGEMENT_CHAIN);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.ManagementChain)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.ManagementChain)this.getModel()).setName(value);
        }

        @Override
        public void setTitle(Parameter title) {
            ((ParticipantsType.ManagementChain)this.getModel()).setTitle((ParameterType)((ParameterImpl)title).getModel());
        }

        @Override
        public void setLevels(Parameter levels) {
            ((ParticipantsType.ManagementChain)this.getModel()).setLevels((ParameterType)((ParameterImpl)levels).getModel());
        }

        @Override
        public Parameter getTitle() {
            return ParameterImpl.create(((ParticipantsType.ManagementChain)this.getModel()).getTitle());
        }

        @Override
        public Parameter getLevels() {
            return ParameterImpl.create(((ParticipantsType.ManagementChain)this.getModel()).getLevels());
        }

        @Override
        public List getModelResourceList() {
            return ((ParticipantsType.ManagementChain)this.getModel()).getResource();
        }
    }

    private static class FyiImpl
    extends ParticipantImpl<ParticipantsType.Fyi>
    implements Participant.Fyi {
        private FyiImpl(Participants parent, ParticipantsType.Fyi modelType) {
            super(parent, modelType, Participant.Type.FYI);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Fyi)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Fyi)this.getModel()).setName(value);
        }

        @Override
        public List getModelResourceList() {
            return ((ParticipantsType.Fyi)this.getModel()).getResource();
        }

        @Override
        public ListType getModelListType() {
            return ((ParticipantsType.Fyi)this.getModel()).getList();
        }

        @Override
        public void setModelListType(ListType listType) {
            ((ParticipantsType.Fyi)this.getModel()).setList(listType);
        }
    }

    private static class AdhocImpl
    extends ParticipantImpl<ParticipantsType.Adhoc>
    implements Participant.Adhoc {
        private AdhocImpl(Participants parent, ParticipantsType.Adhoc modelType) {
            super(parent, modelType, Participant.Type.ADHOC);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Adhoc)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Adhoc)this.getModel()).setName(value);
        }
    }

    private static abstract class ParallelImpl
    extends ParticipantImpl<ParticipantsType.Parallel>
    implements Participant.Parallel {
        private Responder responder = ResponderImpl.create((ParticipantsType.Parallel)this.getModel());

        private ParallelImpl(Participants parent, ParticipantsType.Parallel modelType, Participant.Type type) {
            super(parent, modelType, type);
        }

        @Override
        public String getName() {
            return ((ParticipantsType.Parallel)this.getModel()).getName();
        }

        @Override
        public void setName(String value) {
            ((ParticipantsType.Parallel)this.getModel()).setName(value);
        }

        @Override
        public Responder getResponder() {
            return this.responder;
        }

        @Override
        public boolean isCollaboration() {
            return ((ParticipantsType.Parallel)this.getModel()).isCollaboration();
        }

        @Override
        public void setCollaboration(boolean value) {
            ((ParticipantsType.Parallel)this.getModel()).setCollaboration(value);
        }
    }
}

