/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpel.services.workflow.metadata.routingslip.model.OutcomePercentageType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParallelCompletionCriteriaType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpm.soa.humantask.OutcomePercentage;
import oracle.bpm.soa.humantask.ParallelResponder;
import oracle.bpm.soa.humantask.Parameter;
import oracle.bpm.soa.humantask.ValueType;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.OutcomePercentageImpl;
import oracle.bpm.soa.humantask.impl.ParameterImpl;
import org.jetbrains.annotations.NotNull;

class ParallelResponderImpl
extends AbstractEntity<ParallelCompletionCriteriaType>
implements ParallelResponder {
    private Parameter defaultOutcome = this.getDefaultOutcome();
    private static final String DEFAULT_OUTCOME = "";

    protected ParallelResponderImpl(ParallelCompletionCriteriaType model) {
        super(model);
    }

    @Override
    public Parameter getDefaultOutcome() {
        if (this.defaultOutcome == null) {
            ParameterType parameterType = ((ParallelCompletionCriteriaType)this.getModel()).getDefaultOutcome();
            if (parameterType == null) {
                parameterType = ParallelResponderImpl.createDefaultOutcome();
                ((ParallelCompletionCriteriaType)this.getModel()).setDefaultOutcome(parameterType);
            }
            this.defaultOutcome = ParameterImpl.create(parameterType);
        }
        return this.defaultOutcome;
    }

    @Override
    public void setDefaultOutcome(Parameter value) {
        ((ParallelCompletionCriteriaType)this.getModel()).setDefaultOutcome((ParameterType)((ParameterImpl)value).getModel());
    }

    @Override
    public List<OutcomePercentage> getOutcomePercentage() {
        ArrayList<OutcomePercentage> result = new ArrayList<OutcomePercentage>();
        List list = ((ParallelCompletionCriteriaType)this.getModel()).getOutcomePercentage();
        for (Object object : list) {
            OutcomePercentage outcomePercentage = OutcomePercentageImpl.create((OutcomePercentageType)object);
            result.add(outcomePercentage);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setOutcomePercentage(List<OutcomePercentage> percentages) {
        List list = ((ParallelCompletionCriteriaType)this.getModel()).getOutcomePercentage();
        list.clear();
        for (OutcomePercentage outcomePercentage : percentages) {
            list.add(((OutcomePercentageImpl)outcomePercentage).getModel());
        }
    }

    @Override
    public void addOutcomePercentage(OutcomePercentage outcomePercentage) {
        List list = ((ParallelCompletionCriteriaType)this.getModel()).getOutcomePercentage();
        list.add(((OutcomePercentageImpl)outcomePercentage).getModel());
    }

    @Override
    public void removeOutcomePercentage(OutcomePercentage outcomePercentage) {
        List list = ((ParallelCompletionCriteriaType)this.getModel()).getOutcomePercentage();
        list.remove(((OutcomePercentageImpl)outcomePercentage).getModel());
    }

    static ParallelResponder createAllResponders(@NotNull ParticipantsType.Parallel parallel) {
        ParallelCompletionCriteriaType completionCriteria = parallel.getAllResponders();
        parallel.setFirstResponder(null);
        parallel.setVote(null);
        if (completionCriteria == null) {
            completionCriteria = parallel.getVote();
            if (completionCriteria == null) {
                completionCriteria = ParallelResponderImpl.createParallelCompletionCriteriaType();
            }
            parallel.setAllResponders(completionCriteria);
        }
        return new ParallelResponderImpl(completionCriteria);
    }

    static ParallelResponder createVote(@NotNull ParticipantsType.Parallel parallel) {
        parallel.setFirstResponder(null);
        parallel.setAllResponders(null);
        ParallelCompletionCriteriaType completionCriteria = parallel.getVote();
        if (completionCriteria == null) {
            completionCriteria = parallel.getAllResponders();
            if (completionCriteria == null) {
                completionCriteria = ParallelResponderImpl.createParallelCompletionCriteriaType();
            }
            parallel.setVote(completionCriteria);
        }
        return new ParallelResponderImpl(completionCriteria);
    }

    private static ParallelCompletionCriteriaType createParallelCompletionCriteriaType() {
        ParallelCompletionCriteriaType completionCriteria = RS_FACTORY.createParallelCompletionCriteriaType();
        OutcomePercentageType outcomePercentage = RS_FACTORY.createOutcomePercentageType();
        outcomePercentage.setValue("50");
        outcomePercentage.setType(ValueType.STATIC.asString());
        outcomePercentage.setOutcome(DEFAULT_OUTCOME);
        completionCriteria.setDefaultOutcome(ParallelResponderImpl.createDefaultOutcome());
        completionCriteria.getOutcomePercentage().add(outcomePercentage);
        return completionCriteria;
    }

    private static ParameterType createDefaultOutcome() {
        ParameterType parameterType = RS_FACTORY.createParameterType();
        parameterType.setValue(DEFAULT_OUTCOME);
        parameterType.setType(ValueType.STATIC.asString());
        return parameterType;
    }
}

