/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RulesetType;
import oracle.bpm.soa.humantask.NamesAndExpressions;
import oracle.bpm.soa.humantask.ParticipantList;
import oracle.bpm.soa.humantask.Resource;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.ResourceImpl;
import org.jetbrains.annotations.Nullable;

class NamesAndExpressionsImpl
extends AbstractEntity<ResourceListType>
implements NamesAndExpressions.ValueBased,
NamesAndExpressions.RuleBased {
    private ParticipantList.BasedOnType basedOnType;
    private ParticipantList.Sources participantListSources;
    private List resourceList;
    private RulesetType rulesetType;

    private NamesAndExpressionsImpl(ResourceListType model, ParticipantList.BasedOnType basedOnType, @Nullable ParticipantList.Sources participantListSources) {
        super(model);
        this.participantListSources = participantListSources;
        List list = participantListSources != null ? participantListSources.getModelResourceList() : null;
        this.resourceList = list != null ? list : new ArrayList();
        this.basedOnType = basedOnType;
        if (basedOnType.isRuleBased()) {
            this.rulesetType = model.getRuleset();
        }
    }

    @Override
    public ParticipantList.BasedOnType getBasedOnType() {
        return this.basedOnType;
    }

    @Override
    public NamesAndExpressions.ValueBased toValueBased() {
        if (!this.getBasedOnType().isValueBased()) {
            this.basedOnType = ParticipantList.BasedOnType.VALUE_BASED;
            ((ResourceListType)this.getModel()).setRuleset(null);
            if (this.isConnectedToParticipant()) {
                this.getParticipantListSources().setModelListType(null);
            }
        }
        return this;
    }

    @Override
    public NamesAndExpressions.RuleBased toRuleBased() {
        if (!this.getBasedOnType().isRuleBased()) {
            this.basedOnType = ParticipantList.BasedOnType.RULE_BASED;
            ((ResourceListType)this.getModel()).setRuleset(this.getRulesetType());
            if (this.isConnectedToParticipant()) {
                this.getParticipantListSources().getModelResourceList().clear();
            }
        }
        return this;
    }

    @Override
    public List<Resource> getResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List list = this.getResourceList();
        for (Object object : list) {
            Resource resource = ResourceImpl.create((ResourceType)object);
            result.add(resource);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setResources(List<Resource> resources) {
        List list = this.getResourceList();
        list.clear();
        for (Resource resource : resources) {
            list.add(((ResourceImpl)resource).getModel());
        }
    }

    @Override
    public void addResource(Resource resource) {
        List list = this.getResourceList();
        list.add(((ResourceImpl)resource).getModel());
    }

    public RulesetType getRulesetType() {
        if (this.rulesetType == null) {
            this.rulesetType = RS_FACTORY.createRulesetType();
        }
        return this.rulesetType;
    }

    static NamesAndExpressionsImpl create(ResourceListType resourceListType, @Nullable ParticipantList.Sources participantListSources) {
        ParticipantList.BasedOnType basedOnType = resourceListType.getRuleset() != null ? ParticipantList.BasedOnType.RULE_BASED : ParticipantList.BasedOnType.VALUE_BASED;
        return new NamesAndExpressionsImpl(resourceListType, basedOnType, participantListSources);
    }

    static NamesAndExpressionsImpl createValueBased(@Nullable ParticipantList.Sources participantListSources) {
        ResourceListType resourceListType = RS_FACTORY.createResourceListType();
        return new NamesAndExpressionsImpl(resourceListType, ParticipantList.BasedOnType.VALUE_BASED, participantListSources);
    }

    void setResourceList(List list) {
        this.resourceList = list;
    }

    void setParticipantListSources(ParticipantList.Sources participantListSources) {
        this.participantListSources = participantListSources;
    }

    void applyToModel() {
        if (this.isConnectedToParticipant() && this.getBasedOnType().isValueBased()) {
            List resourceList;
            List list = this.getParticipantListSources().getModelResourceList();
            if (list != (resourceList = this.getResourceList())) {
                list.clear();
                list.addAll(resourceList);
                this.setResourceList(list);
            }
            this.getParticipantListSources().setModelListType(null);
        }
    }

    private static ResourceListType createDefaultResourceListType() {
        return RS_FACTORY.createResourceListType();
    }

    private List getResourceList() {
        return this.resourceList;
    }

    private ParticipantList.Sources getParticipantListSources() {
        return this.participantListSources;
    }

    private boolean isConnectedToParticipant() {
        return this.getParticipantListSources() != null;
    }
}

