/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.ObjectFactory;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.Tuple3;
import oracle.bpm.soa.humantask.Factory;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskException;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.RoutingSlipFactory;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import oracle.bpm.soa.humantask.impl.RoutingSlipImpl;
import oracle.bpm.soa.humantask.impl.TaskConstants;
import oracle.bpm.soa.humantask.impl.TitleImpl;
import oracle.bpm.soa.humantask.impl.WorkflowConfigurationImpl;
import oracle.bpm.soa.humantask.impl.WorkflowImpl;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.Nullable;

public class HumanTaskImpl
extends AbstractEntity<TaskDefinition>
implements HumanTask,
TaskConstants {
    private XMLDocument payloadDocument;
    private RoutingSlipImpl routingSlip;
    private TitleImpl title;
    private WorkflowImpl workflow;
    private WorkflowConfigurationImpl workflowConfiguration;

    private HumanTaskImpl(TaskDefinition taskDef, @Nullable XMLDocument payloadDocument) {
        super(taskDef);
        this.payloadDocument = payloadDocument;
    }

    public static HumanTask create(String name) throws HumanTaskException {
        ObjectFactory objFactory = new ObjectFactory();
        TaskDefinition taskDef = objFactory.createTaskDefinition();
        taskDef.setName(name);
        HumanTaskImpl humanTask = new HumanTaskImpl(taskDef, null);
        for (Tuple tuple : DEFAULT_NAMESPACES) {
            humanTask.addNamespaceDeclaration((String)tuple.getFirst(), (String)tuple.getSecond());
        }
        humanTask.setId("");
        humanTask.setPriority(3);
        TitleImpl title = humanTask.getTitle();
        title.setType(DEFAULT_TITLE_TYPE);
        title.setValue("");
        WorkflowConfigurationImpl workflowConfiguration = humanTask.getWorkflowConfiguration();
        WorkflowConfiguration.Outcomes outcomes = workflowConfiguration.getOutcomes();
        outcomes.setValues((Sequence<String>)OUTCOMES_DEFAULT_VALUES);
        workflowConfiguration.setEnableAutoClaim(true);
        workflowConfiguration.setShowCompleteGraphicalHistory(true);
        Payload payload = workflowConfiguration.getPayload();
        payload.setXmlSchemaDefinition("xsd/" + taskDef.getName() + "Payload.xsd");
        RoutingSlipImpl routingSlip = humanTask.getRoutingSlip();
        RoutingSlipFactory routingSlipFactory = Factory.task().routingSlip();
        Participants participants = routingSlipFactory.createParticipants();
        Participants.Stage stage = routingSlipFactory.createStage("Stage1");
        participants.add(stage);
        routingSlip.setParticipants(participants);
        RoutingSlip.Notification notification = routingSlip.getNotification();
        notification.setActionable(false);
        ArrayList<RoutingSlip.Action> actions = new ArrayList<RoutingSlip.Action>();
        for (Tuple3 t3 : DEFAULT_NOTIFICATION_ACTIONS) {
            RoutingSlip.Action action = routingSlipFactory.createAction();
            action.setName((String)t3.getFirst());
            action.setRecipient((String)t3.getSecond());
            action.setValue((String)t3.getThird());
            actions.add(action);
        }
        notification.setActions(actions);
        return humanTask;
    }

    public static HumanTask load(TaskDefinition taskDef, XMLDocument document) throws HumanTaskException {
        return new HumanTaskImpl(taskDef, document);
    }

    @Override
    public void addNamespaceDeclaration(String prefix, String uri) throws HumanTaskException {
        try {
            JaxbUtil.setNamespaceDeclaration((JaxbNode)((JaxbNode)this.getModel()), (String)prefix, (String)uri);
        }
        catch (JAXBException e) {
            throw HumanTaskException.create(HumantaskMsg.INVALID_NAMESPACE_DECLARATION(uri), e);
        }
    }

    @Override
    public String getTargetNamespace() {
        return ((TaskDefinition)this.getModel()).getTargetNamespace();
    }

    @Override
    public void setTargetNamespace(String namespace) {
        ((TaskDefinition)this.getModel()).setTargetNamespace(namespace);
    }

    @Override
    public void setId(String id) {
        ((TaskDefinition)this.getModel()).setId(id);
    }

    @Override
    public String getName() {
        return ((TaskDefinition)this.getModel()).getName();
    }

    @Override
    public TitleImpl getTitle() {
        if (this.title == null) {
            this.title = TitleImpl.create((TaskDefinition)this.getModel());
        }
        return this.title;
    }

    @Override
    public int getPriority() {
        BigInteger priority = ((TaskDefinition)this.getModel()).getPriority();
        return priority != null ? priority.intValue() : 3;
    }

    @Override
    public void setPriority(int priority) {
        ((TaskDefinition)this.getModel()).setPriority(BigInteger.valueOf(priority));
    }

    @Override
    public String getDescription() {
        return ((TaskDefinition)this.getModel()).getDescription();
    }

    @Override
    public void setDescription(String description) {
        ((TaskDefinition)this.getModel()).setDescription(description);
    }

    @Override
    public WorkflowConfigurationImpl getWorkflowConfiguration() {
        if (this.workflowConfiguration == null) {
            this.workflowConfiguration = WorkflowConfigurationImpl.create((TaskDefinition)this.getModel(), this.getPayloadDocument());
        }
        return this.workflowConfiguration;
    }

    public WorkflowImpl getWorkflow() {
        if (this.workflow == null) {
            this.workflow = WorkflowImpl.create(this.getTaskName());
        }
        return this.workflow;
    }

    @Override
    public RoutingSlipImpl getRoutingSlip() {
        if (this.routingSlip == null) {
            this.routingSlip = RoutingSlipImpl.create((TaskDefinition)this.getModel());
        }
        return this.routingSlip;
    }

    private String getTaskName() {
        return ((TaskDefinition)this.getModel()).getName();
    }

    private XMLDocument getPayloadDocument() {
        return this.payloadDocument;
    }
}

