/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask.impl;

import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.workflow.metadata.routingslip.model.EscalationPolicyType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ExpirationDurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.GlobalConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RenewalPolicyType;
import oracle.bpm.soa.humantask.Expiration;
import oracle.bpm.soa.humantask.ValueType;
import oracle.bpm.soa.humantask.impl.AbstractEntity;
import org.jetbrains.annotations.NotNull;

class ExpirationImpl
extends AbstractEntity<GlobalConfigurationType>
implements Expiration.NeverExpire,
Expiration.ExpireAfter,
Expiration.RenewAfter,
Expiration.EscalateAfter {
    private EscalationPolicyType escalationPolicyType;
    private ExpirationDurationType expirationDurationType;
    private RenewalPolicyType renewalPolicyType;
    private Expiration.Type type;
    private static Map<Class<? extends Expiration>, Expiration.Type> classToTypeMap = new HashMap<Class<? extends Expiration>, Expiration.Type>();

    private ExpirationImpl(GlobalConfigurationType model) {
        super(model);
        Class<? extends Expiration> clazz = Expiration.Type.NEVER_EXPIRE.getRawClass();
        this.expirationDurationType = model.getExpirationDuration();
        if (this.expirationDurationType != null) {
            this.renewalPolicyType = model.getRenewalPolicy();
            if (this.renewalPolicyType != null) {
                clazz = Expiration.Type.RENEW_AFTER.getRawClass();
            } else {
                this.escalationPolicyType = model.getEscalationPolicy();
                clazz = this.escalationPolicyType != null ? Expiration.Type.ESCALATE_AFTER.getRawClass() : Expiration.Type.EXPIRE_AFTER.getRawClass();
            }
        }
        this.as(clazz);
    }

    public static ExpirationImpl create(@NotNull GlobalConfigurationType gct) {
        return new ExpirationImpl(gct);
    }

    @Override
    public Expiration.Type getType() {
        return this.type;
    }

    @Override
    public <T extends Expiration> T as(Class<T> clazz) {
        switch (ExpirationImpl.getTypeFor(clazz)) {
            case NEVER_EXPIRE: {
                this.toNeverExpire();
                break;
            }
            case EXPIRE_AFTER: {
                this.toExpireAfter();
                break;
            }
            case RENEW_AFTER: {
                this.toRenewAfter();
                break;
            }
            case ESCALATE_AFTER: {
                this.toEscalateAfter();
            }
        }
        return (T)this;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.create(this.getExpirationDurationType().getType());
    }

    @Override
    public void setValueType(ValueType value) {
        this.getExpirationDurationType().setType(value.asString());
    }

    @Override
    public String getDuration() {
        return this.getExpirationDurationType().getDuration();
    }

    @Override
    public void setDuration(String value) {
        this.getExpirationDurationType().setDuration(value);
    }

    @Override
    public boolean isUseBusinessCalendar() {
        return this.getExpirationDurationType().isUseBusinessCalendar();
    }

    @Override
    public void setUseBusinessCalendar(boolean value) {
        this.getExpirationDurationType().setUseBusinessCalendar(value);
    }

    @Override
    public int getNumberOfTimesRenewed() {
        ParameterType parameterType = this.getRenewalPolicyType().getNumberOfTimesRenewed();
        return parameterType != null ? Integer.valueOf(parameterType.getValue()) : 0;
    }

    @Override
    public void setNumberOfTimesRenewed(int value) {
        ParameterType parameterType = this.getRenewalPolicyType().getNumberOfTimesRenewed();
        if (parameterType == null) {
            parameterType = RS_FACTORY.createParameterType();
            parameterType.setValue(ValueType.STATIC.asString());
            this.getRenewalPolicyType().setNumberOfTimesRenewed(parameterType);
        }
        parameterType.setValue(String.valueOf(value));
    }

    @Override
    public int getNumberOfTimesEscalated() {
        ParameterType parameterType = this.getEscalationPolicyType().getNumberOfTimesEscalated();
        return parameterType != null ? Integer.valueOf(parameterType.getValue()) : 0;
    }

    @Override
    public void setNumberOfTimesEscalated(int value) {
        ParameterType parameterType = this.getEscalationPolicyType().getNumberOfTimesEscalated();
        if (parameterType == null) {
            parameterType = RS_FACTORY.createParameterType();
            parameterType.setValue(ValueType.STATIC.asString());
            this.getEscalationPolicyType().setNumberOfTimesEscalated(parameterType);
        }
        parameterType.setValue(String.valueOf(value));
    }

    @Override
    public String getTitleOfLastUser() {
        ParameterType parameterType = this.getEscalationPolicyType().getTitleOfLastUser();
        return parameterType != null ? parameterType.getValue() : "";
    }

    @Override
    public void setTitleOfLastUser(String value) {
        ParameterType parameterType = this.getEscalationPolicyType().getTitleOfLastUser();
        if (parameterType == null) {
            parameterType = RS_FACTORY.createParameterType();
            parameterType.setValue(ValueType.STATIC.asString());
            this.getEscalationPolicyType().setTitleOfLastUser(parameterType);
        }
        parameterType.setValue(value);
    }

    private static <T extends Expiration> Expiration.Type getTypeFor(@NotNull Class<T> clazz) {
        return classToTypeMap.get(clazz);
    }

    private Expiration.NeverExpire toNeverExpire() {
        if (!Expiration.Type.NEVER_EXPIRE.equals((Object)this.type)) {
            this.type = Expiration.Type.NEVER_EXPIRE;
            ((GlobalConfigurationType)this.getModel()).setExpirationDuration(null);
            ((GlobalConfigurationType)this.getModel()).setEscalationPolicy(null);
            ((GlobalConfigurationType)this.getModel()).setRenewalPolicy(null);
        }
        return this;
    }

    private Expiration.ExpireAfter toExpireAfter() {
        if (!Expiration.Type.EXPIRE_AFTER.equals((Object)this.type)) {
            this.type = Expiration.Type.EXPIRE_AFTER;
            ((GlobalConfigurationType)this.getModel()).setEscalationPolicy(null);
            ((GlobalConfigurationType)this.getModel()).setRenewalPolicy(null);
            ((GlobalConfigurationType)this.getModel()).setExpirationDuration(this.getExpirationDurationType());
        }
        return this;
    }

    private Expiration.RenewAfter toRenewAfter() {
        if (!Expiration.Type.RENEW_AFTER.equals((Object)this.type)) {
            this.type = Expiration.Type.RENEW_AFTER;
            ((GlobalConfigurationType)this.getModel()).setEscalationPolicy(null);
            ((GlobalConfigurationType)this.getModel()).setExpirationDuration(this.getExpirationDurationType());
            ((GlobalConfigurationType)this.getModel()).setRenewalPolicy(this.getRenewalPolicyType());
        }
        return this;
    }

    private Expiration.EscalateAfter toEscalateAfter() {
        if (!Expiration.Type.ESCALATE_AFTER.equals((Object)this.type)) {
            this.type = Expiration.Type.ESCALATE_AFTER;
            ((GlobalConfigurationType)this.getModel()).setRenewalPolicy(null);
            ((GlobalConfigurationType)this.getModel()).setExpirationDuration(this.getExpirationDurationType());
            ((GlobalConfigurationType)this.getModel()).setEscalationPolicy(this.getEscalationPolicyType());
        }
        return this;
    }

    private ExpirationDurationType getExpirationDurationType() {
        if (this.expirationDurationType == null) {
            this.expirationDurationType = RS_FACTORY.createExpirationDurationType();
            this.expirationDurationType.setType(ValueType.STATIC.toString());
        }
        return this.expirationDurationType;
    }

    private EscalationPolicyType getEscalationPolicyType() {
        if (this.escalationPolicyType == null) {
            this.escalationPolicyType = RS_FACTORY.createEscalationPolicyType();
        }
        return this.escalationPolicyType;
    }

    private RenewalPolicyType getRenewalPolicyType() {
        if (this.renewalPolicyType == null) {
            this.renewalPolicyType = RS_FACTORY.createRenewalPolicyType();
        }
        return this.renewalPolicyType;
    }

    static {
        for (Expiration.Type type : Expiration.Type.values()) {
            classToTypeMap.put(type.getRawClass(), type);
        }
    }
}

