/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.soa.humantask;

import java.util.List;
import javax.xml.datatype.Duration;
import oracle.bpm.soa.humantask.Parameter;
import oracle.bpm.soa.humantask.ParticipantList;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Resource;
import oracle.bpm.soa.humantask.Responder;
import oracle.bpm.soa.humantask.RoutingSlip;
import org.jetbrains.annotations.NotNull;

public interface Participant {
    public String getId();

    public void setId(String var1);

    public Participants getParent();

    public void setParent(Participants var1);

    public Type getType();

    public String getName();

    public void setName(String var1);

    public ParticipantList getParticipantList();

    public void setParticipantList(@NotNull ParticipantList var1);

    public Duration getExpiration();

    public void setExpiration(Duration var1);

    public List<Resource> getResources();

    public void setResources(List<Resource> var1);

    public void addResource(Resource var1);

    public static interface Single
    extends Participant {
    }

    public static interface Serial
    extends Participant {
    }

    public static interface ParallelSingle
    extends Parallel {
    }

    public static interface ParallelBlock
    extends Parallel {
        public List<RoutingSlip> getRoutingSlips();

        public void setRoutingSlips(List<RoutingSlip> var1);

        public void addRoutingSlip(RoutingSlip var1);

        public void removeRoutingSlip(RoutingSlip var1);
    }

    public static interface Parallel
    extends Participant {
        public Responder getResponder();

        public boolean isCollaboration();

        public void setCollaboration(boolean var1);
    }

    public static interface Notify
    extends Participant {
    }

    public static interface ManagementChain
    extends Participant {
        public Parameter getTitle();

        public Parameter getLevels();

        public void setTitle(Parameter var1);

        public void setLevels(Parameter var1);
    }

    public static interface Fyi
    extends Participant {
    }

    public static interface Adhoc
    extends Participant {
    }

    public static enum Type {
        PARTICIPANTS(true),
        STAGE(true),
        FOREACH(true),
        SINGLE(false),
        PARALLEL_SINGLE(false),
        PARALLEL_BLOCK(false),
        SERIAL(false),
        FYI(false),
        ADHOC(false),
        MANAGEMENT_CHAIN(false),
        NOTIFY(false);

        private boolean isContainer;

        private Type(boolean value) {
            this.isContainer = value;
        }

        public boolean isSingle() {
            return this.equals((Object)SINGLE);
        }

        public boolean isSerial() {
            return this.equals((Object)SERIAL);
        }

        public boolean isAdhoc() {
            return this.equals((Object)ADHOC);
        }

        public boolean isManagementChain() {
            return this.equals((Object)MANAGEMENT_CHAIN);
        }

        public boolean isParallel() {
            return this.equals((Object)PARALLEL_SINGLE) || this.equals((Object)PARALLEL_BLOCK);
        }

        public boolean isParallelSingle() {
            return this.equals((Object)PARALLEL_SINGLE);
        }

        public boolean isParallelBlock() {
            return this.equals((Object)PARALLEL_BLOCK);
        }

        public boolean isFyi() {
            return this.equals((Object)FYI);
        }

        public boolean isNotify() {
            return this.equals((Object)NOTIFY);
        }

        public boolean isStage() {
            return this.equals((Object)STAGE);
        }

        public boolean isForeach() {
            return this.equals((Object)FOREACH);
        }

        public boolean isContainer() {
            return this.isContainer;
        }
    }
}

