/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.Controller;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.impl.WebRedirector;
import oracle.bpm.web.execution.impl.WebUtils;
import oracle.bpm.web.execution.servlet.ServletExecutionManager;
import oracle.bpm.web.execution.servlet.ServletExternalContext;

public class ServletRedirector
implements WebRedirector {
    private Map<String, Dispatcher> dispatcher;
    private ServletExecutionManager executionManager;

    public ServletRedirector(ServletExecutionManager executionManager) {
        this.executionManager = executionManager;
        this.dispatcher = new HashMap<String, Dispatcher>();
    }

    @Override
    public void redirect(String target, ExternalContext context) throws ServletException {
        ServletExternalContext servletcontext = (ServletExternalContext)context;
        HttpServletRequest request = servletcontext.getHttpRequest();
        HttpServletResponse response = servletcontext.getHttpResponse();
        Dispatcher dispatcher = this.findRedirector(target);
        dispatcher.forward(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dispatcher findRedirector(String target) throws ServletException {
        Dispatcher redirector;
        Map<String, Dispatcher> map = this.dispatcher;
        synchronized (map) {
            redirector = this.dispatcher.get(target);
            if (redirector == null) {
                if (target.endsWith(".jsp") || target.endsWith(".jspx")) {
                    redirector = new JSPDispatcher(target);
                } else {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Class<?> targetClass = Class.forName(target, false, cl);
                        Object object = targetClass.newInstance();
                        if (object instanceof Controller) {
                            redirector = new ControllerRedirector(target, (Controller)object);
                        } else if (object instanceof Servlet) {
                            redirector = new ServletDispatcher(target, (Servlet)object);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ServletException(target + " not found", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new ServletException(target + " is abstract or an interface", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ServletException("Default constructor of " + target + " is not public", (Throwable)e);
                    }
                }
                this.dispatcher.put(target, redirector);
            }
        }
        if (Log.isDebugging()) {
            Log.logDebug("Execution Redirector Class:" + (redirector == null ? null : redirector.getClass()));
        }
        return redirector;
    }

    private class ControllerRedirector
    extends Dispatcher {
        private Controller controller;

        public ControllerRedirector(String target, Controller controller) {
            super(target);
            this.controller = controller;
        }

        @Override
        public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            ExternalContext externalContext = WebUtils.createExternalContext(request, response);
            ComponentContext componentContext = WebUtils.findComponentContext(externalContext);
            componentContext.beforeService();
            try {
                this.controller.service(componentContext, ServletRedirector.this.executionManager.createExternalContext(request, response));
            }
            catch (Exception e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                throw new ServletException("exception occurred running controller: " + this.target, (Throwable)e);
            }
        }
    }

    private static class ServletDispatcher
    extends Dispatcher {
        private Servlet servlet;

        public ServletDispatcher(String target, Servlet servlet) {
            super(target);
            this.servlet = servlet;
        }

        @Override
        public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            try {
                this.servlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e) {
                throw new ServletException("I/O exception occurred running servlet: " + this.target, (Throwable)e);
            }
        }
    }

    private static class JSPDispatcher
    extends Dispatcher {
        public JSPDispatcher(String target) {
            super(target);
        }

        @Override
        public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            String url = this.target;
            if (!url.startsWith("/")) {
                url = "/jsp/" + url;
            }
            Log.logDebug("JSP Redirector forwarding to:" + url);
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(url);
            try {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e) {
                throw new ServletException("I/O exception occurred forwarding to JSP: " + this.target, (Throwable)e);
            }
        }
    }

    private static abstract class Dispatcher {
        protected String target;

        public Dispatcher(String target) {
            this.target = target;
        }

        public abstract void forward(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;
    }
}

