/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.impl;

import fuego.papi.GlobalExecution;
import java.io.IOException;
import javax.servlet.ServletException;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.DefaultExecutionData;
import oracle.bpm.web.execution.DefaultExecutionManager;
import oracle.bpm.web.execution.ExecutionData;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExecutionManagerFactory;
import oracle.bpm.web.execution.InteractiveExecution;
import oracle.bpm.web.execution.InteractiveInvocation;
import oracle.bpm.web.execution.exception.TimeStampExpiredException;
import oracle.bpm.web.execution.impl.WebExecutionIdentifier;

public abstract class WebInteractiveExecution
extends InteractiveExecution {
    protected WebInteractiveExecution(ExecutionData exec) {
        super(exec);
    }

    public String getTaskLabel() {
        DefaultExecutionData status = (DefaultExecutionData)this.getExecutionData();
        return status.getTaskLabel();
    }

    @Override
    public ExecutionIdentifier buildExecutionIdentifier() {
        DefaultExecutionData data = (DefaultExecutionData)this.getExecutionData();
        return WebExecutionIdentifier.create(Integer.parseInt(data.getId()), data.backSize());
    }

    @Override
    public void process(Throwable exception) throws Throwable {
        this.checkBack();
        super.process(exception);
    }

    @Override
    public void processException(Throwable e) throws Throwable {
        this.remove(this);
        throw e;
    }

    protected void checkBack() throws TimeStampExpiredException {
        ExecutionData execData = this.getExecutionData();
        InteractiveInvocation pending = execData.getPending();
        int sequence = this.getExecutionIdentifier().getSequence();
        if (pending != null && !pending.supportsBack() && execData.backSize() != sequence) {
            boolean global = false;
            if (execData.getExecution() instanceof GlobalExecution) {
                global = true;
            }
            if (Log.isDebugging()) {
                Log.logDebug("execData.getExecutedItemKey():" + execData.getId());
            }
            throw new TimeStampExpiredException(global);
        }
    }

    @Override
    protected void executionFinished() throws IOException {
        this.remove(this);
    }

    @Override
    protected Throwable filterException(Throwable exception) {
        ServletException servletException;
        Throwable rootCause;
        if (exception instanceof ServletException && (rootCause = (servletException = (ServletException)exception).getRootCause()) != null) {
            exception = rootCause;
        }
        return exception;
    }

    protected void remove(InteractiveExecution execution) {
        DefaultExecutionManager webExecMng = (DefaultExecutionManager)ExecutionManagerFactory.getDefault();
        webExecMng.remove(execution, this.getExternalContext());
    }
}

