/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.log.Log;
import oracle.bpm.util.Properties;
import oracle.bpm.web.execution.DefaultExecutionManager;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.Request;
import oracle.bpm.web.execution.exception.InteractiveComponentNotSupportedException;

public abstract class WebExecutionManager
extends DefaultExecutionManager {
    public static final String EXECUTION_ABORTED = "execAborted";
    private static Map<String, Properties> propertiesCache;

    public WebExecutionManager() {
        propertiesCache = Collections.synchronizedMap(new HashMap());
    }

    public abstract String getStyleSheet(ExternalContext var1);

    public abstract String getTitle(ExternalContext var1);

    public abstract void updateExecutionIdentifier(ExternalContext var1, ExecutionIdentifier var2);

    public abstract ExecutionIdentifier retrieveExecutionIdentifier(ExternalContext var1);

    public abstract String urlForInternalForwardAction(String var1, String var2, ExternalContext var3);

    public abstract String urlForPostAction(String var1, String var2, ExternalContext var3);

    public abstract String getFinishUrl(ExternalContext var1);

    public abstract String getExecutionAbortedUrl(ExternalContext var1);

    public abstract String getFooterPage();

    public abstract String getHeaderPage();

    public abstract ExternalContext createExternalContext(HttpServletRequest var1, HttpServletResponse var2);

    public String getHelpUrl(ExternalContext context, String component, String helpKey) {
        return null;
    }

    public boolean isExecutionAborted(ExternalContext context) {
        Request request = context.getRequest();
        String aborted = request.getParameter(EXECUTION_ABORTED);
        if (aborted == null) {
            return false;
        }
        return Boolean.valueOf(aborted);
    }

    public String findImageUrl(String component, String image, ExternalContext externalContext) {
        Properties properties = this.findComponentProperties(component);
        return properties.getProperty("web.img." + image);
    }

    public String findJSPIncludeUrl(String component, String jsp) throws InteractiveComponentNotSupportedException {
        return this.findActionTarget(component, jsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties findComponentProperties(String component) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Properties properties = propertiesCache.get(component);
        if (properties == null) {
            InputStream in = cl.getResourceAsStream(component + ".properties");
            if (in == null) {
                throw new InteractiveComponentNotSupportedException(component);
            }
            try {
                try {
                    properties = new Properties();
                    properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                Log.logSevere(e);
            }
            propertiesCache.put(component, properties);
        }
        return properties;
    }

    protected String findActionTarget(String component, String action) {
        Properties properties = this.findComponentProperties(component);
        String target = properties.getProperty("web." + action);
        if (target == null) {
            target = properties.getProperty("web.jsp." + action);
        }
        return target;
    }
}

