/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.impl;

import fuego.papi.Activity;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExecutionManagerFactory;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.impl.WebExecutionManager;

public class WebExecutionIdentifier
implements ExecutionIdentifier {
    private Activity activity;
    private int contextSequence;
    private String executionUUID;
    private int taskId;
    private String taskLabel;
    private static int globalTaskId;
    public static final String PARAM_EXECUTION_ID = "execId";
    protected static final String EXECUTION_ID_OBJECT = "execIdObj";

    protected WebExecutionIdentifier(String executionUUID) {
        this.taskId = WebExecutionIdentifier.allocateContextKey();
        this.contextSequence = 0;
        this.executionUUID = executionUUID;
    }

    protected WebExecutionIdentifier(String executionUUID, String interactiveInvocationId) {
        int contextId = Integer.parseInt(interactiveInvocationId, 16);
        this.taskId = contextId >>> 16 & 0xFFFF;
        this.contextSequence = contextId & 0xFFFF;
        this.executionUUID = executionUUID;
    }

    protected WebExecutionIdentifier(int taskId, int contextSequence) {
        this.taskId = taskId;
        this.contextSequence = contextSequence;
    }

    public static ExecutionIdentifier loadFrom(String interactiveInvocationId) {
        return new WebExecutionIdentifier(null, interactiveInvocationId);
    }

    public static WebExecutionIdentifier create(String executionUUID, Activity activity, String taskLabel) {
        WebExecutionIdentifier execId = new WebExecutionIdentifier(executionUUID);
        execId.taskLabel = taskLabel;
        execId.activity = activity;
        return execId;
    }

    public static WebExecutionIdentifier create(String executionUUID) {
        return new WebExecutionIdentifier(executionUUID);
    }

    public static WebExecutionIdentifier create(int taskId, int sequence) {
        return new WebExecutionIdentifier(taskId, sequence);
    }

    @Override
    public Integer getTaskKey() {
        return this.taskId;
    }

    @Override
    public void setAsCurrent(ExternalContext extContext) {
        WebExecutionManager execManager = (WebExecutionManager)ExecutionManagerFactory.getDefault();
        execManager.updateExecutionIdentifier(extContext, this);
    }

    @Override
    public String getExecutionUUID() {
        return this.executionUUID;
    }

    @Override
    public int setSequence(int sequece) {
        this.contextSequence = sequece;
        return this.contextSequence;
    }

    @Override
    public int getSequence() {
        return this.contextSequence;
    }

    public String toString() {
        return Integer.toHexString((0xFFFF & this.taskId) << 16 | 0xFFFF & this.contextSequence);
    }

    public String addExecutionParameters(String url) throws UnsupportedEncodingException {
        String separator = "?";
        if (url.indexOf("?") != -1) {
            separator = "&";
        }
        url = url + separator + URLEncoder.encode(PARAM_EXECUTION_ID, "UTF-8") + '=' + URLEncoder.encode(this.toString(), "UTF-8");
        return url;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public String getTaskLabel() {
        return this.taskLabel;
    }

    private static short allocateContextKey() {
        int key = globalTaskId++;
        assert (key <= 65535) : "id out of range";
        return (short)key;
    }
}

