/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution;

import fuego.papi.Execution;
import fuego.papi.GlobalExecution;
import fuego.papi.Invocation;
import java.io.IOException;
import oracle.bpm.component.InteractiveExecutionException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentAction;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.ExecutionData;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.InteractiveInvocation;
import oracle.bpm.web.execution.ModelAccessor;
import oracle.bpm.web.execution.exception.ResumeExecutionException;

public abstract class InteractiveExecution {
    protected transient ExecutionIdentifier execId;
    private transient ExecutionData execData = null;
    private transient ExternalContext externalContext;
    public static final int GLOBAL_EXECUTION = 0;
    public static final int TASK_EXECUTION = 1;

    public InteractiveExecution(ExecutionData execData) {
        this.execData = execData;
    }

    public abstract ExecutionIdentifier buildExecutionIdentifier();

    public static void execute(ModelAccessor execution) {
        throw new ExecutionRequested(execution);
    }

    public ExecutionData getExecutionData() {
        return this.execData;
    }

    public ExecutionIdentifier getExecutionIdentifier() {
        if (this.execId == null) {
            this.execId = this.buildExecutionIdentifier();
        }
        return this.execId;
    }

    public int getExecutionType() {
        int type = this.execData.getExecution() instanceof GlobalExecution ? 0 : 1;
        return type;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        InteractiveInvocation pending;
        ExecutionData executionData = this.execData;
        synchronized (executionData) {
            pending = this.execData.getPending();
            if (pending == null) {
                this.execData.setAborted(true);
            }
        }
        if (pending != null) {
            pending.abort(this.execData);
            this.execData.setPending(null);
        }
    }

    public void initialize(ExecutionIdentifier execId, ExternalContext externalContext) {
        this.setExecutionIdentifier(execId);
        this.setExternalContext(externalContext);
    }

    public void process(Throwable exception) throws Throwable {
        Execution execution = this.execData.getExecution();
        InteractiveInvocation pending = this.execData.getPending();
        if (this.execData.isFinished()) {
            throw new IllegalStateException("This Execution has already finished");
        }
        int index = this.execId.getSequence();
        if (exception == null) {
            try {
                if (pending != null) {
                    if (index < this.execData.backSize()) {
                        while (index < this.execData.backSize()) {
                            pending = this.execData.pop();
                        }
                    }
                    this.execData.push(pending);
                    pending.finish(this.execData);
                    pending = null;
                    this.execData.setPending(null);
                }
            }
            catch (ResumeExecutionException e) {
                this.execData.pop();
                this.invokePrepare(pending);
                return;
            }
            catch (Throwable e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                exception = e;
            }
        }
        if (exception != null) {
            this.setExecutionError(exception, execution);
        }
        this.execId.setSequence(this.execData.backSize());
        this.execId.setAsCurrent(this.getExternalContext());
        try {
            Invocation inv = execution.next();
            while (inv != null) {
                block19: {
                    Object[] args = inv.doPreInvoke();
                    try {
                        Object retval = inv.doInvoke(args);
                        execution.setInvocationResult(inv.doPostInvoke(args, retval));
                    }
                    catch (ComponentExecutionException e) {
                        if (e.getCause() instanceof ExecutionRequested) {
                            ExecutionRequested we = (ExecutionRequested)e.getCause();
                            ModelAccessor w = we.getModelAccessor();
                            try {
                                pending = new InteractiveInvocation(w, inv, args);
                                this.invokePrepare(pending);
                                return;
                            }
                            catch (Throwable ex) {
                                if (Log.isDebugging()) {
                                    Log.logDebug(ex);
                                }
                                this.setExecutionError(ex, execution);
                                break block19;
                            }
                        }
                        this.setExecutionError(e, execution);
                    }
                }
                inv = execution.next();
            }
            this.execData.setFinished(true);
            this.executionFinished();
        }
        catch (Throwable e) {
            this.processException(e);
        }
    }

    public void process() throws Throwable {
        this.process(null);
    }

    public void retry() throws ComponentExecutionException {
        InteractiveInvocation pending = this.execData.getPending();
        Execution execution = this.execData.getExecution();
        this.execId = this.buildExecutionIdentifier();
        this.execId.setAsCurrent(this.getExternalContext());
        if (this.execData.isFinished()) {
            throw new IllegalStateException("This Execution has already finished");
        }
        try {
            if (pending != null) {
                ComponentAction action = pending.retryExecution(this.execData);
                this.dispatchComponentExecution(action);
            }
        }
        catch (Throwable t) {
            ComponentExecutionException comException = new ComponentExecutionException(t);
            execution.setException(comException);
            throw comException;
        }
    }

    public ComponentContext componentContext(ExecutionIdentifier executionIdentifier) {
        ExecutionData data = this.getExecutionData();
        if (data != null) {
            boolean supportBack = data.getPending() != null && data.getPending().supportsBack();
            int sequence = executionIdentifier.getSequence();
            if (supportBack) {
                assert (sequence != -1) : "Index should have been initialized";
                data.setCurrentInvocation(sequence);
            }
        }
        return data;
    }

    protected abstract void dispatchComponentExecution(ComponentAction var1) throws IOException;

    protected abstract void executionFinished() throws IOException;

    protected abstract Throwable filterException(Throwable var1);

    protected abstract void processException(Throwable var1) throws Throwable;

    void setExecutionIdentifier(ExecutionIdentifier execId) {
        this.execId = execId;
    }

    void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    private void setExecutionError(Throwable exception, Execution execution) {
        exception = this.filterException(exception);
        if (execution == null) {
            throw new IllegalStateException("Execution is null while processing exception", exception);
        }
        execution.setException(new ComponentExecutionException(exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePrepare(InteractiveInvocation pending) throws Exception {
        if (Log.isDebugging()) {
            Log.logDebug("InteractiveExecution.invokePrepare->execData.isAborted():" + this.execData.isAborted());
        }
        ExecutionData executionData = this.execData;
        synchronized (executionData) {
            boolean aborted = this.execData.isAborted();
            if (!aborted) {
                if (Log.isDebugging()) {
                    Log.logDebug("InteractiveExecution.invokePrepare->setPending execution");
                }
                if (Log.isDebugging()) {
                    Log.logDebug("InteractiveExecution.invokePrepare->pending:" + pending);
                }
            } else {
                pending.abort(this.execData);
                return;
            }
            this.execData.setPending(pending);
        }
        ComponentAction action = pending.prepare(this.execData);
        if (Log.isDebugging()) {
            Log.logDebug("InteractiveExecution.invokePrepare->pending.prepare:" + action);
        }
        this.dispatchComponentExecution(action);
    }

    private static final class ExecutionRequested
    extends InteractiveExecutionException {
        private ModelAccessor modelAccessor;
        static final long serialVersionUID = -3692138366529555989L;
        static final long serialCheck = -2746978511432204696L;

        ExecutionRequested(ModelAccessor modelAccessor) {
            this.modelAccessor = modelAccessor;
        }

        ModelAccessor getModelAccessor() {
            return this.modelAccessor;
        }
    }
}

