/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.web.execution.InteractiveExecutionManager;

public final class ExecutionManagerFactory {
    private static final Map<String, InteractiveExecutionManager> factoryPool = new HashMap<String, InteractiveExecutionManager>();
    private static InteractiveExecutionManager defaultInstance;

    private ExecutionManagerFactory() {
    }

    public static void setDefault(Class<? extends InteractiveExecutionManager> clazz) {
        defaultInstance = ExecutionManagerFactory.createExecutionManager(clazz);
    }

    public static InteractiveExecutionManager getDefault() {
        if (defaultInstance == null) {
            throw new IllegalStateException("Default ExecutionManager not initialized");
        }
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractiveExecutionManager createExecutionManager(Class<? extends InteractiveExecutionManager> execClass) {
        InteractiveExecutionManager result;
        Map<String, InteractiveExecutionManager> map = factoryPool;
        synchronized (map) {
            result = factoryPool.get(execClass.getName());
            if (result == null) {
                try {
                    result = execClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Failed to create ExecutionManager", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to create ExecutionManager", e);
                }
                factoryPool.put(execClass.getName(), result);
            }
        }
        return result;
    }
}

