/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.project;

import java.util.Collection;
import oracle.bpm.project.io.simulation.jaxb.project.CategoryProbabilities;
import oracle.bpm.project.io.simulation.jaxb.project.CategoryProbability;
import oracle.bpm.project.io.simulation.jaxb.project.ModelSimulation;
import oracle.bpm.project.io.simulation.jaxb.project.ModelSimulations;
import oracle.bpm.project.io.simulation.jaxb.project.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.project.Resource;
import oracle.bpm.project.io.simulation.jaxb.project.Resources;
import oracle.bpm.project.io.simulation.jaxb.project.Role;
import oracle.bpm.project.io.simulation.jaxb.project.Roles;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSimulationJaxbVisitor
extends ProjectVisitorAdapter {
    private final oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation = simulationFactory.createProjectSimulation();
    private static final ObjectFactory simulationFactory = new ObjectFactory();

    private ProjectSimulationJaxbVisitor() {
    }

    public static ProjectSimulationJaxbVisitor create() {
        return new ProjectSimulationJaxbVisitor();
    }

    public oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation getJaxbProjectSimulation() {
        return this.jaxbProjectSimulation;
    }

    @Override
    public void visit(@NotNull ProjectSimulation projectSimulation) throws ProjectException {
        this.jaxbProjectSimulation.setInflightFinish(projectSimulation.getInflightFinish());
        this.jaxbProjectSimulation.setStartTime(projectSimulation.getStartTime());
        this.jaxbProjectSimulation.setName(projectSimulation.getId());
        this.jaxbProjectSimulation.setDuration(projectSimulation.getDuration().toString());
        this.jaxbProjectSimulation.setUseCalendarRules(projectSimulation.getUseCalendarRules());
        this.visitCategoryProbabilities(projectSimulation.getCategoryProbabilities());
        this.visitResources(projectSimulation.getResources());
        this.visitModels(projectSimulation.getModelSimulations());
    }

    @Override
    public void visit(@NotNull SimulationResource simulationResource) {
        Resources jaxbResources = this.jaxbProjectSimulation.getResources();
        if (jaxbResources != null) {
            Resource jaxbResource = simulationFactory.createResource();
            jaxbResource.setName(simulationResource.getId());
            jaxbResource.setEfficiency(simulationResource.getEfficiency());
            jaxbResource.setCapacity(simulationResource.getCapacity());
            jaxbResource.setVirtual(simulationResource.isVirtual());
            jaxbResource.setSelected(simulationResource.getSelected());
            jaxbResource.setCost(simulationResource.getCost());
            jaxbResource.setAvailability(simulationResource.getAvailability());
            Roles jaxbRoles = simulationFactory.createRoles();
            for (String role : simulationResource.getRoles()) {
                Role jaxbRole = simulationFactory.createRole();
                jaxbRole.setId(role);
                jaxbRoles.getRole().add(jaxbRole);
            }
            jaxbResource.setRoles(jaxbRoles);
            jaxbResources.getResource().add(jaxbResource);
        }
    }

    private void visitModels(@Nullable Collection<oracle.bpm.project.model.simulation.ModelSimulation> modelSimulations) {
        if (modelSimulations != null && modelSimulations.size() > 0) {
            ModelSimulations jaxbModelSimulations = simulationFactory.createModelSimulations();
            for (oracle.bpm.project.model.simulation.ModelSimulation modelSimulation : modelSimulations) {
                ModelSimulation jaxbModelSimulation = simulationFactory.createModelSimulation();
                jaxbModelSimulation.setModelId(this.createModelSimulationId(modelSimulation));
                jaxbModelSimulation.setModelVariation("");
                jaxbModelSimulation.setModelSimulationId(modelSimulation.getId());
                jaxbModelSimulations.getModelSimulation().add(jaxbModelSimulation);
            }
            this.jaxbProjectSimulation.setModelSimulations(jaxbModelSimulations);
        }
    }

    @NotNull
    private String createModelSimulationId(@NotNull oracle.bpm.project.model.simulation.ModelSimulation modelSimulation) {
        return "/" + modelSimulation.getProcess().getId() + ".xpdl";
    }

    private void visitResources(@Nullable Collection<SimulationResource> resources) throws ProjectException {
        if (resources != null && resources.size() > 0) {
            this.jaxbProjectSimulation.setResources(simulationFactory.createResources());
            for (SimulationResource simulationResource : resources) {
                simulationResource.visit(this);
            }
        }
    }

    private void visitCategoryProbabilities(@Nullable double[] categoryProbabilities) {
        if (categoryProbabilities != null && categoryProbabilities.length > 0) {
            CategoryProbabilities jaxbCategoryProbabilities = simulationFactory.createCategoryProbabilities();
            for (double categoryProbability : categoryProbabilities) {
                CategoryProbability jaxbCategoryProbability = simulationFactory.createCategoryProbability();
                jaxbCategoryProbability.setValue(categoryProbability);
                jaxbCategoryProbabilities.getCategoryProbability().add(jaxbCategoryProbability);
            }
            this.jaxbProjectSimulation.setCategoryProbabilities(jaxbCategoryProbabilities);
        }
    }
}

