/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.project;

import java.io.Closeable;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.simulation.jaxb.project.CategoryProbabilities;
import oracle.bpm.project.io.simulation.jaxb.project.CategoryProbability;
import oracle.bpm.project.io.simulation.jaxb.project.ModelSimulations;
import oracle.bpm.project.io.simulation.jaxb.project.ObjectFactory;
import oracle.bpm.project.io.simulation.jaxb.project.Resource;
import oracle.bpm.project.io.simulation.jaxb.project.Resources;
import oracle.bpm.project.io.simulation.jaxb.project.Role;
import oracle.bpm.project.io.simulation.jaxb.project.Roles;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSimulationJaxbLoader {
    private final Project project;
    private final Reader reader;
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});

    public ProjectSimulationJaxbLoader(@NotNull Reader reader, @NotNull Project project) {
        this.reader = reader;
        this.project = project;
    }

    @NotNull
    public static ProjectSimulationJaxbLoader create(@NotNull Reader reader, @NotNull Project project) {
        return new ProjectSimulationJaxbLoader(reader, project);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ProjectSimulation load() throws UnsupportedEncodingException, ParserException, ProjectException {
        ProjectSimulation projectSimulation = null;
        try {
            JAXBContext jc = JAXB_CONTEXT;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(this.reader);
            if (!(unmarshalledObject instanceof oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation)) throw new ParserException("Invalid JAXB element found");
            oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation = (oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation)unmarshalledObject;
            projectSimulation = this.load(jaxbProjectSimulation);
        }
        catch (JAXBException e) {
            try {
                Log.logFatal((Throwable)e);
                throw new ParserException((Throwable)e);
                catch (Exception t) {
                    Log.logFatal((Throwable)t);
                    throw new ParserException((Throwable)t);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{this.reader});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{this.reader});
        return projectSimulation;
    }

    @NotNull
    private ProjectSimulation load(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation) throws ProjectException {
        ProjectSimulation projectSimulation = this.project.getSimulations().createProjectSimulation(jaxbProjectSimulation.getName());
        projectSimulation.setUseCalendarRules(jaxbProjectSimulation.isUseCalendarRules());
        projectSimulation.setStartTime(Time.valueOf((long)jaxbProjectSimulation.getStartTime()));
        projectSimulation.setInflightFinish(jaxbProjectSimulation.isInflightFinish());
        try {
            projectSimulation.setDuration(Interval.valueOf((String)jaxbProjectSimulation.getDuration()));
        }
        catch (NumberFormatException e) {
            projectSimulation.setDuration(Interval.ONE_HOUR);
        }
        this.loadModels(jaxbProjectSimulation, projectSimulation);
        this.loadResources(jaxbProjectSimulation, projectSimulation);
        this.loadCategoryProbabilities(jaxbProjectSimulation, projectSimulation);
        return projectSimulation;
    }

    private void loadModels(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation, @NotNull ProjectSimulation projectSimulation) throws ProjectException {
        List<oracle.bpm.project.io.simulation.jaxb.project.ModelSimulation> jaxbModelSimulationList;
        ModelSimulations jaxbModelSimulations = jaxbProjectSimulation.getModelSimulations();
        if (jaxbModelSimulations != null && (jaxbModelSimulationList = jaxbModelSimulations.getModelSimulation()) != null && jaxbModelSimulationList.size() > 0) {
            for (oracle.bpm.project.io.simulation.jaxb.project.ModelSimulation jaxbModelSimulation : jaxbModelSimulationList) {
                this.loadModel(jaxbModelSimulation, projectSimulation);
            }
        }
    }

    private void loadModel(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ModelSimulation jaxbModelSimulation, @NotNull ProjectSimulation projectSimulation) throws ProjectException {
        Process process = projectSimulation.getProject().findProcess(this.getFormattedModelId(jaxbModelSimulation));
        if (process != null) {
            Project project = process.getProject();
            ModelSimulation modelSimulation = project.getSimulations().findModelSimulation(process, jaxbModelSimulation.getModelSimulationId());
            if (modelSimulation != null) {
                projectSimulation.addModelSimulation(modelSimulation);
            } else {
                Log.logWarning((Msg)ProjectMsg.SIMULATION_MODEL_NOT_PRESENT);
            }
        }
    }

    private String getFormattedModelId(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ModelSimulation jaxbModelSimulation) {
        return FileUtils.removeExtension((String)jaxbModelSimulation.getModelId()).replace("/", "");
    }

    private void loadResources(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation, @NotNull ProjectSimulation projectSimulation) throws ProjectException {
        List<Resource> jaxbResourceList;
        Resources jaxbSimulationResources = jaxbProjectSimulation.getResources();
        if (jaxbSimulationResources != null && (jaxbResourceList = jaxbSimulationResources.getResource()) != null && jaxbResourceList.size() > 0) {
            for (Resource jaxbResource : jaxbResourceList) {
                this.loadResource(jaxbResource, projectSimulation);
            }
        }
    }

    private void loadResource(@NotNull Resource jaxbResource, @NotNull ProjectSimulation projectSimulation) throws ProjectException {
        List<Role> jaxbResurceRolesList;
        SimulationResource resource = projectSimulation.createResource(jaxbResource.getName());
        resource.setAvailability(jaxbResource.getAvailability());
        resource.setCapacity(jaxbResource.getCapacity());
        resource.setCost(jaxbResource.getCost());
        resource.setEfficiency(jaxbResource.getEfficiency());
        resource.setSelected(jaxbResource.isSelected());
        resource.setVirtual(jaxbResource.isVirtual());
        Roles jaxbResourceRoles = jaxbResource.getRoles();
        if (jaxbResourceRoles != null && (jaxbResurceRolesList = jaxbResourceRoles.getRole()) != null && jaxbResurceRolesList.size() > 0) {
            Vector<String> resourceRoles = new Vector<String>();
            for (Role jaxbRole : jaxbResurceRolesList) {
                resourceRoles.add(jaxbRole.getId());
            }
            resource.setRoles(resourceRoles.toArray(new String[resourceRoles.size()]));
        }
        projectSimulation.addResource(resource);
    }

    private void loadCategoryProbabilities(@NotNull oracle.bpm.project.io.simulation.jaxb.project.ProjectSimulation jaxbProjectSimulation, @NotNull ProjectSimulation projectSimulation) {
        List<CategoryProbability> jaxbCategoryProbabilityList;
        CategoryProbabilities jaxbCategoryProbabilities = jaxbProjectSimulation.getCategoryProbabilities();
        if (jaxbCategoryProbabilities != null && (jaxbCategoryProbabilityList = jaxbCategoryProbabilities.getCategoryProbability()) != null && jaxbCategoryProbabilityList.size() > 0) {
            Vector<Double> categoryProbabilities = new Vector<Double>();
            for (CategoryProbability jaxbCategoryProbability : jaxbCategoryProbabilityList) {
                categoryProbabilities.add(jaxbCategoryProbability.getValue());
            }
            double[] doubleArray = new double[categoryProbabilities.size()];
            for (int i = 0; i < categoryProbabilities.size(); ++i) {
                doubleArray[i] = (Double)categoryProbabilities.get(i);
            }
            projectSimulation.setCategoryProbabilities(doubleArray);
        }
    }
}

