/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.xml.XmlWriter;

public class XmlOrganizationalUnitSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof OrganizationalUnit);
        OrganizationalUnit ou = (OrganizationalUnit)object;
        xmlWriter.startElement("DirOrganizationalUnit");
        xmlWriter.printValuedElement("name", ou.getId());
        xmlWriter.printValuedElement("description", ou.getDescription());
        OrganizationalUnit organizationalUnit = ou.getParent();
        if (organizationalUnit != null) {
            xmlWriter.printValuedElement("parentId", organizationalUnit.getInternalPath());
        }
        String calendarRule = null;
        if (ou.getCalendarRuleAssignment() != null) {
            calendarRule = ou.getCalendarRuleAssignment().getCalendarRule() != null ? ou.getCalendarRuleAssignment().getCalendarRule().getId() : ou.getCalendarRuleAssignment().getCalendarRuleId();
        }
        xmlWriter.printValuedElement("nameCalendar", calendarRule);
        xmlWriter.endElement();
    }
}

