/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;

public class XmlOrganizationalChartSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof OrganizationalChart);
        OrganizationalChart oc = (OrganizationalChart)object;
        xmlWriter.startElement("OrganizationalChart");
        xmlWriter.printValuedElement("name", oc.getId());
        Sequence<OrganizationalUnit> ous = oc.getRootOrganizationalUnit().getChildrenByType(OrganizationalUnit.class);
        if (!ous.isEmpty()) {
            xmlWriter.startElement("organizationalUnits");
            for (OrganizationalUnit ou : ous) {
                this.serializeOrganizationalUnit(ou, xmlWriter);
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void serializeOrganizationalUnit(@NotNull OrganizationalUnit ou, @NotNull XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("ou");
        xmlWriter.printValuedElement("name", ou.getId());
        xmlWriter.printValuedElement("description", ou.getDescription());
        String calendarRule = null;
        if (ou.getCalendarRuleAssignment() != null) {
            calendarRule = ou.getCalendarRuleAssignment().getCalendarRule() != null ? ou.getCalendarRuleAssignment().getCalendarRule().getId() : ou.getCalendarRuleAssignment().getCalendarRuleId();
        }
        xmlWriter.printValuedElement("nameCalendar", calendarRule);
        Sequence<OrganizationalUnit> children = ou.getChildrenByType(OrganizationalUnit.class);
        if (!children.isEmpty()) {
            xmlWriter.startElement("organizationalUnits");
            for (OrganizationalUnit child : children) {
                this.serializeOrganizationalUnit(child, xmlWriter);
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }
}

