/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.Role;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RoleHandler
extends BaseSourceHandler {
    private Collection<CalendarRuleAssignmentHandler.CalendarRuleAssignmentData> calendarRuleAssignments = new ArrayList<CalendarRuleAssignmentHandler.CalendarRuleAssignmentData>();
    private String description;
    private LocaleStringMap displayNames = LocaleStringMap.create();
    private String id;

    RoleHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        if ("description".equals(name)) {
            return new DescriptionHandler(this);
        }
        if ("calendarRules".equals(name)) {
            return new CalendarRulesHandler(this);
        }
        if ("localizedDisplayNames".equals(name)) {
            return new LocalizedDisplayNamesHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            Role role = container.createRole(this.id);
            role.setDescription(this.description);
            role.getLabelMap().clear();
            for (Locale locale : this.displayNames.keySet()) {
                role.getLabelMap().put(locale, (String)this.displayNames.get((Object)locale));
            }
            for (CalendarRuleAssignmentHandler.CalendarRuleAssignmentData calendarRuleAssignmentData : this.calendarRuleAssignments) {
                CalendarRuleAssignment.Mutable calendarRuleAssignment = role.createCalendarRuleAssignment();
                if (calendarRuleAssignmentData.calendarRuleId != null) {
                    calendarRuleAssignment.setCalendarRule(calendarRuleAssignmentData.calendarRuleId);
                }
                if (calendarRuleAssignmentData.ouId != null) {
                    calendarRuleAssignment.setOrganizationalUnit(calendarRuleAssignmentData.ouId);
                }
                role.addCalendarRuleAssignment(calendarRuleAssignment);
            }
            this.getParseListener().objectParsed(this, role);
        }
        catch (ProjectException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            RoleHandler.this.id = this.getData();
        }
    }

    private class LocalizedDisplayNamesHandler
    extends BaseSourceHandler {
        public LocalizedDisplayNamesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("localizedDisplayName".equals(name)) {
                return new LocalizedDisplayNameHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class LocalizedDisplayNameHandler
        extends BaseSourceHandler {
            private Locale locale;
            private String message;

            public LocalizedDisplayNameHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public SourceHandler getHandler(String uri, String qName, String name) {
                if ("locale".equals(name)) {
                    return new LocaleHandler(this);
                }
                if ("message".equals(name)) {
                    return new MessageHandler(this);
                }
                return new BaseSourceHandler(this);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                RoleHandler.this.displayNames.put(this.locale, this.message);
            }

            private class MessageHandler
            extends DataElementHandler {
                public MessageHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    LocalizedDisplayNameHandler.this.message = this.getData();
                }
            }

            private class LocaleHandler
            extends DataElementHandler {
                public LocaleHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    LocalizedDisplayNameHandler.this.locale = new Locale(this.getData());
                }
            }
        }
    }

    private class DescriptionHandler
    extends DataElementHandler {
        public DescriptionHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            RoleHandler.this.description = this.getData();
        }
    }

    private class CalendarRulesHandler
    extends BaseSourceHandler {
        public CalendarRulesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("calendarRule".equals(name)) {
                return new CalendarRuleAssignmentHandler(this);
            }
            return new BaseSourceHandler(this);
        }
    }

    private class CalendarRuleAssignmentHandler
    extends BaseSourceHandler {
        CalendarRuleAssignmentData calendarRuleData;

        public CalendarRuleAssignmentHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.calendarRuleData = new CalendarRuleAssignmentData();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            RoleHandler.this.calendarRuleAssignments.add(this.calendarRuleData);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("nameCalendar".equals(name)) {
                return new CalendarRuleAssignmentNameHandler(this);
            }
            if ("ou".equals(name)) {
                return new CalendarRuleAssignmentOuHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class CalendarRuleAssignmentOuHandler
        extends DataElementHandler {
            public CalendarRuleAssignmentOuHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                CalendarRuleAssignmentHandler.this.calendarRuleData.ouId = this.getData();
            }
        }

        private class CalendarRuleAssignmentNameHandler
        extends DataElementHandler {
            public CalendarRuleAssignmentNameHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                CalendarRuleAssignmentHandler.this.calendarRuleData.calendarRuleId = this.getData();
            }
        }

        private class CalendarRuleAssignmentData {
            String calendarRuleId;
            String ouId;

            private CalendarRuleAssignmentData() {
            }
        }
    }
}

