/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.LinkedHashMap;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.io.serializers.ProjectPreferencesXMLGenerator;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;

public class ProjectObjectSerializerFactory {
    public static final LinkedHashMap<Class<?>, ProjectObjectSerializer> registry = new LinkedHashMap();

    public static ProjectObjectSerializer getSerializer(ProjectObject object) {
        for (Class<?> key : registry.keySet()) {
            if (!key.isAssignableFrom(object.getClass())) continue;
            return registry.get(key);
        }
        throw new ProgramException("There are no serializer registered for the ProjectObject of type '" + object.getClass().getName() + "\nObject: " + object);
    }

    static {
        registry.put(ProjectPreferences.class, new ProjectPreferencesXMLGenerator());
    }
}

