/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import oracle.bpm.project.io.exception.CheckContentTypeException;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.PropertiesHandler;
import oracle.bpm.project.io.serializers.organization.RoleAssignmentHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.RoleAssignment;
import org.xml.sax.SAXException;

class GroupHandler
extends BaseSourceHandler {
    private Collection<String> assignedGroups;
    private Collection<String> assignedParticipants;
    private String description;
    private String id;
    private HashMap<String, HashMap<String, String>> propertiesByCategory = new HashMap();
    private Collection<RoleAssignmentHandler.RoleAssignmentData> roleAssignments = new ArrayList<RoleAssignmentHandler.RoleAssignmentData>();
    private String status;

    GroupHandler(BaseSourceHandler parent, boolean checkContentType) {
        super(parent, checkContentType);
        this.assignedGroups = new ArrayList<String>();
        this.assignedParticipants = new ArrayList<String>();
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        if ("description".equals(name)) {
            return new DescriptionHandler(this);
        }
        if ("status".equals(name)) {
            return new StatusHandler(this);
        }
        if ("rolesAssignment".equals(name)) {
            return new AssignedRolesHandler(this);
        }
        if ("assignedGroups".equals(name)) {
            return new AssignedGroupsHandler(this);
        }
        if ("assignedParticipants".equals(name)) {
            return new AssignedParticipantsHandler(this);
        }
        if (name.endsWith("Properties")) {
            return new PropertiesHandler(this, this.propertiesByCategory, this.isCheckContentType());
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!this.propertiesByCategory.keySet().contains("PROFILE_CATEGORY")) {
                if (this.isCheckContentType()) {
                    throw new CheckContentTypeException(ProjectObjectType.ORGANIZATION_GROUP);
                }
                this.createGroup();
            }
        }
        catch (ProjectException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private void createGroup() throws ProjectException {
        ResourceContainer container = this.getContainer();
        Group g = container.createGroup(this.id);
        Group.Mutable group = g.asMutable();
        group.setDescription(this.description);
        if ("A".equals(this.status)) {
            group.setEnabled(true);
        } else if ("D".equals(this.status)) {
            group.setEnabled(false);
        } else assert (false) : "Invalid status for group! Value: " + this.status;
        for (RoleAssignmentHandler.RoleAssignmentData roleAssignmentData : this.roleAssignments) {
            RoleAssignment.Mutable roleAssignment = group.createRoleAssignment();
            roleAssignment.setCategory(roleAssignmentData.category);
            roleAssignment.setParametricValue(roleAssignmentData.parametricValue);
            roleAssignment.setPermissions(roleAssignmentData.permissions);
            roleAssignment.setRole(roleAssignmentData.roleId);
            group.addRoleAssignment(roleAssignment);
        }
        for (String groupId : this.assignedGroups) {
            group.assignGroup(groupId);
        }
        this.getParseListener().objectParsed(this, group);
    }

    private class StatusHandler
    extends DataElementHandler {
        public StatusHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            GroupHandler.this.status = this.getData();
        }
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            GroupHandler.this.id = this.getData();
        }
    }

    private class DescriptionHandler
    extends DataElementHandler {
        public DescriptionHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            GroupHandler.this.description = this.getData();
        }
    }

    private class AssignedRolesHandler
    extends BaseSourceHandler {
        public AssignedRolesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("roleAssignment".equals(name)) {
                return new RoleAssignmentHandler((BaseSourceHandler)this, GroupHandler.this.roleAssignments);
            }
            return new BaseSourceHandler(this);
        }
    }

    private class AssignedParticipantsHandler
    extends BaseSourceHandler {
        public AssignedParticipantsHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("participantId".equals(name)) {
                return new ParticipantAssignmentHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class ParticipantAssignmentHandler
        extends DataElementHandler {
            public ParticipantAssignmentHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                GroupHandler.this.assignedParticipants.add(this.getData());
            }
        }
    }

    private class AssignedGroupsHandler
    extends BaseSourceHandler {
        public AssignedGroupsHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("groupId".equals(name)) {
                return new GroupAssignmentHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class GroupAssignmentHandler
        extends DataElementHandler {
            public GroupAssignmentHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                GroupHandler.this.assignedGroups.add(this.getData());
            }
        }
    }
}

