/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.data.CalendarRuleData;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import org.xml.sax.SAXException;

class CalendarRuleHandler
extends BaseSourceHandler {
    private CalendarRuleData calendarRuleData;
    private String id;
    private Set<String> ous = new HashSet<String>();

    CalendarRuleHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        if ("properties".equals(name)) {
            return new PropertiesHandler(this);
        }
        if ("ous".equals(name)) {
            return new OrganizationalUnitsHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            CalendarRule cr = container.createCalendarRule(this.id);
            CalendarRule.Mutable calendarRule = cr.asMutable();
            if (!this.ous.isEmpty()) {
                for (String ouId : this.ous) {
                    CalendarRuleAssignment.Mutable calendarRuleAssignment = calendarRule.asMutable().createCalendarRuleAssignment();
                    calendarRuleAssignment.setOrganizationalUnit("/" + ouId);
                    calendarRule.addCalendarRuleAssignment(calendarRuleAssignment);
                }
            }
            calendarRule.setTimeZone(this.calendarRuleData.timeZone);
            calendarRule.setWorkWeek(this.calendarRuleData.workWeek);
            String holidayRuleId = this.calendarRuleData.holidayRule;
            if (!ProjectMsg.NONE.getString().equals(holidayRuleId) && !ProjectMsg.NONE.getString().toUpperCase().equals(holidayRuleId)) {
                HolidayRuleAssignment.Mutable holidayRuleAssignment = calendarRule.createHolidayRuleAssignment();
                holidayRuleAssignment.setHolidayRule(holidayRuleId);
                calendarRule.addHolidayRuleAssignment(holidayRuleAssignment);
            }
            this.getParseListener().objectParsed(this, calendarRule);
        }
        catch (ProjectException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private class PropertiesHandler
    extends DataElementHandler {
        public PropertiesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            CalendarRuleHandler.this.calendarRuleData = CalendarRuleData.valueOf((String)this.getData());
        }
    }

    private class OrganizationalUnitsHandler
    extends BaseSourceHandler {
        public OrganizationalUnitsHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("value".equals(name)) {
                return new OrganizationalUnitHandler(this);
            }
            return new BaseSourceHandler(this);
        }
    }

    private class OrganizationalUnitHandler
    extends DataElementHandler {
        public OrganizationalUnitHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            CalendarRuleHandler.this.ous.add(this.getData());
        }
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            CalendarRuleHandler.this.id = this.getData();
        }
    }
}

