/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.documentation;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ComponentType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ContentType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.DescriptionType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.DescriptionsType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.DocumentationAudienceEnum;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.DocumentationType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.DocumentationsType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.LabelType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.LabelsType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ProcessDocumentation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.TopicDocumentationType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.TopicDocumentationsType;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.util.Locales;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

public class DocumentationFileLoader {
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});

    private DocumentationFileLoader() {
    }

    public static void loadDocumentationFor(@NotNull Process process, @NotNull VFile processFile) throws ProjectException {
        ProjectFileSystem fileSystem = process.getProject().getWriter().getProjectFileSystem();
        VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
        VFile docFile = dataFileSystem.createFile(dataFileSystem.getRoot(), DocumentationFileGenerator.generateDocumentationFileName(process));
        if (docFile.exists()) {
            DocumentationFileLoader.loadDocumentationFrom(docFile, process);
        } else {
            VFile oldDocFile = dataFileSystem.createFile(processFile.getParentFile(), DocumentationFileGenerator.generateOldDocumentationFileName(process));
            if (oldDocFile.exists()) {
                DocumentationFileLoader.loadDocumentationFrom(oldDocFile, process);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadDocumentationFromTemp(@NotNull File docFile, @NotNull Process process) throws ProjectException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(docFile);
            JAXBContext jc = JAXB_CONTEXT;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal((InputStream)fileInputStream);
            if (unmarshalledObject instanceof ProcessDocumentation) {
                TreeMap<String, FlowElement> idMap = DocumentationFileLoader.generateIdsMapFrom(process);
                DocumentationFileLoader.loadDocumentationFrom((ProcessDocumentation)unmarshalledObject, process, idMap);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)process, e2);
                }
                catch (JAXBException e3) {
                    throw ProjectException.wrap((ProjectObject)process, e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadDocumentationFrom(@NotNull VFile docFile, @NotNull Process process) throws ProjectException {
        VFileInputStream fileInputStream = null;
        try {
            fileInputStream = new VFileInputStream(docFile);
            JAXBContext jc = JAXB_CONTEXT;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal((InputStream)fileInputStream);
            if (unmarshalledObject instanceof ProcessDocumentation) {
                TreeMap<String, FlowElement> idMap = DocumentationFileLoader.generateIdsMapFrom(process);
                DocumentationFileLoader.loadDocumentationFrom((ProcessDocumentation)unmarshalledObject, process, idMap);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)process, e2);
                }
                catch (JAXBException e3) {
                    throw ProjectException.wrap((ProjectObject)process, e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
    }

    private static void loadDocumentationFrom(ProcessDocumentation processDocumentation, Process process, TreeMap<String, FlowElement> idMap) {
        List<ComponentType> componentTypeList = processDocumentation.getComponent();
        assert (componentTypeList.size() == 1);
        ComponentType componentType = componentTypeList.get(0);
        TopicDocumentationsType topicDocumentations = componentType.getTopicDocumentations();
        for (TopicDocumentationType topicDocumentation : topicDocumentations.getTopicDocumentation()) {
            DocumentationFileLoader.loadDocumentationFrom(topicDocumentation, idMap);
        }
    }

    private static void loadDocumentationFrom(TopicDocumentationType topicDocumentationType, TreeMap<String, FlowElement> idMap) {
        String id = topicDocumentationType.getName();
        Localizable localizable = idMap.get(id);
        if (localizable != null) {
            DocumentationFileLoader.loadLabelsFrom(topicDocumentationType.getLabels(), localizable.getLabelMap());
            DocumentationFileLoader.loadDescriptionFrom(topicDocumentationType.getDescriptions(), localizable.getDescriptionMap());
            DocumentationFileLoader.loadDocumentationsFrom(topicDocumentationType.getDocumentations(), localizable);
        }
    }

    private static void loadDocumentationsFrom(DocumentationsType documentations, Localizable localizable) {
        if (documentations != null) {
            LocaleStringMap docMap = localizable.getDocumentationMap();
            LocaleStringMap useCaseDocMap = localizable.getUseCaseDocumentationMap();
            for (DocumentationType documentation : documentations.getDocumentation()) {
                ContentType content = documentation.getContent();
                String stringContent = null;
                if (content != null) {
                    stringContent = content.getContent();
                }
                Locale locale = Locales.valueOf((String)documentation.getLocale());
                if (documentation.getType() == DocumentationAudienceEnum.DOCUMENTATION) {
                    docMap.put(locale, stringContent);
                    continue;
                }
                useCaseDocMap.put(locale, stringContent);
            }
        }
    }

    private static void loadDescriptionFrom(DescriptionsType descriptions, LocaleStringMap descriptionsMap) {
        if (descriptions != null) {
            for (DescriptionType description : descriptions.getDescription()) {
                descriptionsMap.put(Locales.valueOf((String)description.getLocale()), description.getValue());
            }
        }
    }

    private static void loadLabelsFrom(LabelsType labels, LocaleStringMap labelsMap) {
        if (labels != null) {
            for (LabelType label : labels.getLabel()) {
                labelsMap.put(Locales.valueOf((String)label.getLocale()), label.getValue());
            }
        }
    }

    private static TreeMap<String, FlowElement> generateIdsMapFrom(NodeContainer nodeContainer) {
        TreeMap<String, FlowElement> idMap = new TreeMap<String, FlowElement>();
        idMap.put(nodeContainer.getId(), nodeContainer);
        for (FlowElement flowElement : nodeContainer.getDescendants(FlowElement.class)) {
            String id;
            if (!DocumentationFileLoader.hasDocumentation(flowElement) || (id = flowElement.getId()) == null) continue;
            idMap.put(id, flowElement);
        }
        return idMap;
    }

    private static boolean hasDocumentation(FlowElement flowElement) {
        return flowElement instanceof Activity || flowElement instanceof Event || flowElement instanceof Gateway || flowElement instanceof SequenceFlow;
    }
}

