/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.DOMTransformer;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XMLModelTransformerMetadata
public class XMLModelTransformer20111228
extends DOMTransformer {
    @Override
    public Integer getToVersion() {
        return 20111228;
    }

    @Override
    protected void transform(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        this.fixXPathNamespaces(document, xPath);
    }

    @Override
    protected Map<String, String> getCurrentVersionNamespacesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        result.put("bpmnext", "http://xmlns.oracle.com/bpm/OracleExtensions");
        return result;
    }

    private void fixXPathNamespaces(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"System faults conversion...");
        String expression = "//bpmn:complexBehaviorDefinition/bpmn:condition | ";
        expression = expression + "//bpmn:dataAssociation/bpmn:transformation | ";
        expression = expression + "//bpmn:loopCharacteristics/bpmn:loopCardinality | ";
        expression = expression + "//bpmn:loopCharacteristics/bpmn:completionCondition | ";
        expression = expression + "//bpmn:loopCharacteristics/bpmn:loopCondition | ";
        expression = expression + "//bpmn:sequenceFlow/bpmn:conditionExpression | ";
        expression = expression + "//bpmn:timerEventDefinition/bpmn:timeDate | ";
        expression = expression + "//bpmn:timerEventDefinition/bpmn:timeDuration | ";
        expression = expression + "//bpmn:timerEventDefinition/bpmn:timeCycle | ";
        expression = expression + "//bpmn:assignment/bpmn:from | ";
        expression = expression + "//bpmn:assignment/bpmn:to | ";
        expression = expression + "//bpmn:complexGateway/bpmn:activationCondition | ";
        expression = expression + "//bpmnext:AttributeExpression | ";
        expression = expression + "//bpmnext:ServiceProperty/bpmnext:expression | ";
        expression = expression + "//bpmnext:LogHandler/bpmnext:expression";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            NamedNodeMap attributesMap = element.getAttributes();
            ArrayList<XMLAttr> attributes = new ArrayList<XMLAttr>();
            for (int i = 0; i < attributesMap.getLength(); ++i) {
                XMLAttr attribute = (XMLAttr)attributesMap.item(i);
                if (!"xmlns".equals(attribute.getPrefix())) continue;
                attributes.add(attribute);
            }
            if (attributes.isEmpty()) continue;
            element.setAttribute("xmlns:xpathns", "http://xmlns.oracle.com/bpm/XPathNamespace");
            for (XMLAttr attribute : attributes) {
                String newAttributeName = "xpathns:" + attribute.getNodeLocalName();
                String newAttributeValue = attribute.getNodeValue();
                element.setAttribute(newAttributeName, newAttributeValue);
                element.removeAttribute(attribute.getName());
            }
            Element oracleExtension = this.getChildElement(element, "OracleExtensions");
            if (oracleExtension == null) continue;
            Element extensionElement = this.getChildElement(element, "extensionElements");
            if (extensionElement == null) {
                extensionElement = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), "extensionElements");
                element.appendChild(extensionElement);
            }
            document.renameNode((Node)oracleExtension, "http://xmlns.oracle.com/bpm/OracleExtensions", oracleExtension.getLocalName());
            Element expressionExtension = this.getChildElement(oracleExtension, "Expression");
            if (expressionExtension != null) {
                document.renameNode((Node)expressionExtension, "http://xmlns.oracle.com/bpm/OracleExtensions", expressionExtension.getLocalName());
            }
            extensionElement.appendChild(oracleExtension);
        }
    }

    private Element getChildElement(@NotNull Element element, @NotNull String childName) {
        Element result = null;
        NodeList childrenResult = element.getElementsByTagName(childName);
        for (int i = 0; i < childrenResult.getLength(); ++i) {
            Node item = childrenResult.item(i);
            if (!(item instanceof Element)) continue;
            result = (Element)item;
            break;
        }
        return result;
    }
}

