/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation.transformers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.DOMTransformer;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XMLModelTransformerMetadata
public class XMLModelTransformer20110501
extends DOMTransformer {
    @Override
    public Integer getToVersion() {
        return 20110501;
    }

    @Override
    protected void transform(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        this.fixEventParticipant(document, xPath);
    }

    @Override
    protected Map<String, String> getCurrentVersionNamespacesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        result.put("bpmnext", "http://xmlns.oracle.com/bpm/OracleExtensions");
        return result;
    }

    private void fixEventParticipant(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Event Participant conversion...");
        String expression = "//bpmnext:Participant";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            Element messageEventDefinition;
            Node messageEventNode;
            Node extensionElementsNode;
            Node oracleExtensionsNode = element.getParentNode();
            if (oracleExtensionsNode == null || (extensionElementsNode = oracleExtensionsNode.getParentNode()) == null || (messageEventNode = extensionElementsNode.getParentNode()) == null || (messageEventDefinition = this.getElement(messageEventNode, xPath, "bpmn:messageEventDefinition")) == null) continue;
            String ref = element.getAttribute("id");
            if (!Str.isEmpty((String)ref)) {
                messageEventDefinition.setAttribute("messageRef", ref);
            }
            oracleExtensionsNode.removeChild(element);
        }
    }
}

