/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation.transformers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.DOMTransformer;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.XMLNamespaceTranslator;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XMLModelTransformerMetadata
public class XMLModelTransformer20110401
extends DOMTransformer {
    @Override
    public Integer getToVersion() {
        return 20110401;
    }

    @Override
    protected void transform(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        this.fixNamespace(document);
        this.fixDataInputOutput(document, xPath);
        this.fixScriptTaskLanguage(document, xPath);
        this.fixLanes(document, xPath);
        this.fixActivityPerformer(document, xPath);
        this.fixErrorEventDefinition(document, xPath);
        this.fixLoopDataInputOutput(document, xPath);
        this.fixServiceTask(document, xPath);
        this.fixGatewayDirection(document, xPath);
        this.fixOracleExtensions(document, xPath);
        this.fixOldMetadata(document, xPath);
        this.fixArtifacts(document, xPath);
    }

    @Override
    protected Map<String, String> getCurrentVersionNamespacesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        result.put("bpmnext", "http://xmlns.oracle.com/bpm/OracleExtensions");
        return result;
    }

    private void fixNamespace(@NotNull XMLDocument document) {
        new XMLNamespaceTranslator().addTranslation(null, "http://www.omg.org/spec/BPMN/20100524/MODEL").addTranslation("", "http://www.omg.org/spec/BPMN/20100524/MODEL").addTranslation("http://www.omg.org/bpmn20", "http://www.omg.org/spec/BPMN/20100524/MODEL").translateNamespaces((Document)document);
    }

    private void fixDataInputOutput(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"DataInput & DataOutput conversion...");
        String expression = "//bpmn:inputSet | //bpmn:outputSet";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.clearChildrenElements(element);
        }
        expression = "//bpmn:dataInput | //bpmn:dataOutput";
        elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.replaceAttribute(document, element, "structureDefinitionRef", "itemSubjectRef");
        }
    }

    private void fixScriptTaskLanguage(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Script task language conversion...");
        String expression = "//bpmn:scriptTask";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.replaceAttribute(document, element, "scriptLanguage", "scriptFormat");
        }
    }

    private void fixActivityPerformer(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Activity performer conversion...");
        String expression = "//bpmn:userTask";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.replaceAttribute(document, element, "performer", "resourceRole");
        }
    }

    private void fixLanes(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        String peopleGroupExpr;
        List<Element> peopleGroups;
        Log.logDebug((String)"Lanes conversion...");
        String processExpr = "/bpmn:definitions/bpmn:process";
        Element process = this.getElement(document, xPath, processExpr);
        if (process != null && !(peopleGroups = this.getElements(document, xPath, peopleGroupExpr = "/bpmn:definitions/bpmn:peopleGroup")).isEmpty()) {
            Element laneSet = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), "laneSet");
            laneSet.setAttribute("id", "laneSet0");
            for (Element peopleGroup : peopleGroups) {
                String laneId = peopleGroup.getAttribute("id");
                String laneName = peopleGroup.getAttribute("name");
                Element lane = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), "lane");
                lane.setAttribute("id", laneId);
                lane.setAttribute("name", laneName);
                String extensionExpr = "bpmnext:OracleExtensions";
                Element extension = this.getElement(peopleGroup, xPath, extensionExpr);
                if (extension != null) {
                    lane.appendChild(extension);
                }
                laneSet.appendChild(lane);
                peopleGroup.getParentNode().removeChild(peopleGroup);
            }
            process.insertBefore(laneSet, process.getFirstChild());
        }
    }

    private void fixErrorEventDefinition(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Error Event Definition conversion...");
        String expression = "//bpmn:errorEventDefinition";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.replaceAttribute(document, element, "errorCode", "errorRef");
            String nodeValue = element.getAttribute("errorRef");
            String newValue = null;
            if (!Str.isEmpty((String)nodeValue)) {
                int i = nodeValue.lastIndexOf("}");
                if (i == -1) {
                    i = nodeValue.lastIndexOf("|");
                }
                if (i == -1) {
                    i = 0;
                }
                if (i < nodeValue.length() - 1) {
                    newValue = nodeValue.substring(i + 1);
                }
            }
            if (newValue != null) {
                element.setAttribute("errorRef", newValue);
                continue;
            }
            element.removeAttribute("errorRef");
        }
    }

    private void fixLoopDataInputOutput(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"LoopDataInput & LoopDataOutput conversion...");
        String expression = "//bpmn:loopDataInput | //bpmn:loopDataOutput";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            Element newRef = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), element.getNodeName() + "Ref");
            String ref = element.getAttribute("id");
            newRef.setTextContent(ref);
            Node parentNode = element.getParentNode();
            parentNode.appendChild(newRef);
            parentNode.removeChild(element);
        }
    }

    private void fixServiceTask(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Service Task conversion...");
        String expression = "//bpmn:serviceTask";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            this.replaceAttribute(document, element, "serviceRef", "implementation");
        }
    }

    private void fixGatewayDirection(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Gateway Direction conversion...");
        String expression = "//*[@bpmn:gatewayDirection]";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            String value = element.getAttribute("gatewayDirection");
            element.setAttribute("gatewayDirection", Str.capitalize((String)value));
        }
    }

    private void fixOracleExtensions(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Oracle Extensions conversion...");
        String expression = "//bpmnext:OracleExtensions";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            Node parentNode = element.getParentNode();
            Element extensionElements = this.getElement(parentNode, xPath, "bpmn:extensionElements");
            if (extensionElements == null) {
                extensionElements = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), "extensionElements");
                parentNode.appendChild(extensionElements);
            }
            extensionElements.appendChild(element);
        }
    }

    private void fixOldMetadata(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Old Metadata conversion...");
        String expression = "//bpmn:dataInterface";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            element.getParentNode().removeChild(element);
        }
    }

    private void fixArtifacts(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Artifacts conversion...");
        String expression = "//bpmn:artifact/bpmnext:BusinessIndicators";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            Element artifact = (Element)element.getParentNode();
            Element extensionElements = this.getElement(artifact, xPath, "bpmn:extensionElements");
            if (extensionElements == null) {
                extensionElements = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmn"), "extensionElements");
                artifact.appendChild(extensionElements);
            }
            extensionElements.appendChild(element);
        }
    }
}

